/*
 * Decompiled with CFR 0.152.
 */
package sound;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AePlayWave
extends Thread {
    private String filename;
    private final int EXTERNAL_BUFFER_SIZE = 524288;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private static final int NORMAL = 2;
    private int curPosition = -1;

    public static void main(String[] args) {
        new AePlayWave(args[0]).start();
    }

    public AePlayWave(String wavfile) {
        this.filename = wavfile;
        this.curPosition = 2;
    }

    public AePlayWave(String wavfile, int p) {
        this.filename = wavfile;
        this.curPosition = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AudioInputStream audioInputStream = null;
        try {
            URL url = AePlayWave.class.getResource(this.filename);
            audioInputStream = AudioSystem.getAudioInputStream(url);
        }
        catch (UnsupportedAudioFileException e1) {
            e1.printStackTrace();
            return;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        catch (NullPointerException e1) {
            System.out.println("NO sound jar");
            return;
        }
        AudioFormat format = audioInputStream.getFormat();
        SourceDataLine auline = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        try {
            auline = (SourceDataLine)AudioSystem.getLine(info);
            auline.open(format);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (auline.isControlSupported(FloatControl.Type.PAN)) {
            FloatControl pan = (FloatControl)auline.getControl(FloatControl.Type.PAN);
            if (this.curPosition == 1) {
                pan.setValue(1.0f);
            } else if (this.curPosition == 0) {
                pan.setValue(-1.0f);
            }
        }
        auline.start();
        int nBytesRead = 0;
        byte[] abData = new byte[524288];
        try {
            while (nBytesRead != -1) {
                nBytesRead = audioInputStream.read(abData, 0, abData.length);
                if (nBytesRead < 0) continue;
                auline.write(abData, 0, nBytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            auline.drain();
            auline.close();
        }
    }
}

