/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit;

import hk.com.realink.feed.toolkit.ConInfo;
import hk.com.realink.feed.toolkit.RKDebug;
import hk.com.realink.feed.toolkit.pool.JDCConnectionDriver;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;

public class ConHandler {
    private static ConHandler conHandler = null;
    private HashMap conMap = new HashMap();
    private HashMap conDriverPoolMap = new HashMap();
    private HashMap conDriverMap = new HashMap();

    private ConHandler() {
    }

    public static ConHandler getInstance() {
        if (conHandler == null) {
            conHandler = new ConHandler();
        }
        return conHandler;
    }

    public synchronized void setConnection(String key, String driver, String url, String username, String password) {
        ConInfo conInfo = (ConInfo)this.conMap.get(key);
        if (conInfo == null) {
            conInfo = new ConInfo();
            this.conMap.put(key, conInfo);
        }
        conInfo.url = url;
        conInfo.username = username;
        conInfo.password = password;
        conInfo.driver = driver;
    }

    public synchronized Connection getConnection(String key) {
        ConInfo conInfo = (ConInfo)this.conMap.get(key);
        if (conInfo != null) {
            if (conInfo.con == null) {
                try {
                    String driver = (String)this.conDriverMap.get(conInfo.driver);
                    if (driver == null) {
                        Class.forName(conInfo.driver);
                        this.conDriverMap.put(conInfo.driver, conInfo.driver);
                    }
                    conInfo.con = DriverManager.getConnection(conInfo.url, conInfo.username, conInfo.password);
                    RKDebug.warning((Object)this, "[CONNECT]url=" + conInfo.url + " connected.");
                }
                catch (Exception ex) {
                    RKDebug.exception(ex);
                    this.setDisconnect(key);
                }
            }
        } else {
            RKDebug.warning((Object)this, "[CONNECT][ERROR] connection failed on " + key);
        }
        return conInfo.con;
    }

    public synchronized Connection getConnectionFromPool(String key) {
        ConInfo conInfo = (ConInfo)this.conMap.get(key);
        if (conInfo != null) {
            try {
                JDCConnectionDriver jdcDriver = (JDCConnectionDriver)this.conDriverPoolMap.get(key);
                if (jdcDriver == null) {
                    jdcDriver = new JDCConnectionDriver(conInfo.driver, conInfo.url, conInfo.username, conInfo.password);
                    this.conDriverPoolMap.put(key, jdcDriver);
                }
                conInfo.con = jdcDriver.getConnection();
                RKDebug.warning(null, "[CONNECT_POOL]url=" + conInfo.url + " connected, pool size=" + jdcDriver.getConnectionSize());
            }
            catch (Exception e2) {
                RKDebug.exception(e2);
                this.setDisconnect(key);
            }
        } else {
            RKDebug.warning(null, "[CONNECT_POOL][ERROR] connection failed on " + key);
        }
        return conInfo.con;
    }

    public synchronized boolean isConnected(String key) {
        boolean isConnected = false;
        ConInfo conInfo = (ConInfo)this.conMap.get(key);
        if (conInfo != null && conInfo.con != null) {
            isConnected = true;
        }
        return isConnected;
    }

    public synchronized void setDisconnect(String key) {
        ConInfo conInfo = (ConInfo)this.conMap.get(key);
        if (conInfo != null) {
            try {
                if (conInfo.con != null) {
                    conInfo.con.close();
                    RKDebug.warning((Object)this, "[CONNECT]url=" + conInfo.url + " disconnected.");
                }
            }
            catch (Exception ex) {
                RKDebug.exception(ex);
            }
            conInfo.con = null;
        } else {
            RKDebug.warning((Object)this, "[ERROR] disconnect failed on " + key);
        }
    }
}

