/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RKDebug {
    private static boolean m_isDebug = false;
    private static PrintWriter g_printLogger = null;
    private static PrintStream g_errLogger = null;
    private static SimpleDateFormat g_dateFormat = null;
    private static StringBuffer g_strBuff = new StringBuffer();
    private static FieldPosition fp = new FieldPosition(0);
    private static long m_logMaxSize = 99000000L;
    private static String logFileName = "sys.log";
    private static boolean isSystemOut = true;
    private static FileOutputStream fos = null;

    public static void setFileName(String fileName) {
        logFileName = fileName;
    }

    public static synchronized void setLogMaxSize(long size) {
        m_logMaxSize = size;
    }

    public static void setSystemOut(boolean isEnable) {
        isSystemOut = isEnable;
    }

    private static synchronized void open() {
        RKDebug.close();
        try {
            g_errLogger = new PrintStream(new FileOutputStream(logFileName, true), true);
            fos = new FileOutputStream(logFileName, true);
            g_printLogger = new PrintWriter(fos, true);
            RKDebug.setSystemErr(g_errLogger);
            RKDebug.setPrintLogger(g_printLogger);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RKDebug.close();
        }
    }

    private static synchronized void closeDel(File file) {
        RKDebug.close();
        try {
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static synchronized void close() {
        try {
            if (g_errLogger != null) {
                g_errLogger.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (g_printLogger != null) {
                g_printLogger.close();
            }
        }
        catch (Exception ex1) {
            // empty catch block
        }
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        g_errLogger = null;
        g_printLogger = null;
        fos = null;
    }

    private static synchronized void setSystemErr(PrintStream printstream) {
        System.setErr(printstream);
    }

    private static synchronized void setPrintLogger(PrintWriter printwriter) {
        g_printLogger = printwriter;
    }

    public static synchronized void exception(Exception e2) {
        if (e2 == null) {
            return;
        }
        StringWriter sw = new StringWriter();
        e2.printStackTrace(new PrintWriter((Writer)sw, true));
        RKDebug.warning(null, sw.toString());
    }

    public static synchronized void debug(Object obj, String s2) {
        if (m_isDebug) {
            g_strBuff.setLength(0);
            RKDebug.output(RKDebug.toTimeObjLog(obj, s2, g_strBuff).toString());
        }
    }

    public static synchronized void debug(String s2) {
        if (m_isDebug) {
            g_strBuff.setLength(0);
            RKDebug.output(RKDebug.toTimeObjLog(null, s2, g_strBuff).toString());
        }
    }

    public static synchronized void warning(Object obj, String s2) {
        g_strBuff.setLength(0);
        RKDebug.output(RKDebug.toTimeObjLog(obj, s2, g_strBuff).toString());
    }

    public static boolean isDebug() {
        return m_isDebug;
    }

    public static synchronized void setDebug(boolean isDebug) {
        m_isDebug = isDebug;
    }

    public static synchronized void outputcurp(String s2) {
        try {
            if (g_printLogger == null || g_errLogger == null) {
                RKDebug.open();
            }
            if (s2 != null) {
                if (g_printLogger != null) {
                    g_printLogger.print(s2);
                }
                if (isSystemOut) {
                    System.out.print(s2);
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            RKDebug.close();
        }
    }

    public static synchronized void output(String s2) {
        try {
            if (g_printLogger == null || g_errLogger == null) {
                RKDebug.open();
            }
            if (s2 != null) {
                if (g_printLogger != null) {
                    g_printLogger.println(s2);
                }
                if (isSystemOut) {
                    System.out.println(s2);
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            RKDebug.close();
        }
    }

    public static synchronized void output(byte[] b2) {
        try {
            if (g_printLogger == null || g_errLogger == null) {
                RKDebug.open();
            }
            if (b2 != null) {
                if (fos != null) {
                    fos.write(b2);
                    fos.flush();
                }
                if (isSystemOut) {
                    ((FilterOutputStream)System.out).write(b2);
                    System.out.flush();
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            RKDebug.close();
        }
    }

    public static synchronized void warning(Object obj, byte[] byteArray) {
        g_strBuff.setLength(0);
        RKDebug.output(RKDebug.toTimeObjLog(obj, byteArray, g_strBuff));
    }

    private static byte[] toTimeObjLog(Object obj, byte[] byteArray, StringBuffer stringbuffer) {
        if (g_dateFormat != null) {
            g_dateFormat.format(new Date(), stringbuffer, fp);
        }
        if (obj != null) {
            stringbuffer.append('|').append(obj.getClass().getName());
        }
        stringbuffer.append('|');
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dis = new DataOutputStream(baos);
        try {
            dis.writeBytes(stringbuffer.toString());
            dis.write(byteArray);
            dis.flush();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return baos.toByteArray();
    }

    private static StringBuffer toTimeObjLog(Object obj, String s2, StringBuffer stringbuffer) {
        if (g_dateFormat != null) {
            g_dateFormat.format(new Date(), stringbuffer, fp);
        }
        if (obj != null) {
            stringbuffer.append('|').append(obj.getClass().getName());
        }
        stringbuffer.append('|').append(s2);
        return stringbuffer;
    }

    public static void main(String[] args) {
        byte[] datas = new String("How are you").getBytes();
        while (true) {
            RKDebug.warning(null, "[CALLDBF_CHANNEL][SUCCESS]pagemsg=[".getBytes());
            RKDebug.output(datas);
            RKDebug.output("], pageNo=1");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    static {
        try {
            g_dateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
        }
        catch (Exception ex) {
            // empty catch block
        }
        Thread thd = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        File file = new File(logFileName);
                        if (file.length() > m_logMaxSize) {
                            RKDebug.closeDel(file);
                            RKDebug.open();
                            RKDebug.warning(null, "log file name : " + logFileName + ", max size : " + m_logMaxSize);
                        } else {
                            RKDebug.open();
                        }
                    }
                    catch (Exception ex1) {
                        ex1.printStackTrace();
                    }
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        });
        thd.setDaemon(true);
        thd.setPriority(1);
        thd.start();
    }
}

