/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.channel;

import hk.com.realink.feed.toolkit.channel.MonItem;
import hk.com.realink.login.Message;
import hk.com.realink.login.client.Handler;
import java.util.HashMap;
import monitor.KeepAlive;

public class MonitorFactory {
    private static KeepAlive keepAlive = null;
    private static Handler myHandler = null;
    private static HashMap monitorHash = new HashMap();

    public static void setHandler(short serverType, int periodCheck, Handler monHandler) {
        keepAlive = new KeepAlive(serverType, periodCheck, monHandler);
    }

    public static KeepAlive getKeepAlive(int processId, String msg, int periodSend) throws Exception {
        if (keepAlive == null) {
            throw new Exception("KeepAlive is not be initialization");
        }
        keepAlive.add(processId, msg, periodSend);
        return keepAlive;
    }

    public static void setHandler(short serverType, int periodCheck) {
        if (keepAlive != null) {
            keepAlive.keepAliveStop();
        }
        if (myHandler != null) {
            myHandler.handleStop();
        }
        keepAlive = new KeepAlive(serverType, periodCheck, null);
    }

    public static synchronized void setKeepAlive(String key, int monId, String title, int heartBeatPeriod) throws Exception {
        if (keepAlive == null) {
            throw new Exception("KeepAlive is not be initialization");
        }
        keepAlive.add(monId, title, heartBeatPeriod);
        MonItem monItem = new MonItem();
        monItem.key = key;
        monItem.monId = monId;
        monItem.title = title;
        monItem.heartbeatperiod = heartBeatPeriod;
        monitorHash.put(monItem.key, monItem);
    }

    public static synchronized void sendRunning(String key) throws Exception {
        MonItem item = (MonItem)monitorHash.get(key);
        if (item == null) {
            throw new Exception("KeepAlive not exist MonItem for key : " + key);
        }
        keepAlive.running(item.monId);
    }

    public static synchronized void sendError(String key, String errorMsg) throws Exception {
        MonItem item = (MonItem)monitorHash.get(key);
        if (item == null) {
            throw new Exception("KeepAlive not exist MonItem for key : " + key);
        }
        keepAlive.error(item.monId, errorMsg);
    }

    public static void inital(short server, String host, int port, String user, String password, int periodCheck) {
        if (myHandler != null) {
            myHandler.handleStop();
        }
        if (keepAlive != null) {
            keepAlive.keepAliveStop();
        }
        if (host != null) {
            myHandler = new Handler(host, port, user, password, 0, 5, false){

                public void handle(Message msg) {
                }
            };
            myHandler.connect();
            myHandler.start();
            keepAlive = new KeepAlive(server, periodCheck, myHandler);
        } else {
            keepAlive = new KeepAlive(server, periodCheck, null);
        }
    }

    public static void main(String[] args) {
        try {
            MonitorFactory.inital((short)8, "128.0.0.10", 9210, "", "", 10);
            MonitorFactory.setKeepAlive("PROCESS_A_DATA", 505, "Process A", 20);
            MonitorFactory.setKeepAlive("PROCESS_B_DATA", 506, "Process B", 20);
            MonitorFactory.setKeepAlive("PROCESS_C_DATA", 507, "Process C", 20);
            int count = 1;
            while (true) {
                MonitorFactory.sendRunning("PROCESS_A_DATA");
                MonitorFactory.sendRunning("PROCESS_B_DATA");
                MonitorFactory.sendRunning("PROCESS_C_DATA");
                if (count % 10 == 0) {
                    // empty if block
                }
                try {
                    Thread.sleep(1000L);
                    ++count;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return;
        }
    }
}

