/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.data;

import hk.com.realink.feed.toolkit.data.EliCal;
import hk.com.realink.feed.toolkit.data.WntRoot;

public class WntCal {
    public static void setWarrantPremium(WntRoot child) {
        if (child.wntStatic.stockType.equalsIgnoreCase("EL1") || child.wntStatic.stockType.equalsIgnoreCase("EL2") || child.wntStatic.stockType.equalsIgnoreCase("EL3")) {
            child.wntDynami.warrantPremium = EliCal.getYield((int)(child.wntDynami.ask * 1000.0f), child.wntStatic.strikePrice, child.wntStatic.outstandingDays);
        } else if (child.wntStatic.stockType.equalsIgnoreCase("SSW")) {
            child.wntDynami.warrantPremium = WntCal.calPutWarrants(child);
        } else if (child.wntStatic.stockType.equalsIgnoreCase("SBW") || child.wntStatic.stockType.equalsIgnoreCase("CW0")) {
            child.wntDynami.warrantPremium = WntCal.calCallWarrants(child);
        } else if (child.wntStatic.stockType.equalsIgnoreCase("BBW")) {
            if (child.wntStatic.callPutFlag == 'P') {
                child.wntDynami.warrantPremium = WntCal.calPutWarrants(child);
            } else if (child.wntStatic.callPutFlag == 'C') {
                child.wntDynami.warrantPremium = WntCal.calCallWarrants(child);
            }
        } else if (child.wntStatic.stockType.equalsIgnoreCase("ISW")) {
            child.wntDynami.warrantPremium = WntCal.calPutWarrants(child);
        } else if (child.wntStatic.stockType.equalsIgnoreCase("IBW")) {
            child.wntDynami.warrantPremium = WntCal.calCallWarrants(child);
        }
    }

    public static float calCallWarrants(WntRoot child) {
        return WntCal.calCallWarrants((int)(child.wntDynami.parentSctyPrice * 1000.0f), child.wntStatic.strikePrice, child.wntDynami.nominalPrice_d3, child.wntStatic.conversionRatio, child.wntStatic.pStkCurRate, child.wntStatic.strikePriceCurRate, child.wntStatic.stkCurRate);
    }

    public static float calCallWarrants(int parentSctyPrice_d3, float strikePrice, int warrantPrice_d3, float conversionRatio, float pStkCurRate, float strikePriceCurRate, float stkCurRate) {
        strikePrice *= strikePriceCurRate;
        float parentSctyPrice = (float)parentSctyPrice_d3 * pStkCurRate / 1000.0f;
        float warrantPrice = (float)warrantPrice_d3 * stkCurRate / 1000.0f;
        if (conversionRatio > 0.0f && parentSctyPrice > 0.0f) {
            return (strikePrice + warrantPrice / conversionRatio - parentSctyPrice) / parentSctyPrice;
        }
        return 0.0f;
    }

    public static float calPutWarrants(WntRoot child) {
        return WntCal.calPutWarrants((int)(child.wntDynami.parentSctyPrice * 1000.0f), child.wntStatic.strikePrice, child.wntDynami.nominalPrice_d3, child.wntStatic.conversionRatio, child.wntStatic.pStkCurRate, child.wntStatic.strikePriceCurRate, child.wntStatic.stkCurRate);
    }

    public static float calPutWarrants(int parentSctyPrice_d3, float strikePrice, int warrantPrice_d3, float conversionRatio, float pStkCurRate, float strikePriceCurRate, float stkCurRate) {
        strikePrice *= strikePriceCurRate;
        float parentSctyPrice = (float)parentSctyPrice_d3 * pStkCurRate / 1000.0f;
        float warrantPrice = (float)warrantPrice_d3 * stkCurRate / 1000.0f;
        if (parentSctyPrice > 0.0f) {
            return (parentSctyPrice - (strikePrice - warrantPrice / conversionRatio)) / parentSctyPrice;
        }
        return 0.0f;
    }

    public static void setGearingRatio(WntRoot child) {
        child.wntDynami.gearingRatio = WntCal.calGearingRatio((int)(child.wntDynami.parentSctyPrice * 1000.0f), child.wntDynami.nominalPrice_d3, child.wntStatic.conversionRatio);
    }

    public static float calGearingRatio(int parentSctyPrice_d3, int warrantPrice_d3, float conversionRatio) {
        float parentSctyPrice = (float)parentSctyPrice_d3 / 1000.0f;
        float warrantPrice = (float)warrantPrice_d3 / 1000.0f;
        if (conversionRatio > 0.0f && warrantPrice > 0.0f) {
            return parentSctyPrice / (warrantPrice / conversionRatio);
        }
        return 0.0f;
    }

    public static float calPeRatio(int nominalPrice_d3, float earningPerShare) {
        float nPrice = (float)nominalPrice_d3 / 1000.0f;
        float eShare = earningPerShare / 100.0f;
        if (eShare > 0.0f) {
            return nPrice / eShare;
        }
        return 0.0f;
    }

    public static void main(String[] args) {
        String expiryDate = "15/11/02";
        float strikePrice = 81.12f;
        int ask = 78750;
        float yield = EliCal.getYield(ask, strikePrice, expiryDate) * 100.0f;
        System.out.println("yield = " + yield);
    }
}

