/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.pool;

public class ObjectFIFO {
    private Object[] queue;
    private int capacity;
    private int size;
    private int head;
    private int tail;

    public ObjectFIFO(int cap) {
        this.capacity = cap > 0 ? cap : 1;
        this.queue = new Object[this.capacity];
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized boolean isFull() {
        return this.size == this.capacity;
    }

    public synchronized void add(Object obj) throws InterruptedException {
        this.waitWhileFull();
        this.queue[this.head] = obj;
        this.head = (this.head + 1) % this.capacity;
        ++this.size;
        this.notifyAll();
    }

    public synchronized void addEach(Object[] list) throws InterruptedException {
        for (int i2 = 0; i2 < list.length; ++i2) {
            this.add(list[i2]);
        }
    }

    public synchronized Object remove() throws InterruptedException {
        this.waitWhileEmpty();
        Object obj = this.queue[this.tail];
        this.queue[this.tail] = null;
        this.tail = (this.tail + 1) % this.capacity;
        --this.size;
        this.notifyAll();
        return obj;
    }

    public synchronized Object remove(long msTimeout) throws InterruptedException {
        if (this.waitWhileEmpty(msTimeout)) {
            return null;
        }
        Object obj = this.queue[this.tail];
        this.queue[this.tail] = null;
        this.tail = (this.tail + 1) % this.capacity;
        --this.size;
        this.notifyAll();
        return obj;
    }

    public synchronized Object[] removeAll() throws InterruptedException {
        Object[] list = new Object[this.size];
        for (int i2 = 0; i2 < list.length; ++i2) {
            list[i2] = this.remove();
        }
        return list;
    }

    public synchronized Object[] removeAtLeastOne() throws InterruptedException {
        this.waitWhileEmpty();
        return this.removeAll();
    }

    public synchronized boolean waitUntilEmpty(long msTimeout) throws InterruptedException {
        if (msTimeout == 0L) {
            this.waitUntilEmpty();
            return true;
        }
        long endTime = System.currentTimeMillis() + msTimeout;
        long msRemaining = msTimeout;
        while (!this.isEmpty() && msRemaining > 0L) {
            this.wait(msRemaining);
            msRemaining = endTime - System.currentTimeMillis();
        }
        return this.isEmpty();
    }

    public synchronized void waitUntilEmpty() throws InterruptedException {
        while (!this.isEmpty()) {
            this.wait();
        }
    }

    public synchronized boolean waitWhileEmpty(long msTimeout) throws InterruptedException {
        if (msTimeout == 0L) {
            this.waitWhileEmpty();
            return false;
        }
        long endTime = System.currentTimeMillis() + msTimeout;
        long msRemaining = msTimeout;
        while (this.isEmpty() && msRemaining > 0L) {
            this.wait(msRemaining);
            msRemaining = endTime - System.currentTimeMillis();
        }
        return this.isEmpty();
    }

    public synchronized void waitWhileEmpty() throws InterruptedException {
        while (this.isEmpty()) {
            this.wait();
        }
    }

    public synchronized void waitUntilFull() throws InterruptedException {
        while (!this.isFull()) {
            this.wait();
        }
    }

    public synchronized void waitWhileFull() throws InterruptedException {
        while (this.isFull()) {
            this.wait();
        }
    }
}

