/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.record;

import hk.com.realink.feed.toolkit.RKObject;
import hk.com.realink.feed.toolkit.data.Tt2;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class SCTY_TT_RAW
extends RKObject {
    private String companyCode = "0";
    private String companyShortName = "";
    private int lotSize = 0;
    private Tt2[] tts = null;

    public SCTY_TT_RAW() {
    }

    public SCTY_TT_RAW(String m_companyCode) {
        this.companyCode = m_companyCode;
    }

    public void setTtArray(Tt2[] m_tts) {
        this.tts = m_tts;
    }

    public Tt2[] getTtArray() {
        return this.tts;
    }

    public String getCompanyCode() {
        return this.companyCode;
    }

    public void setCompanyShortName(String m_companyShortName) {
        this.companyShortName = m_companyShortName;
    }

    public String getCompanyShortName() {
        return this.companyShortName;
    }

    public void setLotSize(int m_lotSize) {
        this.lotSize = m_lotSize;
    }

    public int getLotSize() {
        return this.lotSize;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            super.readExternal(in);
            this.companyCode = in.readUTF();
            this.companyShortName = in.readUTF();
            this.lotSize = in.readInt();
            int length = in.readInt();
            ArrayList<Tt2> array = new ArrayList<Tt2>(length);
            for (int i2 = 0; i2 < length; ++i2) {
                Tt2 tt = new Tt2();
                tt.sctyCode = Integer.parseInt(this.companyCode);
                tt.publicTradeType = in.readChar();
                tt.rejectFlag = in.readChar();
                tt.tickerKey = in.readInt();
                tt.tickerTime = in.readShort();
                tt.tradePrice = in.readFloat();
                tt.tradeQty = in.readInt();
                tt.orderType = in.readChar();
                array.add(tt);
            }
            this.tts = array.toArray(new Tt2[0]);
        }
        catch (IOException ioexception) {
            System.out.println("Error reading " + this.getClass().getName() + " : " + ioexception);
            throw ioexception;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            super.writeExternal(out);
            out.writeUTF(this.companyCode);
            out.writeUTF(this.companyShortName);
            out.writeInt(this.lotSize);
            out.writeInt(this.tts.length);
            for (int i2 = 0; i2 < this.tts.length; ++i2) {
                out.writeChar(this.tts[i2].publicTradeType);
                out.writeChar(this.tts[i2].rejectFlag);
                out.writeInt(this.tts[i2].tickerKey);
                out.writeShort(this.tts[i2].tickerTime);
                out.writeFloat(this.tts[i2].tradePrice);
                out.writeInt(this.tts[i2].tradeQty);
                out.writeChar(this.tts[i2].orderType);
            }
        }
        catch (IOException ioexception) {
            System.out.println("Error writing " + this.getClass().getName() + " : " + ioexception);
            throw ioexception;
        }
    }
}

