/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.histnews.history;

import hk.com.realink.histnews.history.InterRange;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class HistRecord
implements Serializable {
    static final long serialVersionUID = -1609752280599431232L;
    public static final int TYPE_DAY = 1;
    public static final int TYPE_WEEK = 2;
    public static final int TYPE_MONTH = 3;
    public static final int TYPE_INTERDAY = 8;
    public static final int LEVEL_ROOT = 4;
    public static final int LEVEL_TYPE = 5;
    public static final int LEVEL_POINT = 6;
    public static final int LEVEL_UNIT = 7;
    public static final int ADD_UNSUPPORT = -2;
    public static final int ADD_FULL = -1;
    public static final int ADD_RETRY = 0;
    public static final int ADD_SUCCESS = 1;
    public static SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    public String companyCode = "";
    public float open = 0.0f;
    public float close = 0.0f;
    public float high = 0.0f;
    public float low = 0.0f;
    public long maxTurnover = 0L;
    public long date = 0L;
    private int type = 1;
    private int level = 7;
    private ArrayList histRecordList = null;
    private HashMap daysHashMap = null;
    private int pointLevelIndex = -1;
    private int amount = 1;
    private InterRange interRange = null;

    private HistRecord() {
    }

    public HistRecord(String companyCode) {
        this.companyCode = companyCode;
    }

    public HistRecord(String companyCode, int level) {
        this.companyCode = companyCode;
        this.level = level;
    }

    public boolean isInValidDay() {
        return this.open == 0.0f && this.close == 0.0f;
    }

    private void setPointLevelIndex(int i2) {
        this.pointLevelIndex = i2;
    }

    public int getPointLevelIndex() {
        return this.pointLevelIndex;
    }

    public void setType(int type) {
        this.type = type;
    }

    private void setLevel(int level) {
        this.level = level;
    }

    public int getType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }

    public static Calendar getCalendar(long date) {
        Calendar cur = Calendar.getInstance();
        cur.setTime(new Date(date));
        return cur;
    }

    public HistRecord getBeginHistRecord() {
        if (this.histRecordList == null) {
            return null;
        }
        return (HistRecord)this.histRecordList.get(0);
    }

    public HistRecord getLastHistRecord() {
        if (this.histRecordList == null) {
            return null;
        }
        int lastIdx = this.histRecordList.size() - 1;
        if (lastIdx >= 0) {
            return (HistRecord)this.histRecordList.get(lastIdx);
        }
        return null;
    }

    public static HistRecord createMaxHistRecord(int startIndex, int endIndex, HistRecord[] hs) {
        HistRecord r2 = new HistRecord(hs[0].companyCode, hs[0].level);
        for (int i2 = startIndex; i2 <= endIndex; ++i2) {
            if (hs[i2].high > r2.high) {
                r2.high = hs[i2].high;
            }
            if (hs[i2].low < r2.low && hs[i2].low != 0.0f || r2.low == 0.0f) {
                r2.low = hs[i2].low;
            }
            if (hs[i2].open > r2.high) {
                r2.high = hs[i2].open;
            }
            if (hs[i2].close > r2.high) {
                r2.high = hs[i2].close;
            }
            if (hs[i2].open < r2.low && hs[i2].open != 0.0f) {
                r2.low = hs[i2].open;
            }
            if (hs[i2].close < r2.low && hs[i2].close != 0.0f) {
                r2.low = hs[i2].close;
            }
            if (hs[i2].maxTurnover <= r2.maxTurnover) continue;
            r2.maxTurnover = hs[i2].maxTurnover;
        }
        return r2;
    }

    private Collection getHistRecords() {
        return this.histRecordList;
    }

    public HistRecord[] toArray() {
        HistRecord[] histRecords = this.histRecordList.toArray(new HistRecord[0]);
        return histRecords;
    }

    public ArrayList getList() {
        return this.histRecordList;
    }

    public Object clone() {
        HistRecord h2 = new HistRecord(this.companyCode, this.type);
        h2.date = this.date;
        h2.close = this.close;
        h2.open = this.open;
        h2.high = this.high;
        h2.low = this.low;
        h2.maxTurnover = this.maxTurnover;
        return h2;
    }

    private void setAmount(int m2) {
        if (m2 > 0) {
            this.amount = m2;
        }
    }

    public HistRecord getTypeHistRecord(int type, int amount) {
        HistRecord typeHistRecord = null;
        Iterator dayIter = this.histRecordList.iterator();
        typeHistRecord = new HistRecord(this.companyCode, 5);
        typeHistRecord.setType(type);
        typeHistRecord.setAmount(amount);
        HistRecord pointHistRecord = null;
        int isVailableSize = -1;
        int pointCount = 0;
        HistRecord dayHistRecord = null;
        while (dayIter.hasNext()) {
            if (isVailableSize != 0) {
                dayHistRecord = (HistRecord)dayIter.next();
            }
            if (isVailableSize == -1 || isVailableSize == 0) {
                pointHistRecord = (HistRecord)dayHistRecord.clone();
                pointHistRecord.maxTurnover = 0L;
                pointHistRecord.setPointLevelIndex(pointCount++);
                pointHistRecord.setType(type);
                pointHistRecord.setLevel(6);
                pointHistRecord.setAmount(amount);
                typeHistRecord.addHistRecord(pointHistRecord);
            }
            dayHistRecord.setPointLevelIndex(pointHistRecord.getPointLevelIndex());
            isVailableSize = pointHistRecord.addHistRecord(dayHistRecord);
            typeHistRecord.addDayIndex(dayHistRecord);
        }
        return typeHistRecord;
    }

    public int getPointLevelIndex(int year, int month, int day) {
        long tmpDate;
        HistRecord h2;
        Calendar c2 = Calendar.getInstance();
        c2.setTime(new Date(0L));
        c2.set(year, month - 1, day, 0, 0, 0);
        int idx = -1;
        if (this.level == 5 && (h2 = (HistRecord)this.daysHashMap.get(new Long(tmpDate = c2.getTime().getTime()))) != null) {
            idx = h2.getPointLevelIndex();
        }
        return idx;
    }

    private void addDayIndex(HistRecord h2) {
        if (this.level == 5) {
            if (this.daysHashMap == null) {
                this.daysHashMap = new HashMap(701);
            }
            this.daysHashMap.put(new Long(h2.date), h2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int addHistRecord(HistRecord histRecord) {
        if (this.histRecordList == null) {
            this.histRecordList = new ArrayList();
        }
        boolean isValiableSize = true;
        boolean isError = false;
        if (this.level == 4) {
            if (histRecord.type == 1 && histRecord.level == 7) {
                this.histRecordList.add(histRecord);
                isValiableSize = true;
            } else {
                isError = true;
            }
        } else if (this.level == 5) {
            if (histRecord.level == 6) {
                this.histRecordList.add(histRecord);
                isValiableSize = true;
            } else {
                isError = true;
            }
        } else if (this.level == 6) {
            if (histRecord.type == 1) {
                if (this.type == 1) {
                    if (this.histRecordList.size() >= 1 * this.amount) {
                        return -1;
                    }
                    this.histRecordList.add(histRecord);
                    if (this.histRecordList.size() >= 1 * this.amount) {
                        isValiableSize = false;
                    }
                } else if (this.type == 2) {
                    if (this.histRecordList.size() >= 5 * this.amount) {
                        return -1;
                    }
                    this.maxTurnover += histRecord.maxTurnover;
                    this.histRecordList.add(histRecord);
                    if (this.histRecordList.size() >= 5 * this.amount) {
                        isValiableSize = false;
                    }
                } else if (this.type == 3) {
                    if (this.histRecordList.size() == 0) {
                        this.maxTurnover += histRecord.maxTurnover;
                        this.histRecordList.add(histRecord);
                    } else {
                        HistRecord histRecordBegin = (HistRecord)this.histRecordList.get(0);
                        Calendar calBegin = HistRecord.getCalendar(histRecordBegin.date);
                        Calendar calCur = HistRecord.getCalendar(histRecord.date);
                        if (calBegin.get(1) != calCur.get(1) || calBegin.get(2) != calCur.get(2)) return 0;
                        this.maxTurnover += histRecord.maxTurnover;
                        this.histRecordList.add(histRecord);
                    }
                } else if (this.type == 8) {
                    int size = this.histRecordList.size();
                    if (this.amount == 1 && size >= 1) {
                        return -1;
                    }
                    if (size > 0) {
                        Calendar calCur = HistRecord.getCalendar(histRecord.date);
                        if (!this.interRange.isInRange(calCur)) return 0;
                        this.maxTurnover += histRecord.maxTurnover;
                    } else if (this.amount > 1) {
                        this.interRange = new InterRange(this.amount);
                        Calendar tmp = Calendar.getInstance();
                        tmp.setTime(new Date(histRecord.date));
                        this.interRange.setTime(tmp);
                    }
                    this.histRecordList.add(histRecord);
                    if (this.amount == 1 && ++size >= 1) {
                        isValiableSize = false;
                    }
                } else {
                    isError = true;
                }
            } else {
                isError = true;
            }
        }
        if (isError) {
            System.out.println("HistRecord unsupport operation type " + this.type + " level : " + this.level);
            return -2;
        }
        if (this.open == 0.0f) {
            this.open = histRecord.open;
        }
        if (histRecord.close > 0.0f) {
            this.close = histRecord.close;
        }
        this.date = this.interRange != null ? this.interRange.endTime.getTimeInMillis() : histRecord.date;
        if (histRecord.high > this.high) {
            this.high = histRecord.high;
        }
        if ((histRecord.low < this.low || this.low <= 0.0f) && histRecord.low > 0.0f) {
            this.low = histRecord.low;
        }
        if (histRecord.maxTurnover > this.maxTurnover) {
            this.maxTurnover = histRecord.maxTurnover;
        }
        if (!isValiableSize) return -1;
        return 1;
    }

    public static void setDataTimeFormat(String pattern) {
        dateTimeFormatter = new SimpleDateFormat(pattern);
    }

    public String toDateTimeString() {
        return dateTimeFormatter.format(new Date(this.date));
    }

    public String toString() {
        String dateStr = this.toDateTimeString();
        return "companyCode = " + this.companyCode + " open = " + this.open + " close = " + this.close + " high = " + this.high + " low = " + this.low + " maxTurnover = " + this.maxTurnover + " date = " + dateStr + " type = " + this.type + " pointLevelIndex = " + this.pointLevelIndex;
    }
}

