/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.histnews.history;

import hk.com.realink.feed.toolkit.RKDebug;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class InterRange {
    private int minutes = 5;
    public Calendar startTime;
    public Calendar endTime;
    private static final SimpleDateFormat df = new SimpleDateFormat("MM-dd HH:mm:ss:SSS");

    public InterRange(int minuteUnit) {
        this.minutes = minuteUnit;
    }

    public void setTime(Calendar recTime) {
        this.startTime = (Calendar)recTime.clone();
        this.startTime.clear(13);
        this.startTime.clear(14);
        int recMin = recTime.get(12);
        int recSec = recTime.get(13);
        int recMSec = recTime.get(14);
        int startMin = 0;
        if (recMin > this.minutes) {
            int remain = recMin % this.minutes;
            startMin = remain > 0 ? recMin - remain : recMin - this.minutes;
        } else if (recMin == this.minutes) {
            startMin = recMin;
        }
        if (recMin == 0 && recSec == 0 && recMSec == 0) {
            this.startTime.add(12, -this.minutes);
        } else {
            this.startTime.set(12, startMin);
        }
        this.endTime = (Calendar)this.startTime.clone();
        this.startTime.add(13, 1);
        this.endTime.add(12, this.minutes);
        this.endTime.set(14, 999);
    }

    public boolean isInRange(Calendar recTime) {
        if (this.startTime.before(recTime) && this.endTime.after(recTime)) {
            return true;
        }
        return this.startTime.equals(recTime) || this.endTime.equals(recTime);
    }

    public String paramString() {
        return df.format(this.startTime.getTime()) + "-" + df.format(this.endTime.getTime());
    }

    public static void main(String[] args) {
        InterRange range = new InterRange(5);
        Calendar cal = Calendar.getInstance();
        cal.set(11, 9);
        cal.set(12, 45);
        cal.set(13, 0);
        cal.set(14, 0);
        while (true) {
            cal.add(12, 1);
            range.setTime(cal);
            RKDebug.output(df.format(cal.getTime()) + "---[" + range.paramString() + "], isRange=" + range.isInRange(cal));
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
            }
        }
    }
}

