/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAbstractProjector;
import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvAxisTransformer;
import ilog.views.chart.IlvAxisTransformerException;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.data.IlvDataPoints;
import ilog.views.chart.util.internal.IlvMathUtil;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;

class IlvCartesianProjector
extends IlvAbstractProjector {
    private static boolean a;
    private double b = 1.0;

    public IlvCartesianProjector() {
    }

    public IlvCartesianProjector(boolean bl) {
        this.a(bl);
    }

    double b() {
        return this.b;
    }

    void a(double d2) {
        this.b = d2;
    }

    void a(Rectangle rectangle, IlvAxis ilvAxis, IlvAbstractProjector.DataPos dataPos) {
        if (this.a(ilvAxis)) {
            dataPos.a = rectangle.x;
            dataPos.b = rectangle.x + rectangle.width - 1;
        } else {
            dataPos.a = rectangle.y + rectangle.height - 1;
            dataPos.b = rectangle.y;
        }
    }

    void a(Rectangle rectangle, IlvAxis ilvAxis, IlvAbstractProjector.DataPos dataPos, IlvAbstractProjector.Coefficient coefficient) {
        IlvDataInterval ilvDataInterval = ilvAxis.getTVisibleRange();
        double d2 = ilvDataInterval.getLength();
        if (IlvMathUtil.isNear0(d2)) {
            coefficient.a = 0.0;
            coefficient.b = dataPos.a;
        } else {
            coefficient.a = (dataPos.b - dataPos.a) / d2;
            coefficient.b = -ilvDataInterval.getMin() * coefficient.a + dataPos.a;
        }
    }

    void b(Rectangle rectangle, IlvAxis ilvAxis, IlvAbstractProjector.DataPos dataPos, IlvAbstractProjector.Coefficient coefficient) {
        IlvDataInterval ilvDataInterval = ilvAxis.getTVisibleRange();
        double d2 = dataPos.b - dataPos.a;
        if (IlvMathUtil.isNear0(d2)) {
            coefficient.a = 0.0;
            coefficient.b = ilvDataInterval.getMin();
        } else {
            coefficient.a = ilvDataInterval.getLength() / d2;
            coefficient.b = ilvDataInterval.getMin() - dataPos.a * coefficient.a;
        }
    }

    public void toDisplay(IlvDoublePoints ilvDoublePoints, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        super.toDisplay(ilvDoublePoints, rectangle, ilvCoordinateSystem);
        if (this.a()) {
            double[] dArray = ilvDoublePoints.getXValues();
            ilvDoublePoints.c = ilvDoublePoints.getYValues();
            ilvDoublePoints.d = dArray;
        }
    }

    public void toData(IlvDoublePoints ilvDoublePoints, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        if (this.a()) {
            double[] dArray = ilvDoublePoints.getXValues();
            ilvDoublePoints.c = ilvDoublePoints.getYValues();
            ilvDoublePoints.d = dArray;
        }
        super.toData(ilvDoublePoints, rectangle, ilvCoordinateSystem);
    }

    public Rectangle toRectangle(IlvDataWindow ilvDataWindow, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        if (ilvDataWindow.xRange.equals(ilvCoordinateSystem.getXAxis().getVisibleRange()) && ilvDataWindow.yRange.equals(ilvCoordinateSystem.getYAxis().getVisibleRange())) {
            return new Rectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
        return super.toRectangle(ilvDataWindow, rectangle, ilvCoordinateSystem);
    }

    void a(IlvDoublePoints ilvDoublePoints, Rectangle rectangle, IlvAbstractProjector.Coefficient coefficient, IlvAbstractProjector.Coefficient coefficient2) {
        int n2 = ilvDoublePoints.size();
        if (a && n2 > 1000 && this.b > 0.0) {
            double d2 = coefficient.a;
            double d3 = coefficient.b;
            double d4 = coefficient2.a;
            double d5 = coefficient2.b;
            double d6 = Math.abs(this.b / d2);
            double d7 = Math.abs(this.b / d4);
            double[] dArray = ilvDoublePoints.getXValues();
            double[] dArray2 = ilvDoublePoints.getYValues();
            int[] nArray = ilvDoublePoints instanceof IlvDataPoints ? ((IlvDataPoints)ilvDoublePoints).getIndices() : null;
            double d8 = dArray[0] + d6;
            double d9 = dArray2[0] - d7;
            double d10 = dArray2[0] + d7;
            dArray[0] = dArray[0] * d2 + d3;
            dArray2[0] = dArray2[0] * d4 + d5;
            int n3 = 1;
            for (int i2 = 1; i2 < n2; ++i2) {
                double d11 = dArray[i2];
                double d12 = dArray2[i2];
                if (!(d11 > d8) && !(d12 > d10) && !(d12 < d9)) continue;
                dArray[n3] = d11 * d2 + d3;
                dArray2[n3] = d12 * d4 + d5;
                if (nArray != null) {
                    nArray[n3] = nArray[i2];
                }
                d8 = d11 + d6;
                d9 = d12 - d7;
                d10 = d12 + d7;
                ++n3;
            }
            ilvDoublePoints.b = n3;
        } else {
            super.a(ilvDoublePoints, rectangle, coefficient, coefficient2);
        }
    }

    public Shape getShape(IlvDataWindow ilvDataWindow, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        return this.toRectangle(ilvDataWindow, rectangle, ilvCoordinateSystem);
    }

    public Shape getShape(double d2, IlvDataInterval ilvDataInterval, int n2, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(2);
        if (n2 == 1) {
            ilvDoublePoints.add(d2, ilvDataInterval.getMin());
            ilvDoublePoints.add(d2, ilvDataInterval.getMax());
            this.toDisplay(ilvDoublePoints, rectangle, ilvCoordinateSystem);
        } else {
            ilvDoublePoints.add(ilvDataInterval.getMin(), d2);
            ilvDoublePoints.add(ilvDataInterval.getMax(), d2);
            this.toDisplay(ilvDoublePoints, rectangle, ilvCoordinateSystem);
        }
        Line2D.Double double_ = new Line2D.Double(ilvDoublePoints.getX(0), ilvDoublePoints.getY(0), ilvDoublePoints.getX(1), ilvDoublePoints.getY(1));
        return double_;
    }

    public void getOrigin(Rectangle rectangle, IlvDoublePoint ilvDoublePoint) {
        ilvDoublePoint.x = rectangle.x;
        ilvDoublePoint.y = rectangle.y;
    }

    public void shiftAlongAxis(Rectangle rectangle, IlvAxis ilvAxis, IlvDoublePoint ilvDoublePoint, double d2) {
        if (ilvAxis.isReversed()) {
            d2 = -d2;
        }
        if (this.a(ilvAxis)) {
            ilvDoublePoint.x += d2;
        } else {
            ilvDoublePoint.y -= d2;
        }
    }

    public double getAxisLength(Rectangle rectangle, IlvAxis ilvAxis) {
        if (this.a(ilvAxis)) {
            return rectangle.width;
        }
        return rectangle.height;
    }

    public double getAxisAngle(IlvAxis ilvAxis) {
        if (this.a(ilvAxis)) {
            return ilvAxis.isReversed() ? 180.0 : 0.0;
        }
        return ilvAxis.isReversed() ? 270.0 : 90.0;
    }

    IlvDataInterval a(Rectangle rectangle, Rectangle rectangle2, IlvAxis ilvAxis) {
        boolean bl;
        if (rectangle.isEmpty() || rectangle2.isEmpty()) {
            return null;
        }
        boolean bl2 = this.a(ilvAxis);
        if (bl2 ? rectangle.width == rectangle2.width : rectangle.height == rectangle2.height) {
            return null;
        }
        IlvDataInterval ilvDataInterval = ilvAxis.getTVisibleRange();
        IlvAbstractProjector.DataPos dataPos = new IlvAbstractProjector.DataPos();
        this.a(rectangle, ilvAxis, dataPos);
        double d2 = dataPos.b - dataPos.a;
        this.a(rectangle2, ilvAxis, dataPos);
        double d3 = (dataPos.b - dataPos.a - d2) * ilvDataInterval.getLength() / d2;
        boolean bl3 = bl = bl2 && !ilvAxis.isReversed() || !bl2 && ilvAxis.isReversed();
        if (bl) {
            ilvDataInterval.setMax(ilvDataInterval.getMax() + d3);
        } else {
            ilvDataInterval.setMin(ilvDataInterval.getMin() - d3);
        }
        IlvAxisTransformer ilvAxisTransformer = ilvAxis.getTransformer();
        if (ilvAxisTransformer != null) {
            try {
                ilvDataInterval = ilvAxisTransformer.inverse(ilvDataInterval);
            }
            catch (IlvAxisTransformerException ilvAxisTransformerException) {
                ilvAxisTransformerException.printStackTrace();
                return null;
            }
        }
        if (ilvAxis.isBounded()) {
            if (bl) {
                double d4 = ilvAxis.getDataMax() - ilvDataInterval.getMax();
                if (d4 < 0.0) {
                    ilvDataInterval.setMin(ilvDataInterval.getMin() + d4);
                }
            } else {
                double d5 = ilvAxis.getDataMin() - ilvDataInterval.getMin();
                if (d5 > 0.0) {
                    ilvDataInterval.setMax(ilvDataInterval.getMax() + d5);
                }
            }
        }
        return ilvDataInterval;
    }

    private final boolean a(IlvAxis ilvAxis) {
        return ilvAxis.isXAxis() ? !this.a() : this.a();
    }

    static {
        try {
            a = Boolean.getBoolean("ilog.views.chart.projectionFilter");
        }
        catch (Throwable throwable) {
            a = false;
        }
    }
}

