/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvChart;
import ilog.views.chart.event.ChartAreaEvent;
import ilog.views.chart.event.ChartDrawEvent;
import ilog.views.chart.event.ChartDrawListener;
import ilog.views.chart.event.ChartListener;
import ilog.views.chart.util.IlvGraphicUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class IlvChartAreaSynchronizer
implements Serializable {
    static final String a = "_ChartAreaSync";
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    IlvChart b;
    Component c;
    int d;
    ComponentListener e = new ComponentAdapter(){

        public void componentMoved(ComponentEvent componentEvent) {
            IlvChartAreaSynchronizer.this.c();
        }

        public void componentResized(ComponentEvent componentEvent) {
            IlvChartAreaSynchronizer.this.c();
        }
    };
    ChartListener f = new ChartListener(){

        public void chartAreaChanged(ChartAreaEvent chartAreaEvent) {
            IlvChartAreaSynchronizer.this.c();
        }
    };
    ChartDrawListener g = new ChartDrawListener(){

        public void beforeDraw(ChartDrawEvent chartDrawEvent) {
        }

        public void afterDraw(ChartDrawEvent chartDrawEvent) {
            chartDrawEvent.getChart().removeChartDrawListener(this);
            IlvChartAreaSynchronizer.this.c();
        }
    };
    private boolean h = false;

    public IlvChartAreaSynchronizer(int n2) {
        this.d = n2;
    }

    public final IlvChart getChart() {
        return this.b;
    }

    public final Component getTargetComponent() {
        return this.c;
    }

    void a() {
        this.c.addComponentListener(this.e);
    }

    void b() {
        this.c.removeComponentListener(this.e);
    }

    public void plug(IlvChart ilvChart, Component component) {
        this.b = ilvChart;
        this.c = component;
        this.a();
        if (ilvChart.isShowing()) {
            this.c();
        } else {
            ilvChart.addChartDrawListener(this.g);
        }
    }

    public void unplug() {
        this.b();
        this.b.removeChartDrawListener(this.g);
    }

    void c() {
        try {
            Rectangle rectangle = this.getTargetRect();
            rectangle = SwingUtilities.convertRectangle(this.c.getParent(), rectangle, this.b.getChartArea());
            Rectangle rectangle2 = this.b.getChartArea().getDrawRect();
            Insets insets = this.a(rectangle2, rectangle);
            if (this.d == 0) {
                this.b.getChartArea().setHorizontalMargins(insets.left, insets.right);
            } else {
                this.b.getChartArea().setVerticalMargins(insets.top, insets.bottom);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    Rectangle getTargetRect() {
        Rectangle rectangle = this.c.getBounds();
        if (this.c instanceof JComponent) {
            Insets insets = ((JComponent)this.c).getInsets();
            rectangle = IlvGraphicUtil.applyInsets(rectangle, insets);
        }
        return rectangle;
    }

    Insets a(Rectangle rectangle, Rectangle rectangle2) {
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.d == 0) {
            insets.left = rectangle2.x - rectangle.x;
            insets.right = rectangle.width - rectangle2.width - insets.left;
        } else {
            insets.top = rectangle2.y - rectangle.y;
            insets.bottom = rectangle.height - rectangle2.height - insets.top;
        }
        return insets;
    }

    final ComponentListener d() {
        return this.e;
    }

    final ChartListener e() {
        return this.f;
    }

    public static void synchronize(IlvChart ilvChart, Component component) {
        IlvChartAreaSynchronizer.synchronize(ilvChart, component, new IlvChartAreaSynchronizer(0));
    }

    public static void synchronize(IlvChart ilvChart, Component component, IlvChartAreaSynchronizer ilvChartAreaSynchronizer) {
        IlvChartAreaSynchronizer.unSynchronize(ilvChart);
        ilvChartAreaSynchronizer.plug(ilvChart, component);
        ilvChart.getChartArea().putClientProperty(a, ilvChartAreaSynchronizer);
    }

    public static IlvChartAreaSynchronizer unSynchronize(IlvChart ilvChart) {
        IlvChartAreaSynchronizer ilvChartAreaSynchronizer = IlvChartAreaSynchronizer.a(ilvChart);
        if (ilvChartAreaSynchronizer != null) {
            ilvChartAreaSynchronizer.unplug();
            ilvChart.getChartArea().putClientProperty(a, null);
        }
        return ilvChartAreaSynchronizer;
    }

    static final IlvChartAreaSynchronizer a(IlvChart ilvChart) {
        return (IlvChartAreaSynchronizer)ilvChart.getChartArea().getClientProperty(a);
    }
}

