/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvDataInterval;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public final class IlvDataWindow
implements Serializable {
    public IlvDataInterval xRange;
    public IlvDataInterval yRange;

    public IlvDataWindow() {
        this(new IlvDataInterval(), new IlvDataInterval());
    }

    public IlvDataWindow(Rectangle2D rectangle2D) {
        this(rectangle2D.getX(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY(), rectangle2D.getY() + rectangle2D.getHeight());
    }

    public IlvDataWindow(double d2, double d3, double d4, double d5) {
        this(new IlvDataInterval(d2, d3), new IlvDataInterval(d4, d5));
    }

    public IlvDataWindow(IlvDataInterval ilvDataInterval, IlvDataInterval ilvDataInterval2) {
        this.xRange = ilvDataInterval;
        this.yRange = ilvDataInterval2;
    }

    public IlvDataWindow(IlvDataWindow ilvDataWindow) {
        this(new IlvDataInterval(ilvDataWindow.xRange), new IlvDataInterval(ilvDataWindow.yRange));
    }

    public void add(double d2, double d3) {
        this.xRange.add(d2);
        this.yRange.add(d3);
    }

    public void add(IlvDataWindow ilvDataWindow) {
        this.xRange.add(ilvDataWindow.xRange);
        this.yRange.add(ilvDataWindow.yRange);
    }

    public boolean intersects(IlvDataWindow ilvDataWindow) {
        return this.xRange.intersects(ilvDataWindow.xRange) && this.yRange.intersects(ilvDataWindow.yRange);
    }

    public void intersection(IlvDataWindow ilvDataWindow) {
        this.intersection(ilvDataWindow.xRange, ilvDataWindow.yRange);
    }

    public void intersection(IlvDataInterval ilvDataInterval, IlvDataInterval ilvDataInterval2) {
        this.xRange.intersection(ilvDataInterval);
        this.yRange.intersection(ilvDataInterval2);
    }

    public boolean contains(double d2, double d3) {
        return this.xRange.isInside(d2) && this.yRange.isInside(d3);
    }

    public boolean isEmpty() {
        return this.xRange.isEmpty() || this.yRange.isEmpty();
    }

    public double getXMin() {
        return this.xRange.getMin();
    }

    public double getXMax() {
        return this.xRange.getMax();
    }

    public double getYMin() {
        return this.yRange.getMin();
    }

    public double getYMax() {
        return this.yRange.getMax();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IlvDataWindow)) {
            return false;
        }
        IlvDataWindow ilvDataWindow = (IlvDataWindow)object;
        return this.xRange.equals(ilvDataWindow.xRange) && this.yRange.equals(ilvDataWindow.yRange);
    }

    public String toString() {
        return "xRange: [" + this.xRange.getMin() + "," + this.xRange.getMax() + "]   yRange : [" + this.yRange.getMin() + "," + this.yRange.getMax() + "]";
    }
}

