/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAbstractProjector;
import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.util.internal.IlvMathUtil;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

class IlvPolarProjector
extends IlvAbstractProjector {
    private double a = 0.0;
    private double b = 360.0;
    private boolean c = true;
    private boolean d = true;

    public void setSymmetric(boolean bl) {
        this.c = bl;
    }

    public boolean isSymmetric() {
        return this.c;
    }

    public double getStartingAngle() {
        return this.a;
    }

    public void setStartingAngle(double d2) {
        this.a = d2;
    }

    public double getRange() {
        return this.b;
    }

    public void setRange(double d2) {
        this.b = d2 > 360.0 || d2 < -360.0 ? IlvMathUtil.mod360(d2) : d2;
    }

    public void setSquare(boolean bl) {
        this.d = bl;
    }

    public boolean isSquare() {
        return this.d;
    }

    private void a(IlvDoublePoints ilvDoublePoints, Rectangle rectangle) {
        int n2 = ilvDoublePoints.b;
        double[] dArray = ilvDoublePoints.getXValues();
        double[] dArray2 = ilvDoublePoints.getYValues();
        double d2 = (double)rectangle.x + (double)rectangle.width / 2.0;
        double d3 = (double)rectangle.y + (double)rectangle.height / 2.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4 = dArray2[i2];
            double d5 = Math.toRadians(dArray[i2] + this.a);
            dArray[i2] = d2 + d4 * Math.cos(d5);
            dArray2[i2] = d3 - d4 * Math.sin(d5);
        }
    }

    private void b(IlvDoublePoints ilvDoublePoints, Rectangle rectangle) {
        int n2 = ilvDoublePoints.b;
        double[] dArray = ilvDoublePoints.getXValues();
        double[] dArray2 = ilvDoublePoints.getYValues();
        double d2 = (double)rectangle.x + (double)rectangle.width / 2.0;
        double d3 = (double)rectangle.y + (double)rectangle.height / 2.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4 = dArray[i2] - d2;
            double d5 = -dArray2[i2] + d3;
            dArray[i2] = Math.toDegrees(Math.atan2(d5, d4)) - this.a;
            if (dArray[i2] < 0.0) {
                int n3 = i2;
                dArray[n3] = dArray[n3] + 360.0;
            }
            dArray2[i2] = Math.sqrt(d4 * d4 + d5 * d5);
        }
    }

    public void toDisplay(IlvDoublePoints ilvDoublePoints, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        super.toDisplay(ilvDoublePoints, rectangle, ilvCoordinateSystem);
        this.a(ilvDoublePoints, rectangle);
    }

    public void toData(IlvDoublePoints ilvDoublePoints, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        this.b(ilvDoublePoints, rectangle);
        super.toData(ilvDoublePoints, rectangle, ilvCoordinateSystem);
    }

    public void shiftAlongAxis(Rectangle rectangle, IlvAxis ilvAxis, IlvDoublePoint ilvDoublePoint, double d2) {
        if (d2 == 0.0) {
            return;
        }
        double d3 = (double)rectangle.x + (double)rectangle.width / 2.0;
        double d4 = (double)rectangle.y + (double)rectangle.height / 2.0;
        if (ilvAxis.isXAxis()) {
            double d5;
            double d6;
            double d7;
            if (ilvAxis.isReversed()) {
                d2 = -d2;
            }
            if ((d7 = Math.sqrt((d6 = ilvDoublePoint.x - d3) * d6 + (d5 = -ilvDoublePoint.y + d4) * d5)) > 1.0) {
                double d8 = d2 / d7 + Math.atan2(d5, d6);
                ilvDoublePoint.x = d3 + d7 * Math.cos(d8);
                ilvDoublePoint.y = d4 - d7 * Math.sin(d8);
            }
        } else {
            double d9 = ilvDoublePoint.x - d3;
            double d10 = ilvDoublePoint.y - d4;
            double d11 = Math.sqrt(d9 * d9 + d10 * d10);
            if (d11 > 1.0) {
                d11 = d2 / d11;
                ilvDoublePoint.x += d9 * d11;
                ilvDoublePoint.y += d10 * d11;
            }
        }
    }

    public void getOrigin(Rectangle rectangle, IlvDoublePoint ilvDoublePoint) {
        ilvDoublePoint.x = (double)rectangle.x + (double)rectangle.width / 2.0;
        ilvDoublePoint.y = (double)rectangle.y + (double)rectangle.height / 2.0;
    }

    void a(Rectangle rectangle, IlvAxis ilvAxis, IlvAbstractProjector.DataPos dataPos) {
        if (ilvAxis.isXAxis()) {
            dataPos.a = 0.0;
            dataPos.b = this.b;
        } else {
            double d2 = Math.min(rectangle.width, rectangle.height);
            if (this.c) {
                dataPos.b = d2 / 2.0 - 1.0;
                dataPos.a = -dataPos.b;
            } else {
                dataPos.b = d2 / 2.0 - 1.0;
                dataPos.a = 0.0;
            }
        }
    }

    void a(Rectangle rectangle, IlvAxis ilvAxis, IlvAbstractProjector.DataPos dataPos, IlvAbstractProjector.Coefficient coefficient) {
        IlvDataInterval ilvDataInterval = ilvAxis.getTVisibleRange();
        double d2 = ilvDataInterval.getLength();
        if (IlvMathUtil.isNear0(d2)) {
            coefficient.a = 0.0;
            coefficient.b = dataPos.a;
        } else {
            if (this.isSymmetric() && !ilvAxis.isXAxis()) {
                ilvDataInterval.setMax(Math.max(Math.abs(ilvDataInterval.getMin()), Math.abs(ilvDataInterval.getMax())));
                ilvDataInterval.setMin(-ilvDataInterval.getMax());
                d2 = 2.0 * ilvDataInterval.getMax();
            }
            coefficient.a = (dataPos.b - dataPos.a) / d2;
            coefficient.b = -ilvDataInterval.getMin() * coefficient.a + dataPos.a;
        }
    }

    void b(Rectangle rectangle, IlvAxis ilvAxis, IlvAbstractProjector.DataPos dataPos, IlvAbstractProjector.Coefficient coefficient) {
        IlvDataInterval ilvDataInterval = ilvAxis.getTVisibleRange();
        double d2 = dataPos.b - dataPos.a;
        if (IlvMathUtil.isNear0(d2)) {
            coefficient.a = 0.0;
            coefficient.b = ilvDataInterval.getMin();
        } else {
            if (this.isSymmetric() && !ilvAxis.isXAxis()) {
                ilvDataInterval.setMax(Math.max(Math.abs(ilvDataInterval.getMin()), Math.abs(ilvDataInterval.getMax())));
                ilvDataInterval.setMin(-ilvDataInterval.getMax());
            }
            coefficient.a = ilvDataInterval.getLength() / (dataPos.b - dataPos.a);
            coefficient.b = ilvDataInterval.getMin() - dataPos.a * coefficient.a;
        }
    }

    public IlvDataWindow toDataWindow(Rectangle rectangle, Rectangle rectangle2, IlvCoordinateSystem ilvCoordinateSystem) {
        IlvDataWindow ilvDataWindow = new IlvDataWindow();
        boolean bl = false;
        ilvDataWindow.yRange.set(ilvCoordinateSystem.getYAxis().getVisibleMin(), ilvCoordinateSystem.getYAxis().getVisibleMax());
        if (this.isSymmetric()) {
            ilvDataWindow.xRange.set(ilvCoordinateSystem.getXAxis().getVisibleMin(), ilvCoordinateSystem.getXAxis().getVisibleMax());
            return ilvDataWindow;
        }
        IlvDoublePoint ilvDoublePoint = new IlvDoublePoint();
        this.getOrigin(rectangle2, ilvDoublePoint);
        if (rectangle.contains(ilvDoublePoint.x, ilvDoublePoint.y)) {
            bl = true;
        }
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(4);
        ilvDoublePoints.add(rectangle.x, rectangle.y);
        ilvDoublePoints.add(rectangle.x + rectangle.width, rectangle.y);
        ilvDoublePoints.add(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        ilvDoublePoints.add(rectangle.x, rectangle.y + rectangle.height);
        this.b(ilvDoublePoints, rectangle2);
        double d2 = Math.min(Math.min(ilvDoublePoints.getX(0), ilvDoublePoints.getX(1)), Math.min(ilvDoublePoints.getX(2), ilvDoublePoints.getX(3)));
        double d3 = Math.max(Math.max(ilvDoublePoints.getX(0), ilvDoublePoints.getX(1)), Math.max(ilvDoublePoints.getX(2), ilvDoublePoints.getX(3)));
        boolean bl2 = false;
        if (d3 - d2 > 180.0) {
            bl2 = true;
        }
        super.toData(ilvDoublePoints, rectangle2, ilvCoordinateSystem);
        d2 = Math.min(Math.min(ilvDoublePoints.getX(0), ilvDoublePoints.getX(1)), Math.min(ilvDoublePoints.getX(2), ilvDoublePoints.getX(3)));
        d3 = Math.max(Math.max(ilvDoublePoints.getX(0), ilvDoublePoints.getX(1)), Math.max(ilvDoublePoints.getX(2), ilvDoublePoints.getX(3)));
        if (bl || bl2) {
            ilvDataWindow.xRange.set(ilvCoordinateSystem.getXAxis().getVisibleMin(), ilvCoordinateSystem.getXAxis().getVisibleMax());
        } else {
            ilvDataWindow.xRange.set(d2, d3);
        }
        return ilvDataWindow;
    }

    public double getAxisLength(Rectangle rectangle, IlvAxis ilvAxis) {
        if (ilvAxis.isXAxis()) {
            return (double)(Math.min(rectangle.width, rectangle.height) * 360) / this.b;
        }
        return (double)Math.min(rectangle.width, rectangle.height) / 2.0;
    }

    public Shape getShape(IlvDataWindow ilvDataWindow, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(2);
        ilvDoublePoints.add(ilvDataWindow.getXMin(), ilvDataWindow.getYMin());
        ilvDoublePoints.add(ilvDataWindow.getXMax(), ilvDataWindow.getYMax());
        super.toDisplay(ilvDoublePoints, rectangle, ilvCoordinateSystem);
        ilvDoublePoints.setX(0, ilvDoublePoints.getX(0) + this.a);
        ilvDoublePoints.setX(1, ilvDoublePoints.getX(1) + this.a);
        if (this.isSymmetric()) {
            ilvDoublePoints.setY(0, 0.0);
        }
        GeneralPath generalPath = new GeneralPath();
        IlvDoublePoint ilvDoublePoint = new IlvDoublePoint();
        this.getOrigin(rectangle, ilvDoublePoint);
        double d2 = ilvDoublePoints.getX(0);
        double d3 = ilvDoublePoints.getX(1) - ilvDoublePoints.getX(0);
        Arc2D.Double double_ = new Arc2D.Double();
        double_.setArcByCenter(ilvDoublePoint.x, ilvDoublePoint.y, ilvDoublePoints.getY(1), d2, d3, 0);
        generalPath.append(double_, false);
        d2 = ilvDoublePoints.getX(1);
        double_.setArcByCenter(ilvDoublePoint.x, ilvDoublePoint.y, ilvDoublePoints.getY(0), d2, -d3, 0);
        generalPath.append(double_, true);
        generalPath.closePath();
        return generalPath;
    }

    double a(double d2, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(d2, ilvCoordinateSystem.getYAxis().getVisibleMax());
        super.toDisplay(ilvDoublePoints, rectangle, ilvCoordinateSystem);
        return ilvDoublePoints.getX(0) + this.a;
    }

    public Shape getShape(double d2, int n2, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n2 == 2 || !this.isSymmetric()) {
            return super.getShape(d2, n2, rectangle, ilvCoordinateSystem);
        }
        IlvDataInterval ilvDataInterval = ilvCoordinateSystem.getYAxis().getVisibleRange();
        ilvDataInterval.setMin(0.0);
        return this.getShape(d2, ilvDataInterval, n2, rectangle, ilvCoordinateSystem);
    }

    public Shape getShape(double d2, IlvDataInterval ilvDataInterval, int n2, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(2);
        if (n2 == 2) {
            ilvDoublePoints.add(ilvDataInterval.getMin(), d2);
            ilvDoublePoints.add(ilvDataInterval.getMax(), d2);
            super.toDisplay(ilvDoublePoints, rectangle, ilvCoordinateSystem);
            ilvDoublePoints.setX(0, ilvDoublePoints.getX(0) + this.a);
            ilvDoublePoints.setX(1, ilvDoublePoints.getX(1) + this.a);
            IlvDoublePoint ilvDoublePoint = new IlvDoublePoint();
            this.getOrigin(rectangle, ilvDoublePoint);
            double d3 = ilvDoublePoints.getX(0);
            double d4 = ilvDoublePoints.getX(1) - ilvDoublePoints.getX(0);
            Arc2D.Double double_ = new Arc2D.Double();
            double_.setArcByCenter(ilvDoublePoint.x, ilvDoublePoint.y, ilvDoublePoints.getY(1), d3, d4, 0);
            return double_;
        }
        ilvDoublePoints.add(d2, ilvDataInterval.getMin());
        ilvDoublePoints.add(d2, ilvDataInterval.getMax());
        this.toDisplay(ilvDoublePoints, rectangle, ilvCoordinateSystem);
        return new Line2D.Double(ilvDoublePoints.getX(0), ilvDoublePoints.getY(0), ilvDoublePoints.getX(1), ilvDoublePoints.getY(1));
    }
}

