/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;

public class IlvScalableFontManager
implements Serializable {
    private static HashMap a = new HashMap();
    private static HashMap b = new HashMap();
    private FontComponentListener c = new FontComponentListener();
    private FontPropertyListener d = new FontPropertyListener();
    private transient boolean e = false;
    private HashMap f = new HashMap();
    private List g = new ArrayList();
    private float h;
    private float i;
    private Dimension j;
    private boolean k = false;
    private AffineTransform l;

    public IlvScalableFontManager(Component component, Dimension dimension) {
        this(component, dimension, 0.0f, 0.0f);
    }

    public IlvScalableFontManager(Component component, Dimension dimension, float f2, float f3) {
        if (IlvScalableFontManager.getFontManager(component) != null) {
            throw new IllegalArgumentException("Component already bound to a font manager.");
        }
        this.g.add(0, component);
        a.put(component, this);
        this.a(dimension, f2, f3);
        component.addComponentListener(this.c);
        component.addPropertyChangeListener("font", this.d);
        b.put(component, component.getFont());
    }

    public void setScaleTransform(Dimension dimension, float f2, float f3) {
        this.a(dimension, f2, f3);
        this.b();
    }

    private void a(Dimension dimension, float f2, float f3) {
        if (f3 < f2) {
            throw new IllegalArgumentException("maximum ratio < min ratio !");
        }
        this.j = dimension;
        this.h = f2;
        this.i = f3;
        this.a();
    }

    public void setRefSize(Dimension dimension) {
        this.j = dimension;
        this.f.clear();
        this.a();
        this.b();
    }

    public Dimension getRefSize() {
        return this.j;
    }

    public final Component getComponent() {
        return (Component)this.g.get(0);
    }

    public final float getMinRatio() {
        return this.h;
    }

    public final float getMaxRatio() {
        return this.i;
    }

    public void setEnabled(boolean bl) {
        this.k = bl;
        this.a((Component)this.g.get(0));
    }

    public final boolean isEnabled() {
        return this.k;
    }

    private void a(Component component) {
        Font font = (Font)b.get(component);
        if (font != null) {
            this.e = true;
            component.setFont(this.getDeriveFont(font));
            this.e = false;
        }
    }

    public Font getDeriveFont(Font font) {
        if (!this.isEnabled()) {
            return font;
        }
        Font font2 = (Font)this.f.get(font);
        if (font2 == null) {
            font2 = this.a(font);
            if (font2 != null) {
                this.f.put(font, font2);
            } else {
                font2 = font;
            }
        }
        return font2;
    }

    private Font a(Font font) {
        Component component = (Component)this.g.get(0);
        if (this.j == null || font == null || component == null) {
            return null;
        }
        return font.deriveFont(this.l);
    }

    private void a() {
        float[] fArray = this.computeScaleRatios();
        this.l = AffineTransform.getScaleInstance(fArray[0], fArray[1]);
    }

    protected float[] computeScaleRatios() {
        float f2;
        float[] fArray = new float[2];
        if (this.j == null) {
            fArray[1] = 1.0f;
            fArray[0] = 1.0f;
            return fArray;
        }
        Component component = (Component)this.g.get(0);
        float f3 = this.j.width != 0 ? (float)component.getWidth() / (float)this.j.width : 1.0f;
        float f4 = f2 = this.j.height != 0 ? (float)component.getHeight() / (float)this.j.height : 1.0f;
        float f5 = f3 < 1.0f && f2 < 1.0f ? Math.max(f3, f2) : (f3 > 1.0f && f2 > 1.0f ? Math.min(f3, f2) : 1.0f);
        if (this.h != 0.0f && f5 < this.h) {
            f5 = this.h;
        } else if (this.i != 0.0f && f5 > this.i) {
            f5 = this.i;
        }
        fArray[0] = fArray[1] = f5;
        return fArray;
    }

    private void b(Component component) {
        this.f.clear();
        this.a();
        this.b();
    }

    private void b() {
        int n2 = this.g.size();
        while (--n2 >= 0) {
            Component component = (Component)this.g.get(n2);
            this.a(component);
        }
    }

    private void a(Component component, Font font) {
        b.put(component, font);
        this.a(component);
        if (component instanceof JComponent) {
            ((JComponent)component).revalidate();
        } else {
            component.invalidate();
            component.validate();
        }
        component.repaint();
    }

    public static synchronized IlvScalableFontManager getFontManager(Component component) {
        if (a.size() > 0) {
            return (IlvScalableFontManager)a.get(component);
        }
        return null;
    }

    public static synchronized void setFontManager(Component component, IlvScalableFontManager ilvScalableFontManager, Font font) throws IllegalArgumentException {
        IlvScalableFontManager ilvScalableFontManager2 = IlvScalableFontManager.getFontManager(component);
        if (ilvScalableFontManager != null && ilvScalableFontManager2 != null) {
            throw new IllegalArgumentException("Component already bound to a font manager.");
        }
        if (ilvScalableFontManager == null && ilvScalableFontManager2 != null && ilvScalableFontManager2.g.get(0) == component) {
            throw new IllegalArgumentException("Cannot unbind the reference component of a font manager. Use the dipose() method instead.");
        }
        if (ilvScalableFontManager != null) {
            ilvScalableFontManager.g.add(component);
            component.addPropertyChangeListener("font", ilvScalableFontManager.d);
            b.put(component, font);
            a.put(component, ilvScalableFontManager);
        } else if (ilvScalableFontManager2 != null) {
            ilvScalableFontManager2.g.remove(component);
            component.removePropertyChangeListener("font", ilvScalableFontManager2.d);
            b.remove(component);
            a.remove(component);
        }
    }

    public final void dispose() {
        if (this.g.size() > 0 && this.g.get(0) != null) {
            ((Component)this.g.get(0)).removeComponentListener(this.c);
        }
        int n2 = this.g.size();
        while (--n2 >= 0) {
            Component component = (Component)this.g.get(n2);
            this.g.remove(component);
            component.removePropertyChangeListener("font", this.d);
            b.remove(component);
            a.remove(component);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        ArrayList arrayList = new ArrayList(this.g.size());
        for (int i2 = 0; i2 < this.g.size(); ++i2) {
            arrayList.add(b.get(this.g.get(i2)));
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(arrayList);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        List list = (List)objectInputStream.readObject();
        for (int i2 = 0; i2 < this.g.size(); ++i2) {
            b.put(this.g.get(i2), list.get(i2));
            a.put(this.g.get(i2), this);
        }
    }

    final class FontPropertyListener
    implements PropertyChangeListener,
    Serializable {
        FontPropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!IlvScalableFontManager.this.e) {
                IlvScalableFontManager.this.a((Component)propertyChangeEvent.getSource(), (Font)propertyChangeEvent.getNewValue());
            }
        }
    }

    final class FontComponentListener
    extends ComponentAdapter
    implements Serializable {
        private Dimension a = new Dimension();
        private Dimension b = new Dimension();

        FontComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (!componentEvent.getComponent().getSize(this.a).equals(this.b)) {
                IlvScalableFontManager.this.b(componentEvent.getComponent());
                this.b.setSize(this.a);
            }
        }
    }
}

