/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.action;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.util.IlvImageUtil;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public abstract class IlvChartAction
extends AbstractAction {
    private static final String a = "Accelerator";
    private static final String b = "-";
    private IlvChart c = null;
    private int d = 0;

    public IlvChartAction(String string) {
        this(string, null, null, null, null);
    }

    public IlvChartAction(String string, Icon icon) {
        this(string, icon, null, null, null);
    }

    public IlvChartAction(String string, Icon icon, KeyStroke keyStroke) {
        this(string, icon, keyStroke, null, null);
    }

    public IlvChartAction(String string, Icon icon, KeyStroke keyStroke, String string2, String string3) {
        super(string, icon);
        this.setAccelerator(keyStroke);
        this.setShortDescription(string2);
        this.setLongDescription(string3);
        this.setEnabled(false);
    }

    public final IlvChart getChart() {
        return this.c;
    }

    public void setChart(IlvChart ilvChart) {
        if (this.c != null) {
            this.detach();
        }
        this.c = ilvChart;
        if (ilvChart != null) {
            this.attach();
        }
        this.computeEnabled();
    }

    protected void detach() {
    }

    protected void attach() {
    }

    protected void computeEnabled() {
        if (this.c == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public int getYAxisIndex() {
        return this.d;
    }

    public void setYAxisIndex(int n2) {
        this.d = n2;
    }

    public final IlvCoordinateSystem getCoordinateSystem() {
        if (this.c != null) {
            return this.c.getCoordinateSystem(this.d);
        }
        return null;
    }

    public final IlvAxis getYAxis() {
        if (this.c != null) {
            return this.c.getYAxis(this.d);
        }
        return null;
    }

    public final IlvAxis getXAxis() {
        if (this.c != null) {
            return this.c.getXAxis();
        }
        return null;
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public void setIcon(Class clazz, String string) {
        try {
            Image image = IlvImageUtil.getImageFromFile(clazz, string);
            this.setIcon(new ImageIcon(image));
        }
        catch (Exception exception) {
            System.err.println("Warning: error during read for image " + string);
        }
    }

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.getValue(a);
    }

    public String getAcceleratorText() {
        KeyStroke keyStroke = this.getAccelerator();
        if (keyStroke == null) {
            return null;
        }
        String string = "";
        int n2 = keyStroke.getModifiers();
        if (n2 > 0) {
            string = KeyEvent.getKeyModifiersText(n2);
            string = string + b;
        }
        string = string + KeyEvent.getKeyText(keyStroke.getKeyCode());
        return string;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        this.putValue(a, keyStroke);
    }

    public String getShortDescription() {
        return (String)this.getValue("ShortDescription");
    }

    public void setShortDescription(String string) {
        this.putValue("ShortDescription", string);
    }

    public String getLongDescription() {
        return (String)this.getValue("LongDescription");
    }

    public void setLongDescription(String string) {
        this.putValue("LongDescription", string);
    }

    public abstract void actionPerformed(ActionEvent var1);
}

