/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.graphic;

import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;

public class IlvGradientRenderingHint
implements IlvDataRenderingHint,
Serializable {
    private double[] a;
    private Color[] b;
    private transient int[] c;
    private transient int[] d;
    private transient int[] e;
    private transient int[] f;

    public IlvGradientRenderingHint(double[] dArray, Color[] colorArray) {
        if (dArray.length != colorArray.length) {
            throw new IllegalArgumentException("colors and values must have the same size");
        }
        if (dArray.length < 2) {
            throw new IllegalArgumentException("Gradient must be defined by at least two colors");
        }
        this.a(colorArray);
        this.a = new double[dArray.length];
        System.arraycopy(dArray, 0, this.a, 0, dArray.length);
    }

    public IlvStyle getStyle(IlvDisplayPoint ilvDisplayPoint, IlvStyle ilvStyle) {
        Color color = this.getColor(ilvDisplayPoint);
        if (ilvStyle.isFillOn()) {
            return ilvStyle.setFillPaint(color);
        }
        return ilvStyle.setStrokePaint(color);
    }

    void a(Color[] colorArray) {
        this.b = new Color[colorArray.length];
        System.arraycopy(colorArray, 0, this.b, 0, colorArray.length);
        this.b(colorArray);
    }

    private void b(Color[] colorArray) {
        int n2 = colorArray.length;
        this.c = new int[--n2];
        this.f = new int[n2];
        this.d = new int[n2];
        this.e = new int[n2];
        int n3 = colorArray[0].getRGB();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = colorArray[i2 + 1].getRGB();
            int n5 = n3 >> 24 & 0xFF;
            int n6 = n3 >> 16 & 0xFF;
            int n7 = n3 >> 8 & 0xFF;
            int n8 = n3 & 0xFF;
            this.c[i2] = (n4 >> 24 & 0xFF) - n5;
            this.f[i2] = (n4 >> 16 & 0xFF) - n6;
            this.d[i2] = (n4 >> 8 & 0xFF) - n7;
            this.e[i2] = (n4 & 0xFF) - n8;
            n3 = n4;
        }
    }

    protected Color getColor(IlvDisplayPoint ilvDisplayPoint) {
        int n2;
        double d2 = this.getValue(ilvDisplayPoint);
        int n3 = Arrays.binarySearch(this.a, d2);
        if (n3 == -1) {
            return this.b[0];
        }
        if (n3 == -this.b.length - 1) {
            return this.b[this.b.length - 1];
        }
        if (n3 >= 0) {
            return this.b[n3];
        }
        int n4 = this.b[n3 = -n3 - 2].getRGB();
        if (n4 == (n2 = this.b[n3 + 1].getRGB())) {
            return this.b[n3];
        }
        int n5 = n4 >> 24 & 0xFF;
        int n6 = n4 >> 16 & 0xFF;
        int n7 = n4 >> 8 & 0xFF;
        int n8 = n4 & 0xFF;
        double d3 = this.a[n3];
        double d4 = this.a[n3 + 1];
        float f2 = (float)((d2 - d3) / (d4 - d3));
        int n9 = (int)((float)n5 + (float)this.c[n3] * f2 + 0.5f) << 24 | (int)((float)n6 + (float)this.f[n3] * f2 + 0.5f) << 16 | (int)((float)n7 + (float)this.d[n3] * f2 + 0.5f) << 8 | (int)((float)n8 + (float)this.e[n3] * f2 + 0.5f);
        return new Color(n9);
    }

    public final double getGradientValue(int n2) {
        return this.a[n2];
    }

    public final Color getGradientColor(int n2) {
        return this.b[n2];
    }

    protected double getValue(IlvDisplayPoint ilvDisplayPoint) {
        return ilvDisplayPoint.getYData();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.b(this.b);
    }
}

