/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.interactor;

import ilog.views.chart.IlvChartDataPicker;
import ilog.views.chart.IlvChartInteractor;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.interactor.IlvChartDataInteractor;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.util.IlvChartUtil;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.util.IlvImageUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;

public class IlvChartEditPointInteractor
extends IlvChartDataInteractor {
    private static final int a = 3;
    private static Cursor b = null;
    private transient IlvDisplayPoint c;
    private transient boolean d;
    private boolean e = false;
    private boolean f = false;
    private boolean g = true;

    public IlvChartEditPointInteractor() {
        this(16, false);
    }

    public IlvChartEditPointInteractor(int n2, boolean bl) {
        this(0, n2, bl);
    }

    public IlvChartEditPointInteractor(int n2, int n3, boolean bl) {
        super(n2, n3);
        this.b();
        this.e = bl;
        this.enableEvents(56L);
        this.setXORGhost(false);
        this.c();
    }

    private void b() {
        this.d = false;
        this.c = null;
    }

    private void c() {
        if (b == null) {
            try {
                Dimension dimension = Toolkit.getDefaultToolkit().getBestCursorSize(32, 32);
                if (!(dimension.width == 32 && dimension.height == 32 || dimension.width == 64 && dimension.height == 64)) {
                    b = Cursor.getPredefinedCursor(12);
                    return;
                }
                String string = "movept_" + dimension.width + ".gif";
                Image image = IlvImageUtil.loadImageFromFile(IlvChartEditPointInteractor.class, string);
                b = IlvChartUtil.createCursor(image, new Point(8, 8), "MoveCursor", 12);
            }
            catch (Exception exception) {
                b = Cursor.getPredefinedCursor(12);
            }
        }
    }

    public final boolean isOpaqueEdit() {
        return this.e;
    }

    public void setOpaqueEdit(boolean bl) {
        this.e = bl;
    }

    public final boolean isXEditAllowed() {
        return this.f;
    }

    public void setXEditAllowed(boolean bl) {
        this.f = bl;
    }

    public final boolean isYEditAllowed() {
        return this.g;
    }

    public void setYEditAllowed(boolean bl) {
        this.g = bl;
    }

    public boolean isHandling(int n2, int n3) {
        return true;
    }

    public IlvDisplayPoint getEditPoint() {
        return this.c == null ? null : (IlvDisplayPoint)this.c.clone();
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                if ((mouseEvent.getModifiers() & this.getEventMask()) != this.getEventMask() || (mouseEvent.getModifiers() & ~this.getEventMask()) != 0) break;
                this.c = this.pickData(mouseEvent);
                if (this.c == null || !this.c.isEditable()) break;
                this.startOperation(mouseEvent);
                if (!this.e) {
                    this.drawGhost();
                }
                mouseEvent.consume();
                break;
            }
            case 502: {
                if (!this.isInOperation() || (mouseEvent.getModifiers() & this.getEventMask()) == 0) break;
                IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(mouseEvent.getX(), mouseEvent.getY());
                this.c.getRenderer().toData(ilvDoublePoints);
                this.a(ilvDoublePoints, this.c);
                if (!this.e) {
                    this.drawGhost();
                    this.c.setData(ilvDoublePoints.getX(0), ilvDoublePoints.getY(0));
                }
                this.endOperation(mouseEvent);
                mouseEvent.consume();
            }
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506 && this.isInOperation()) {
            IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(mouseEvent.getX(), mouseEvent.getY());
            this.c.getRenderer().toData(ilvDoublePoints);
            this.a(ilvDoublePoints, this.c);
            if (this.e) {
                this.c.setData(ilvDoublePoints.getX(0), ilvDoublePoints.getY(0));
            } else {
                this.drawGhost();
                this.c.getRenderer().toDisplay(ilvDoublePoints);
                this.c.set(this.c.getIndex(), ilvDoublePoints.getX(0), ilvDoublePoints.getY(0));
                this.drawGhost();
            }
            mouseEvent.consume();
        } else if (mouseEvent.getID() == 503) {
            IlvDisplayPoint ilvDisplayPoint = this.pickData(mouseEvent);
            if (ilvDisplayPoint != null && !this.d && ilvDisplayPoint.isEditable()) {
                this.setCursor(this.getCursor());
                this.d = true;
            } else if (ilvDisplayPoint == null && this.d) {
                this.setCursor(null);
                this.d = false;
            }
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27) {
            if (!this.e && this.c != null) {
                this.drawGhost();
            }
            this.abort();
            keyEvent.consume();
        }
    }

    private void a(IlvDoublePoints ilvDoublePoints, IlvDisplayPoint ilvDisplayPoint) {
        if (ilvDoublePoints.getX(0) != ilvDisplayPoint.getXData() && !this.f) {
            ilvDoublePoints.setX(0, ilvDisplayPoint.getXData());
        }
        if (ilvDoublePoints.getY(0) != ilvDisplayPoint.getYData() && !this.g) {
            ilvDoublePoints.setY(0, ilvDisplayPoint.getYData());
        }
        this.validate(ilvDoublePoints, ilvDisplayPoint);
    }

    protected void validate(IlvDoublePoints ilvDoublePoints, IlvDisplayPoint ilvDisplayPoint) {
    }

    protected Rectangle getGhostBounds() {
        Rectangle rectangle = new Rectangle(IlvGraphicUtil.toInt(this.c.getXCoord()) - 3, IlvGraphicUtil.toInt(this.c.getYCoord()) - 3, 7, 7);
        IlvDisplayPoint[] ilvDisplayPointArray = this.d();
        for (int i2 = 0; i2 < ilvDisplayPointArray.length; ++i2) {
            Double d2;
            if (ilvDisplayPointArray[i2] == null || (d2 = ilvDisplayPointArray[i2].getDataSet().getUndefValue()) != null && ilvDisplayPointArray[i2].getYData() == d2.doubleValue()) continue;
            IlvGraphicUtil.addToRect((Rectangle2D)rectangle, ilvDisplayPointArray[i2].getXCoord(), ilvDisplayPointArray[i2].getYCoord());
        }
        this.e().expand(rectangle);
        return rectangle;
    }

    protected void drawGhost(Graphics graphics) {
        IlvStyle ilvStyle = this.e();
        IlvDisplayPoint[] ilvDisplayPointArray = this.d();
        for (int i2 = 0; i2 < ilvDisplayPointArray.length; ++i2) {
            Double d2;
            if (ilvDisplayPointArray[i2] == null || (d2 = ilvDisplayPointArray[i2].getDataSet().getUndefValue()) != null && ilvDisplayPointArray[i2].getYData() == d2.doubleValue()) continue;
            ilvStyle.drawLine(graphics, ilvDisplayPointArray[i2].getXCoord(), ilvDisplayPointArray[i2].getYCoord(), this.c.getXCoord(), this.c.getYCoord());
        }
        ilvStyle.renderSquare(graphics, IlvGraphicUtil.toInt(this.c.getXCoord()), IlvGraphicUtil.toInt(this.c.getYCoord()), 3);
    }

    private IlvDisplayPoint[] d() {
        boolean bl;
        int n2 = this.c.getIndex();
        IlvDataSet ilvDataSet = this.c.getDataSet();
        IlvDisplayPoint[] ilvDisplayPointArray = null;
        int n3 = ilvDataSet.getDataCount();
        boolean bl2 = this.getChart().getType() == 4;
        boolean bl3 = bl2 && n2 == 0;
        boolean bl4 = bl2 && n2 == n3 - 1;
        boolean bl5 = n2 > 0 || bl3;
        boolean bl6 = bl = n2 < n3 - 1 || bl4;
        ilvDisplayPointArray = bl5 && bl ? new IlvDisplayPoint[2] : (bl5 || bl ? new IlvDisplayPoint[1] : new IlvDisplayPoint[]{});
        if (bl5) {
            ilvDisplayPointArray[0] = bl3 ? this.c.getRenderer().getDisplayPoint(ilvDataSet, n3 - 1) : this.c.getRenderer().getDisplayPoint(ilvDataSet, n2 - 1);
        }
        if (bl) {
            ilvDisplayPointArray[ilvDisplayPointArray.length - 1] = bl4 ? this.c.getRenderer().getDisplayPoint(ilvDataSet, 0) : this.c.getRenderer().getDisplayPoint(ilvDataSet, n2 + 1);
        }
        return ilvDisplayPointArray;
    }

    private IlvStyle e() {
        if (!this.isXORGhost() && this.c != null) {
            return this.c.getRenderer().getStyle(0);
        }
        return new IlvStyle(this.getGhostColor(), (Paint)this.getGhostColor());
    }

    protected void startOperation(MouseEvent mouseEvent) {
        super.startOperation(mouseEvent);
        if (!this.e) {
            this.setAllowDrawGhost(true);
        }
        this.setCursor(this.getCursor());
    }

    protected void endOperation(MouseEvent mouseEvent) {
        super.endOperation(mouseEvent);
        this.setAllowDrawGhost(false);
        this.setCursor(null);
        this.c = null;
        if (this.d) {
            this.setCursor(null);
            this.d = false;
        }
    }

    protected void abort() {
        super.abort();
        this.setAllowDrawGhost(false);
        this.setCursor(null);
        this.c = null;
        if (this.d) {
            this.setCursor(null);
            this.d = false;
        }
    }

    public void interactionStarted(IlvChartInteractor ilvChartInteractor, MouseEvent mouseEvent) {
        if (this.d) {
            this.setCursor(null);
            this.d = false;
        }
    }

    protected IlvChartDataPicker createDataPicker(MouseEvent mouseEvent) {
        return new IlvChartDataInteractor.DataPicker(mouseEvent.getX(), mouseEvent.getY(), 5){

            public boolean accept(IlvChartRenderer ilvChartRenderer) {
                if (!super.accept(ilvChartRenderer)) {
                    return false;
                }
                if (ilvChartRenderer instanceof IlvSingleChartRenderer) {
                    IlvDataSet ilvDataSet = ilvChartRenderer.getDataSource().getDataSet(0);
                    IlvDataSet ilvDataSet2 = (IlvDataSet)ilvDataSet.getProperty(ilvChartRenderer);
                    if (ilvDataSet2 != null) {
                        return ilvDataSet2.isEditable();
                    }
                    return ilvDataSet.isEditable();
                }
                return true;
            }
        };
    }

    protected Cursor getCursor() {
        return b;
    }

    public boolean has3DSupport() {
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.b();
    }

    static {
        IlvChartInteractor.register("EditPoint", IlvChartEditPointInteractor.class);
    }
}

