/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.interactor;

import ilog.views.chart.IlvAxisTransformer;
import ilog.views.chart.IlvAxisTransformerException;
import ilog.views.chart.IlvChartInteractor;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvLocalZoomAxisTransformer;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;

public class IlvChartLocalReshapeInteractor
extends IlvChartInteractor {
    public static final int NONE = 0;
    public static final int MIN_X_TRANSFORMER = 1;
    public static final int MAX_X_TRANSFORMER = 2;
    public static final int MIN_Y_TRANSFORMER = 3;
    public static final int MAX_Y_TRANSFORMER = 4;
    private transient int a;
    private transient IlvDoublePoints b;
    private transient boolean c;

    public IlvChartLocalReshapeInteractor() {
        this(0, 16);
    }

    public IlvChartLocalReshapeInteractor(int n2, int n3) {
        super(n2, n3);
        this.b();
        this.enableEvents(56L);
    }

    private void b() {
        this.a = 0;
        this.b = new IlvDoublePoints(0.0, 0.0);
        this.c = false;
    }

    protected IlvLocalZoomAxisTransformer getXTransformer() {
        IlvAxisTransformer ilvAxisTransformer = this.getXAxis().getTransformer();
        return ilvAxisTransformer instanceof IlvLocalZoomAxisTransformer ? (IlvLocalZoomAxisTransformer)ilvAxisTransformer : null;
    }

    protected IlvLocalZoomAxisTransformer getYTransformer() {
        IlvAxisTransformer ilvAxisTransformer = this.getYAxis().getTransformer();
        return ilvAxisTransformer instanceof IlvLocalZoomAxisTransformer ? (IlvLocalZoomAxisTransformer)ilvAxisTransformer : null;
    }

    public int getResizedBound() {
        return this.a;
    }

    protected boolean isValidStartPoint(double d2, double d3) {
        this.a = 0;
        double d4 = 0.0;
        IlvLocalZoomAxisTransformer ilvLocalZoomAxisTransformer = this.getXTransformer();
        if (ilvLocalZoomAxisTransformer != null) {
            d4 = ilvLocalZoomAxisTransformer.getZoomRange().getLength() * 5.0 / 100.0;
            if (d2 > ilvLocalZoomAxisTransformer.getZoomRange().getMin() - d4 && d2 < ilvLocalZoomAxisTransformer.getZoomRange().getMin() + d4) {
                this.a = 1;
            } else if (d2 > ilvLocalZoomAxisTransformer.getZoomRange().getMax() - d4 && d2 < ilvLocalZoomAxisTransformer.getZoomRange().getMax() + d4) {
                this.a = 2;
            }
        }
        if (this.a != 0) {
            return true;
        }
        ilvLocalZoomAxisTransformer = this.getYTransformer();
        if (ilvLocalZoomAxisTransformer != null) {
            d4 = ilvLocalZoomAxisTransformer.getZoomRange().getLength() * 5.0 / 100.0;
            if (d3 > ilvLocalZoomAxisTransformer.getZoomRange().getMin() - d4 && d3 < ilvLocalZoomAxisTransformer.getZoomRange().getMin() + d4) {
                this.a = 3;
            } else if (d3 > ilvLocalZoomAxisTransformer.getZoomRange().getMax() - d4 && d3 < ilvLocalZoomAxisTransformer.getZoomRange().getMax() + d4) {
                this.a = 4;
            }
        }
        return this.a != 0;
    }

    protected Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    protected void abort() {
        super.abort();
        if (this.a == 1 || this.a == 2) {
            this.getXAxis().setAdjusting(false);
        } else if (this.a == 3 || this.a == 4) {
            this.getYAxis().setAdjusting(false);
        }
        this.a = 0;
        this.setCursor(null);
        this.c = false;
    }

    protected void endOperation(MouseEvent mouseEvent) {
        super.endOperation(mouseEvent);
        if (this.c) {
            this.setCursor(null);
        }
        this.c = false;
        if (this.a == 1 || this.a == 2) {
            this.getXAxis().setAdjusting(false);
        } else if (this.a == 3 || this.a == 4) {
            this.getYAxis().setAdjusting(false);
        }
        this.a = 0;
    }

    protected void startOperation(MouseEvent mouseEvent) {
        super.startOperation(mouseEvent);
        if (!this.c) {
            this.setCursor(this.getCursor());
            this.c = true;
        }
        if (this.a == 1 || this.a == 2) {
            this.getXAxis().setAdjusting(true);
        } else if (this.a == 3 || this.a == 4) {
            this.getYAxis().setAdjusting(true);
        }
    }

    public boolean isHandling(int n2, int n3) {
        return true;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                if ((mouseEvent.getModifiers() & this.getEventMask()) != this.getEventMask() || (mouseEvent.getModifiers() & ~this.getEventMask()) != 0) break;
                this.b.set(0, mouseEvent.getX(), mouseEvent.getY());
                this.getChart().toData(this.b, this.getYAxisIndex());
                if (!this.isValidStartPoint(this.b.getX(0), this.b.getY(0))) break;
                this.startOperation(mouseEvent);
                this.validate(this.b);
                mouseEvent.consume();
                break;
            }
            case 502: {
                if (!this.isInOperation() || (mouseEvent.getModifiers() & this.getEventMask()) == 0) break;
                this.b.set(0, mouseEvent.getX(), mouseEvent.getY());
                this.getChart().toData(this.b, this.getYAxisIndex());
                this.validate(this.b);
                this.endOperation(mouseEvent);
                mouseEvent.consume();
                break;
            }
            case 505: {
                if (!this.c) break;
                this.setCursor(null);
                this.c = false;
            }
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 506: {
                if (!this.isInOperation()) break;
                this.b.set(0, mouseEvent.getX(), mouseEvent.getY());
                this.getChart().toData(this.b, this.getYAxisIndex());
                this.validate(this.b);
                this.reshape(this.b.getX(0), this.b.getY(0));
                mouseEvent.consume();
                break;
            }
            case 503: {
                this.b.set(0, mouseEvent.getX(), mouseEvent.getY());
                boolean bl = true;
                if (!this.getChart().getChartArea().getPlotRect().contains(mouseEvent.getX(), mouseEvent.getY())) {
                    bl = false;
                }
                if (bl) {
                    this.getChart().toData(this.b, this.getYAxisIndex());
                    bl = this.isValidStartPoint(this.b.getX(0), this.b.getY(0));
                }
                if (bl && !this.c) {
                    this.setCursor(this.getCursor());
                    this.c = true;
                    break;
                }
                if (bl || !this.c) break;
                this.setCursor(null);
                this.c = false;
                break;
            }
        }
    }

    protected void validate(IlvDoublePoints ilvDoublePoints) {
        switch (this.a) {
            case 1: 
            case 2: {
                try {
                    ilvDoublePoints.setX(0, this.getXTransformer().apply(ilvDoublePoints.getX(0)));
                    ilvDoublePoints.setY(0, this.getXTransformer().apply(ilvDoublePoints.getY(0)));
                    break;
                }
                catch (IlvAxisTransformerException ilvAxisTransformerException) {
                    ilvAxisTransformerException.printStackTrace();
                    return;
                }
            }
            case 3: 
            case 4: {
                try {
                    ilvDoublePoints.setX(0, this.getYTransformer().apply(ilvDoublePoints.getX(0)));
                    ilvDoublePoints.setY(0, this.getYTransformer().apply(ilvDoublePoints.getY(0)));
                    break;
                }
                catch (IlvAxisTransformerException ilvAxisTransformerException) {
                    ilvAxisTransformerException.printStackTrace();
                    return;
                }
            }
        }
    }

    protected void reshape(double d2, double d3) {
        IlvDataInterval ilvDataInterval = null;
        double d4 = 0.0;
        switch (this.a) {
            case 1: {
                ilvDataInterval = this.getXTransformer().getTransformedRange();
                d4 = d2 - ilvDataInterval.getMin();
                this.getXTransformer().setZoomRange(this.getXTransformer().getZoomRange().getMin() + (d4 /= this.getXTransformer().getZoomFactor()), this.getXTransformer().getZoomRange().getMax());
                break;
            }
            case 2: {
                ilvDataInterval = this.getXTransformer().getTransformedRange();
                d4 = (d2 - ilvDataInterval.getMax()) / this.getXTransformer().getZoomFactor();
                this.getXTransformer().setZoomRange(this.getXTransformer().getZoomRange().getMin(), this.getXTransformer().getZoomRange().getMax() + d4);
                break;
            }
            case 3: {
                ilvDataInterval = this.getYTransformer().getTransformedRange();
                d4 = (d3 - ilvDataInterval.getMin()) / this.getYTransformer().getZoomFactor();
                this.getYTransformer().setZoomRange(this.getYTransformer().getZoomRange().getMin() + d4, this.getYTransformer().getZoomRange().getMax());
                break;
            }
            case 4: {
                ilvDataInterval = this.getYTransformer().getTransformedRange();
                d4 = (d3 - ilvDataInterval.getMax()) / this.getYTransformer().getZoomFactor();
                this.getYTransformer().setZoomRange(this.getYTransformer().getZoomRange().getMin(), this.getYTransformer().getZoomRange().getMax() + d4);
                break;
            }
        }
    }

    public boolean has3DSupport() {
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.b();
    }

    static {
        IlvChartInteractor.register("LocalReshape", IlvChartLocalReshapeInteractor.class);
    }
}

