/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.print;

import ilog.views.chart.IlvChart;
import ilog.views.util.print.IlvFlow;
import ilog.views.util.print.IlvFlowObject;
import ilog.views.util.print.IlvUnit;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class IlvChartFlowObject
implements IlvFlowObject {
    private IlvChart a;
    private IlvUnit.Dimension b;
    private IlvFlow c;
    private double d;
    private double e;
    private float f;

    public IlvChartFlowObject(IlvChart ilvChart, IlvFlow ilvFlow, IlvUnit.Dimension dimension) {
        this.a = ilvChart;
        this.c = ilvFlow;
        this.b = new IlvUnit.Dimension(dimension.getWidthAs(IlvUnit.POINTS), dimension.getHeightAs(IlvUnit.POINTS), IlvUnit.POINTS);
    }

    public IlvChartFlowObject(IlvChart ilvChart, IlvFlow ilvFlow, int n2, int n3, float f2) {
        this.a = ilvChart;
        this.c = ilvFlow;
        if (n2 > 100 || n2 < 0) {
            throw new IllegalArgumentException("percentWidth should be >= 0 and <= 100");
        }
        if (n3 > 100 || n3 < 0) {
            throw new IllegalArgumentException("percentHeight should be >= 0 and <= 100");
        }
        if (n2 == 0 && n3 == 0) {
            throw new IllegalArgumentException("Both percentWidth and percentHeight cannot be 0");
        }
        if ((n2 == 0 || n3 == 0) && f2 == 0.0f) {
            throw new IllegalArgumentException("aspectRatio cannot be null.");
        }
        this.d = n2;
        this.e = n3;
        this.f = f2;
    }

    public IlvChart getChart() {
        return this.a;
    }

    public IlvFlow getFlow() {
        return this.c;
    }

    public void setPercentWidth(int n2, float f2) {
        if (n2 > 100 || n2 < 0) {
            throw new IllegalArgumentException("percentWidth should be >= 0 and <= 100");
        }
        if (f2 == 0.0f) {
            throw new IllegalArgumentException("aspectRatio cannot be null.");
        }
        this.d = n2;
        this.f = f2;
        this.b = null;
    }

    public void setPercentHeight(int n2, float f2) {
        if (n2 > 100 || n2 < 0) {
            throw new IllegalArgumentException("percentHeight should be >= 0 and <= 100");
        }
        if (f2 == 0.0f) {
            throw new IllegalArgumentException("aspectRatio cannot be null.");
        }
        this.e = n2;
        this.f = f2;
        this.b = null;
    }

    public void setPercentSize(int n2, int n3) {
        if (n3 > 100 || n3 < 0) {
            throw new IllegalArgumentException("percentHeight should be >= 0 and <= 100");
        }
        if (n2 > 100 || n2 < 0) {
            throw new IllegalArgumentException("percentWidth should be >= 0 and <= 100");
        }
        this.e = n3;
        this.d = n2;
        this.f = 1.0f;
        this.b = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics graphics, float f2, float f3) {
        if (this.a.getWidth() == 0 || this.a.getHeight() == 0) {
            return;
        }
        IlvUnit.Dimension dimension = this.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            double d2 = dimension.getWidth() / (double)this.a.getWidth();
            double d3 = dimension.getHeight() / (double)this.a.getHeight();
            AffineTransform affineTransform = new AffineTransform(d2, 0.0, 0.0, d3, (double)f2, (double)f3);
            AffineTransform affineTransform2 = graphics2D.getTransform();
            graphics2D.transform(affineTransform);
            this.a.print(graphics2D);
            graphics2D.setTransform(affineTransform2);
        }
        finally {
            graphics2D.dispose();
        }
    }

    public IlvUnit.Dimension getSize() {
        return this.b != null ? this.b : this.a();
    }

    private IlvUnit.Dimension a() {
        double d2;
        double d3;
        IlvUnit.Rectangle rectangle = this.c.getDocument().getImageableBounds();
        if (this.d != 0.0 && this.e != 0.0) {
            d3 = this.d * rectangle.getWidthAs(IlvUnit.POINTS) / 100.0;
            d2 = this.e * rectangle.getHeightAs(IlvUnit.POINTS) / 100.0;
        } else if (this.d != 0.0) {
            d3 = this.d * rectangle.getWidthAs(IlvUnit.POINTS) / 100.0;
            d2 = d3 * (double)this.f;
        } else {
            d2 = this.e * rectangle.getHeightAs(IlvUnit.POINTS) / 100.0;
            d3 = d2 * (double)this.f;
        }
        return new IlvUnit.Dimension(d3, d2, IlvUnit.POINTS);
    }
}

