/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.renderer;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartProjector;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvAbstractDataSet;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import ilog.views.chart.renderer.IlvAbstractStackedDataSet;
import ilog.views.chart.renderer.IlvBarChartRenderer;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.renderer.IlvSuperimposedRenderer;
import ilog.views.chart.renderer.IlvVariableWidthRenderer;
import ilog.views.chart.servlet.IlvIMapArea;
import ilog.views.chart.servlet.IlvIMapAttributes;
import ilog.views.chart.servlet.IlvIMapDefinition;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.view3d.IlvChart3DBar;
import ilog.views.chart.view3d.IlvChart3DObject;
import ilog.views.chart.view3d.IlvChart3DScene;
import ilog.views.util.IlvColorUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IlvSingleBarRenderer
extends IlvSingleChartRenderer
implements IlvVariableWidthRenderer {
    private static boolean a = true;
    private static int b;
    private double c;
    private IlvBarChartRenderer d;
    private int e;

    public static int getStrokeThreshold() {
        return b;
    }

    public static void setStrokeThreshold(int n2) {
        b = n2;
    }

    public IlvSingleBarRenderer() {
        this(null);
    }

    public IlvSingleBarRenderer(IlvStyle ilvStyle) {
        this(ilvStyle, 80.0);
    }

    public IlvSingleBarRenderer(IlvStyle ilvStyle, double d2) {
        super(ilvStyle);
        this.setWidthPercent(d2);
    }

    int b() {
        return 1;
    }

    public void setWidthPercent(double d2) {
        if (d2 < 0.0 || d2 > 100.0) {
            throw new IllegalArgumentException("Percentage must be in [0..100]");
        }
        this.c = d2;
        this.triggerChange(4);
    }

    public double getWidthPercent() {
        if (this.d != null && this.d.getMode() == 1 && this.getChart() != null && this.getChart().is3D()) {
            return this.d.getWidthPercent();
        }
        return this.c;
    }

    public double getWidth() {
        return this.getWidthPercent() * this.p() / 100.0;
    }

    double d(int n2) {
        IlvAbstractStackedDataSet ilvAbstractStackedDataSet;
        double d2;
        if (this.e != 0 && this.d != null && this.d.getMode() == 3 && (d2 = (ilvAbstractStackedDataSet = (IlvAbstractStackedDataSet)this.e()).getPreviousYData(n2)) != IlvAbstractDataSet.DEFAULT_UNDEF_VALUE) {
            return Math.max(this.h().getVisibleMin(), d2);
        }
        return Math.max(this.h().getVisibleMin(), this.getCoordinateSystem().getXCrossingValue());
    }

    final void e(int n2) {
        this.e = n2;
    }

    public void setParent(IlvChartRenderer ilvChartRenderer) {
        this.d = ilvChartRenderer instanceof IlvBarChartRenderer ? (IlvBarChartRenderer)ilvChartRenderer : null;
        super.setParent(ilvChartRenderer);
    }

    public boolean has3DSupport() {
        return true;
    }

    public double[] getDepths() {
        if (this.d == null || this.d.getMode() == 1) {
            return super.getDepths();
        }
        double[] dArray = this.d.getDepths();
        if (dArray != null) {
            double d2 = (dArray[0] - dArray[1]) * (double)this.getChart().get3DView().getDepthGap() / 200.0;
            dArray[0] = dArray[0] - d2;
            dArray[1] = dArray[1] + d2;
        }
        return dArray;
    }

    void a(IlvSingleChartRenderer.Points points, boolean bl) {
        double d2 = this.getWidth() / 2.0;
        if (d2 == 0.0) {
            return;
        }
        IlvCoordinateSystem ilvCoordinateSystem = this.getCoordinateSystem();
        Rectangle rectangle = this.getPlotRect();
        IlvChartProjector ilvChartProjector = this.getChart().getLocalProjector2D(rectangle, ilvCoordinateSystem);
        BarItem barItem = new BarItem(2);
        int n2 = points.size();
        Double d3 = points.getDataSet().getUndefValue();
        IlvChart3DScene ilvChart3DScene = this.getChart().get3DView().getScene();
        double[] dArray = this.getDepths();
        Map map = this.k();
        HashMap<Integer, IlvChart3DBar> hashMap = bl ? new HashMap<Integer, IlvChart3DBar>() : null;
        Iterator iterator = null;
        IlvChart3DBar ilvChart3DBar = null;
        IlvDataWindow ilvDataWindow = ilvCoordinateSystem.getVisibleWindow();
        if (bl) {
            iterator = map.values().iterator();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (d3 != null && points.getYData(i2) == d3.doubleValue()) continue;
            int n3 = points.getDataIndex(i2);
            barItem.a(points, i2, d2);
            if (!barItem.a(ilvDataWindow)) continue;
            ilvChartProjector.toDisplay(barItem, rectangle, ilvCoordinateSystem);
            if (bl) {
                ilvChart3DBar = iterator.hasNext() ? ((IlvChart3DBar)iterator.next()).setGeometry(barItem, dArray, n3) : new IlvChart3DBar(ilvChart3DScene, barItem, dArray, this, n3);
                ilvChart3DScene.addObject(ilvChart3DBar);
                hashMap.put(new Integer(n3), ilvChart3DBar);
                continue;
            }
            ilvChart3DBar = (IlvChart3DBar)map.get(new Integer(n3));
            if (ilvChart3DBar != null) {
                ilvChart3DBar.setGeometry(barItem, dArray, n3);
                continue;
            }
            ilvChart3DBar = new IlvChart3DBar(ilvChart3DScene, barItem, dArray, this, n3);
            ilvChart3DScene.addObject(ilvChart3DBar, true);
            map.put(new Integer(n3), ilvChart3DBar);
        }
        if (bl) {
            this.a(hashMap);
            while (iterator.hasNext()) {
                ilvChart3DScene.removeObject(iterator.next());
            }
        }
    }

    public String getZAnnotationText() {
        if (this.d == null || this.d.getMode() == 1) {
            return this.getDefaultLegendText();
        }
        return null;
    }

    void a(IlvSingleChartRenderer.Points points, IlvSingleChartRenderer.ItemAction itemAction) {
        boolean bl;
        double d2 = this.getWidth() / 2.0;
        if (d2 == 0.0) {
            return;
        }
        IlvCoordinateSystem ilvCoordinateSystem = this.getCoordinateSystem();
        Rectangle rectangle = this.getPlotRect();
        IlvChartProjector ilvChartProjector = this.getChart().getLocalProjector2D(rectangle, ilvCoordinateSystem);
        BarItem barItem = new BarItem(7);
        int n2 = points.size();
        IlvStyle ilvStyle = this.getStyle();
        Double d3 = points.getDataSet().getUndefValue();
        double d4 = this.getChart().getProjector().getAxisLength(rectangle, this.i());
        boolean bl2 = bl = 2.0 * d4 * d2 / this.i().getVisibleRange().getLength() > (double)IlvSingleBarRenderer.getStrokeThreshold();
        if (ilvStyle.isFillOn() && !bl) {
            ilvStyle = ilvStyle.setStrokeOn(false);
        }
        if (this.o()) {
            IlvStyle ilvStyle2 = ilvStyle;
            IlvDisplayPoint ilvDisplayPoint = null;
            int[] nArray = points.getIndices();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (d3 != null && points.getYData(i2) == d3.doubleValue()) continue;
                barItem.a(points, i2, d2);
                ilvChartProjector.toDisplay(barItem, rectangle, ilvCoordinateSystem);
                ilvDisplayPoint = new IlvDisplayPoint(this, points.getDataSet(), nArray[i2], 0.0, 0.0);
                IlvDataRenderingHint ilvDataRenderingHint = this.b(ilvDisplayPoint);
                if (ilvDataRenderingHint != null) {
                    ilvStyle2 = ilvDataRenderingHint.getStyle(ilvDisplayPoint, ilvStyle);
                    if (ilvStyle2 == null) {
                        continue;
                    }
                } else {
                    ilvStyle2 = ilvStyle;
                }
                itemAction.processItem(points, i2, barItem, ilvStyle2);
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (d3 != null && points.getYData(i3) == d3.doubleValue()) continue;
                barItem.a(points, i3, d2);
                ilvChartProjector.toDisplay(barItem, rectangle, ilvCoordinateSystem);
                itemAction.processItem(points, i3, barItem, ilvStyle);
            }
        }
    }

    public Point computeDataLabelLocation(IlvDisplayPoint ilvDisplayPoint, Dimension dimension) {
        Object object;
        if (this.getDataLabelLayout() == 2) {
            IlvDoublePoint ilvDoublePoint = new IlvDoublePoint(ilvDisplayPoint.getXCoord(), ilvDisplayPoint.getYCoord());
            double d2 = this.e().getYData(ilvDisplayPoint.getIndex());
            double d3 = d2 >= this.d(ilvDisplayPoint.getIndex()) ? 3.0 : -3.0;
            return this.a(ilvDoublePoint, dimension, d3, true);
        }
        if (this.j() && (object = this.c(ilvDisplayPoint.getIndex())) != null) {
            return ((IlvChart3DObject)object).computeDataLabelLocation(ilvDisplayPoint, dimension);
        }
        object = this.e();
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(object.getXData(ilvDisplayPoint.getIndex()), (this.d(ilvDisplayPoint.getIndex()) + object.getYData(ilvDisplayPoint.getIndex())) / 2.0);
        this.toDisplay(ilvDoublePoints);
        return new Point(IlvGraphicUtil.toInt(ilvDoublePoints.getX(0)), IlvGraphicUtil.toInt(ilvDoublePoints.getY(0)));
    }

    IlvDataWindow a(IlvDataWindow ilvDataWindow) {
        double d2 = this.getWidth() / 2.0;
        if (d2 > 0.0) {
            ilvDataWindow.xRange.expand(d2);
        }
        return ilvDataWindow;
    }

    public IlvDataInterval getXRange(IlvDataInterval ilvDataInterval) {
        IlvDataInterval ilvDataInterval2 = super.getXRange(ilvDataInterval);
        ilvDataInterval2.expand(this.getWidth() / 2.0);
        return ilvDataInterval2;
    }

    IlvStyle a(Paint paint, Paint paint2, Stroke stroke) {
        Color color;
        IlvStyle ilvStyle = super.a(paint, paint2, stroke);
        IlvChartRenderer ilvChartRenderer = this.getParent();
        if (ilvStyle != null && this.isFilled() && ilvChartRenderer instanceof IlvSuperimposedRenderer && ((IlvSuperimposedRenderer)((Object)ilvChartRenderer)).isSuperimposed() && ((IlvSuperimposedRenderer)((Object)ilvChartRenderer)).isAutoTransparency() && (color = ilvStyle.getFillColor()) != null) {
            ilvStyle = ilvStyle.setFillPaint(IlvColorUtil.setAlpha(color, 0.5f));
        }
        return ilvStyle;
    }

    static {
        IlvChartRenderer.register("SingleBar", IlvSingleBarRenderer.class);
        try {
            a = !Boolean.getBoolean("ilog.views.chart.polyBar");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        b = 6;
    }

    class BarItem
    extends IlvSingleChartRenderer.DefaultItem {
        private boolean a;

        public BarItem(int n2) {
            super(IlvSingleBarRenderer.this, n2);
            this.a = IlvSingleBarRenderer.this.getChart().getType() == 1;
        }

        public void draw(Graphics graphics, IlvStyle ilvStyle) {
            if (a && this.a) {
                ilvStyle.renderRect(graphics, this.getX(0), this.getY(0), this.getX(1), this.getY(1));
            } else {
                super.draw(graphics, ilvStyle);
            }
        }

        public boolean contains(IlvStyle ilvStyle, double d2, double d3) {
            if (a && this.a) {
                return this.getBounds(ilvStyle, null).contains(d2, d3);
            }
            return super.contains(ilvStyle, d2, d3);
        }

        void a(IlvSingleChartRenderer.Points points, int n2, double d2) {
            if (this.a && (a || IlvSingleBarRenderer.this.j())) {
                double d3 = points.getXData(n2) + IlvSingleBarRenderer.this.getXShift();
                this.set(0, d3 - d2, IlvSingleBarRenderer.this.d(points.getDataIndex(n2)));
                this.set(1, d3 + d2, points.getYData(n2));
                this.setSize(2);
            } else {
                double[] dArray = this.getXValues();
                double[] dArray2 = this.getYValues();
                double d4 = points.getXData(n2) + IlvSingleBarRenderer.this.getXShift();
                dArray[0] = d4 - d2;
                dArray2[0] = IlvSingleBarRenderer.this.d(points.getDataIndex(n2));
                dArray[1] = dArray[0];
                dArray2[1] = points.getYData(n2);
                if (!this.a) {
                    dArray[2] = d4;
                    dArray2[2] = dArray2[1];
                    dArray[3] = d4 + d2;
                    dArray2[3] = dArray2[1];
                    dArray[4] = dArray[3];
                    dArray2[4] = dArray2[0];
                    dArray[5] = dArray[0];
                    dArray2[5] = dArray2[0];
                    this.setSize(6);
                } else {
                    dArray[2] = d4 + d2;
                    dArray2[2] = dArray2[1];
                    dArray[3] = dArray[2];
                    dArray2[3] = dArray2[0];
                    dArray[4] = dArray[0];
                    dArray2[4] = dArray2[0];
                    this.setSize(5);
                }
            }
        }

        boolean a(IlvDataWindow ilvDataWindow) {
            if (this.getX(0) < ilvDataWindow.getXMin()) {
                if (this.getX(1) < ilvDataWindow.getXMin()) {
                    return false;
                }
                this.setX(0, ilvDataWindow.getXMin());
            } else if (this.getX(0) > ilvDataWindow.getXMax()) {
                if (this.getX(1) > ilvDataWindow.getXMax()) {
                    return false;
                }
                this.setX(0, ilvDataWindow.getXMax());
            }
            if (this.getX(1) < ilvDataWindow.getXMin()) {
                this.setX(1, ilvDataWindow.getXMin());
            } else if (this.getX(1) > ilvDataWindow.getXMax()) {
                this.setX(1, ilvDataWindow.getXMax());
            }
            if (this.getY(0) < ilvDataWindow.getYMin()) {
                if (this.getY(1) < ilvDataWindow.getYMin()) {
                    return false;
                }
                this.setY(0, ilvDataWindow.getYMin());
            } else if (this.getY(0) > ilvDataWindow.getYMax()) {
                if (this.getY(1) > ilvDataWindow.getYMax()) {
                    return false;
                }
                this.setY(0, ilvDataWindow.getYMax());
            }
            if (this.getY(1) < ilvDataWindow.getYMin()) {
                this.setY(1, ilvDataWindow.getYMin());
            } else if (this.getY(1) > ilvDataWindow.getYMax()) {
                this.setY(1, ilvDataWindow.getYMax());
            }
            return true;
        }

        public IlvIMapArea getMapArea(IlvIMapDefinition ilvIMapDefinition, IlvStyle ilvStyle, IlvIMapAttributes ilvIMapAttributes) {
            if (this.a && a) {
                Rectangle rectangle = this.getBounds(ilvStyle, null).getBounds();
                if (ilvIMapDefinition.isChartOrigin()) {
                    IlvChart.Area area = IlvSingleBarRenderer.this.getChart().getChartArea();
                    Rectangle rectangle2 = this.a();
                    if (rectangle2.x != 0 || rectangle2.y != 0) {
                        rectangle.translate(rectangle2.x, rectangle2.y);
                    }
                }
                return new IlvIMapArea(rectangle, ilvIMapAttributes);
            }
            return super.getMapArea(ilvIMapDefinition, ilvStyle, ilvIMapAttributes);
        }
    }
}

