/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.renderer;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartProjector;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvLegendItem;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataPoints;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import ilog.views.chart.renderer.IlvHiLoDataSet;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.renderer.IlvVariableWidthRenderer;
import ilog.views.chart.servlet.IlvIMapArea;
import ilog.views.chart.servlet.IlvIMapAttributes;
import ilog.views.chart.servlet.IlvIMapDefinition;
import java.awt.Graphics;
import java.awt.Rectangle;

public class IlvSingleHiLoRenderer
extends IlvSingleChartRenderer
implements IlvVariableWidthRenderer {
    public static final int STICK = 0;
    public static final int BAR = 1;
    public static final int ARROW = 2;
    public static final int MARKED = 3;
    private static int a = 6;
    private IlvStyle b;
    private double c;
    private int d;

    public static int getStrokeThreshold() {
        return a;
    }

    public static void setStrokeThreshold(int n2) {
        a = n2;
    }

    public IlvSingleHiLoRenderer() {
        this(null, null);
    }

    public IlvSingleHiLoRenderer(IlvStyle ilvStyle, IlvStyle ilvStyle2) {
        this(ilvStyle, ilvStyle2, 1, 80.0);
    }

    public IlvSingleHiLoRenderer(IlvStyle ilvStyle, IlvStyle ilvStyle2, int n2, double d2) {
        super(ilvStyle);
        this.setFallStyle(ilvStyle2);
        this.setType(n2);
        this.setWidthPercent(d2);
    }

    public int getMinDataSetCount() {
        return 2;
    }

    public boolean isFilled() {
        return this.getType() == 1 || this.getType() == 2;
    }

    public IlvStyle getRiseStyle() {
        return this.getStyle();
    }

    public void setRiseStyle(IlvStyle ilvStyle) {
        this.setStyle(ilvStyle);
    }

    public IlvStyle getFallStyle() {
        return this.b;
    }

    public void setFallStyle(IlvStyle ilvStyle) {
        this.b = ilvStyle;
        this.triggerChange(4);
    }

    public void setStyles(IlvStyle[] ilvStyleArray) {
        if (ilvStyleArray.length >= 2) {
            this.setRiseStyle(ilvStyleArray[0]);
            this.setFallStyle(ilvStyleArray[1]);
        } else {
            this.setRiseStyle(ilvStyleArray[0]);
            this.setFallStyle(ilvStyleArray[0]);
        }
    }

    public IlvStyle[] getStyles() {
        if (this.getRiseStyle() == null && this.getFallStyle() == null) {
            return new IlvStyle[0];
        }
        if (this.getFallStyle() == null) {
            return new IlvStyle[]{this.getRiseStyle(), this.getRiseStyle()};
        }
        if (this.getRiseStyle() == null) {
            return new IlvStyle[]{this.getFallStyle(), this.getFallStyle()};
        }
        return new IlvStyle[]{this.getRiseStyle(), this.getFallStyle()};
    }

    IlvStyle b(IlvDataSet ilvDataSet, int n2) {
        if (ilvDataSet == this.r()) {
            return this.getRiseStyle();
        }
        return this.getFallStyle();
    }

    public void setWidthPercent(double d2) {
        if (d2 < 0.0 || d2 > 100.0) {
            throw new IllegalArgumentException("Percentage must be in [0..100]");
        }
        this.c = d2 / 100.0;
        this.triggerChange(4);
    }

    public double getWidthPercent() {
        return this.c * 100.0;
    }

    public double getWidth() {
        return this.c * this.p();
    }

    public final int getType() {
        return this.d;
    }

    public void setType(int n2) {
        this.d(n2);
        this.d = n2;
        this.triggerChange(4);
    }

    private void d(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + n2);
            }
        }
    }

    void a(IlvDataSet ilvDataSet, IlvDataSet ilvDataSet2) {
        this.getDataSource().setDataSets(new IlvDataSet[]{ilvDataSet, ilvDataSet2});
    }

    IlvDataSet r() {
        return this.getDataSource().getDataSet(0);
    }

    IlvDataSet s() {
        return this.getDataSource().getDataSet(1);
    }

    IlvDataPoints a(Rectangle rectangle) {
        IlvDataPoints ilvDataPoints = super.a(rectangle);
        if (ilvDataPoints == null) {
            return null;
        }
        IlvDataSet ilvDataSet = this.e();
        IlvDataInterval ilvDataInterval = this.h().getVisibleRange();
        if (ilvDataInterval.contains(ilvDataSet.getYRange(null))) {
            return ilvDataPoints;
        }
        int n2 = ilvDataPoints.size();
        if (n2 < 2) {
            return ilvDataPoints;
        }
        int n3 = 0;
        if (ilvDataPoints.getIndex(n3) % 2 == 1) {
            ++n3;
            --n2;
        }
        if (n2 % 2 == 1) {
            --n2;
        }
        if (n2 == 0) {
            return ilvDataPoints;
        }
        int[] nArray = ilvDataPoints.getIndices();
        double[] dArray = ilvDataPoints.getXValues();
        double[] dArray2 = ilvDataPoints.getYValues();
        IlvDataPoints ilvDataPoints2 = new IlvDataPoints(ilvDataSet, n2);
        IlvDataInterval ilvDataInterval2 = new IlvDataInterval();
        while (n3 < n2) {
            double d2 = dArray2[n3 + 1];
            double d3 = dArray2[n3];
            if (d2 > d3) {
                ilvDataInterval2.setMin(d3);
                ilvDataInterval2.setMax(d2);
            } else {
                ilvDataInterval2.setMin(d2);
                ilvDataInterval2.setMax(d3);
            }
            if (ilvDataInterval2.intersects(ilvDataInterval)) {
                ilvDataPoints2.add(dArray[n3], d3, nArray[n3]);
                ilvDataPoints2.add(dArray[n3 + 1], d2, nArray[n3 + 1]);
            }
            n3 += 2;
        }
        ilvDataPoints.dispose();
        return ilvDataPoints2;
    }

    int g() {
        return 1;
    }

    protected void chartConnected(IlvChart ilvChart, IlvChart ilvChart2) {
        super.chartConnected(ilvChart, ilvChart2);
        if (ilvChart2 != null && this.getFallStyle() == null) {
            this.setFallStyle(this.makeDefaultStyle());
        }
    }

    protected void dataSetsRemoved(int n2, int n3, IlvDataSet[] ilvDataSetArray) {
        super.dataSetsRemoved(n2, n3, ilvDataSetArray);
        this.t();
    }

    protected void dataSetsAdded(int n2, int n3, IlvDataSet[] ilvDataSetArray) {
        super.dataSetsAdded(n2, n3, ilvDataSetArray);
        this.t();
    }

    void t() {
        int n2 = this.getDataSource().getDataSetCount();
        if (n2 == 2) {
            IlvHiLoDataSet ilvHiLoDataSet = new IlvHiLoDataSet(this.r(), this.s());
            this.a(this.r(), ilvHiLoDataSet, false);
            this.a(this.s(), ilvHiLoDataSet, true);
        }
    }

    void a(IlvSingleChartRenderer.Points points, IlvSingleChartRenderer.ItemAction itemAction) {
        block18: {
            HiLoItem hiLoItem;
            IlvStyle ilvStyle;
            IlvStyle ilvStyle2;
            IlvStyle ilvStyle3;
            double d2;
            Double d3;
            IlvChartProjector ilvChartProjector;
            Rectangle rectangle;
            IlvCoordinateSystem ilvCoordinateSystem;
            boolean bl;
            IlvDataInterval ilvDataInterval;
            int n2;
            int n3;
            block14: {
                n3 = points.size();
                if (n3 < 2) {
                    return;
                }
                n2 = 0;
                if (points.getDataIndex(n2) % 2 == 1) {
                    ++n2;
                    --n3;
                }
                if (n3 % 2 == 1) {
                    --n3;
                }
                if (n3 == 0) {
                    return;
                }
                ilvDataInterval = this.h().getVisibleRange();
                bl = !ilvDataInterval.contains(points.getDataSet().getYRange(null));
                ilvCoordinateSystem = this.getCoordinateSystem();
                rectangle = this.getPlotRect();
                ilvChartProjector = this.getChart().getLocalProjector2D(rectangle, ilvCoordinateSystem);
                d3 = points.getDataSet().getUndefValue();
                d2 = this.getWidth() / 2.0;
                ilvStyle3 = this.getRiseStyle();
                ilvStyle2 = this.getFallStyle();
                if (this.getType() == 1 || this.getType() == 2) {
                    boolean bl2;
                    double d4 = ilvChartProjector.getAxisLength(rectangle, this.i());
                    boolean bl3 = bl2 = 2.0 * d4 * d2 / this.i().getVisibleRange().getLength() > (double)IlvSingleHiLoRenderer.getStrokeThreshold();
                    if (ilvStyle3.isFillOn() && !bl2) {
                        ilvStyle3 = ilvStyle3.setStrokeOn(false);
                    }
                    if (ilvStyle2.isFillOn() && !bl2) {
                        ilvStyle2 = ilvStyle2.setStrokeOn(false);
                    }
                }
                IlvStyle ilvStyle4 = null;
                ilvStyle = null;
                hiLoItem = new HiLoItem(32);
                if (!this.o()) break block14;
                IlvDisplayPoint ilvDisplayPoint = null;
                int[] nArray = points.getIndices();
                while (n2 < n3) {
                    block15: {
                        double d5;
                        double d6;
                        block17: {
                            block16: {
                                d6 = points.getYData(n2);
                                d5 = points.getYData(n2 + 1);
                                if (d3 != null && (d6 == d3 || d5 == d3)) break block15;
                                if (d6 < d5) {
                                    ilvStyle4 = ilvStyle3;
                                    ilvDisplayPoint = new IlvDisplayPoint(this, points.getDataSet(), nArray[n2], 0.0, 0.0);
                                } else {
                                    ilvStyle4 = ilvStyle2;
                                    ilvDisplayPoint = new IlvDisplayPoint(this, points.getDataSet(), nArray[n2 + 1], 0.0, 0.0);
                                }
                                IlvDataRenderingHint ilvDataRenderingHint = this.b(ilvDisplayPoint);
                                if (ilvDataRenderingHint == null) break block16;
                                ilvStyle = ilvDataRenderingHint.getStyle(ilvDisplayPoint, ilvStyle4);
                                if (ilvStyle != null) break block17;
                                break block15;
                            }
                            ilvStyle = ilvStyle4;
                        }
                        if (bl) {
                            d6 = ilvDataInterval.clamp(d6);
                            d5 = ilvDataInterval.clamp(d5);
                        }
                        hiLoItem.a(points, n2, d6, d5, d2);
                        ilvChartProjector.toDisplay(hiLoItem, rectangle, ilvCoordinateSystem);
                        itemAction.processItem(points, n2, hiLoItem, ilvStyle);
                    }
                    n2 += 2;
                }
                break block18;
            }
            while (n2 < n3) {
                double d7 = points.getYData(n2);
                double d8 = points.getYData(n2 + 1);
                if (d3 == null || d7 != d3 && d8 != d3) {
                    IlvStyle ilvStyle5 = ilvStyle = d7 < d8 ? ilvStyle3 : ilvStyle2;
                    if (bl) {
                        d7 = ilvDataInterval.clamp(d7);
                        d8 = ilvDataInterval.clamp(d8);
                    }
                    hiLoItem.a(points, n2, d7, d8, d2);
                    ilvChartProjector.toDisplay(hiLoItem, rectangle, ilvCoordinateSystem);
                    itemAction.processItem(points, n2, hiLoItem, ilvStyle);
                }
                n2 += 2;
            }
        }
    }

    IlvDataWindow a(IlvDataWindow ilvDataWindow) {
        double d2 = this.getWidth() / 2.0;
        if (d2 > 0.0) {
            ilvDataWindow.xRange.expand(d2);
        }
        return ilvDataWindow;
    }

    public IlvDataInterval getXRange(IlvDataInterval ilvDataInterval) {
        IlvDataInterval ilvDataInterval2 = super.getXRange(ilvDataInterval);
        double d2 = this.getWidth() / 2.0;
        if (d2 > 0.0) {
            ilvDataInterval2.min -= d2;
            ilvDataInterval2.max += d2;
        }
        return ilvDataInterval2;
    }

    public void drawLegendSymbol(IlvLegendItem ilvLegendItem, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = Math.min(n4, n5);
        n2 += (n4 - n6) / 2;
        n3 += (n5 - n6) / 2;
        switch (this.d) {
            case 1: {
                this.getRiseStyle().renderRect(graphics, n2, (int)((double)n3 + 0.2 * (double)n5), n6, (int)((double)n5 * 0.4));
                this.getFallStyle().renderRect(graphics, n2, (int)((double)n3 + (double)n5 * 0.6 - 1.0), n6, (int)((double)n5 * 0.3));
                break;
            }
            case 3: {
                this.getLegendStyle().drawLine(graphics, n2, n3 + 2 * n6 / 3, n2 + n6 / 2, n3 + 2 * n6 / 3);
                this.getLegendStyle().drawLine(graphics, n2 + n6 / 2, n3 + n6 / 3, n2 + n6, n3 + n6 / 3);
                break;
            }
            case 2: {
                int[] nArray = new int[]{n2 + n6 / 4, n2 + n6 / 4, n2, n2 + n6 / 2, n2 + n6, n2 + 3 * n6 / 4, n2 + 3 * n6 / 4, n2 + n6 / 4};
                int[] nArray2 = new int[]{n3 + n6 / 2, n3 + n6 / 3, n3 + n6 / 3, n3, n3 + n6 / 3, n3 + n6 / 3, n3 + n6 / 2, n3 + n6 / 2};
                this.getRiseStyle().renderPoints(graphics, nArray, nArray2, 8);
                nArray = new int[]{n2 + n6 / 4, n2 + n6 / 4, n2, n2 + n6 / 2, n2 + n6, n2 + 3 * n6 / 4, n2 + 3 * n6 / 4, n2 + n6 / 4};
                nArray2 = new int[]{n3 + n6 / 2, n3 + 2 * n6 / 3, n3 + 2 * n6 / 3, n3 + n6, n3 + 2 * n6 / 3, n3 + 2 * n6 / 3, n3 + n6 / 2, n3 + n6 / 2};
                this.getFallStyle().renderPoints(graphics, nArray, nArray2, 8);
                break;
            }
            default: {
                this.getLegendStyle().drawLine(graphics, n2 + n6 / 2, n3, n2 + n6 / 2, n3 + n6);
            }
        }
    }

    class HiLoItem
    extends IlvSingleChartRenderer.DefaultItem {
        boolean a;

        HiLoItem(int n2) {
            super(n2);
            this.a = IlvSingleHiLoRenderer.this.getChart().getType() == 1 && IlvSingleHiLoRenderer.this.getType() == 1;
        }

        public void draw(Graphics graphics, IlvStyle ilvStyle) {
            if (IlvSingleHiLoRenderer.this.getType() == 3) {
                ilvStyle.drawLine(graphics, this.getX(0), this.getY(0), this.getX(1), this.getY(1));
                ilvStyle.drawLine(graphics, this.getX(2), this.getY(2), this.getX(3), this.getY(3));
            } else if (this.a) {
                ilvStyle.renderRect(graphics, this.getX(0), this.getY(0), this.getX(1), this.getY(1));
            } else {
                super.draw(graphics, ilvStyle);
            }
        }

        public boolean contains(IlvStyle ilvStyle, double d2, double d3) {
            if (this.a) {
                return this.getBounds(ilvStyle, null).contains(d2, d3);
            }
            return super.contains(ilvStyle, d2, d3);
        }

        void a(IlvSingleChartRenderer.Points points, int n2, double d2, double d3, double d4) {
            double d5 = IlvSingleHiLoRenderer.this.getXShift();
            if (this.a) {
                double d6 = points.getXData(n2) + IlvSingleHiLoRenderer.this.getXShift();
                this.set(0, points.getXData(n2) + d5 - d4, d2);
                this.set(1, points.getXData(n2 + 1) + d5 + d4, d3);
                this.setSize(2);
            } else {
                double[] dArray = this.getXValues();
                double[] dArray2 = this.getYValues();
                int n3 = 0;
                double d7 = points.getXData(n2);
                double d8 = points.getXData(n2 + 1);
                if (d5 != 0.0) {
                    d7 += d5;
                    d8 += d5;
                }
                if (IlvSingleHiLoRenderer.this.getType() == 1) {
                    dArray[0] = d7 - d4;
                    dArray2[0] = d2;
                    dArray[1] = d8 - d4;
                    dArray2[1] = d3;
                    dArray[2] = d8 + d4;
                    dArray2[2] = dArray2[1];
                    dArray[3] = d7 + d4;
                    dArray2[3] = dArray2[0];
                    dArray[4] = dArray[0];
                    dArray2[4] = dArray2[0];
                    n3 = 5;
                } else if (IlvSingleHiLoRenderer.this.getType() == 0) {
                    dArray[0] = d7;
                    dArray2[0] = d2;
                    dArray[1] = d8;
                    dArray2[1] = d3;
                    n3 = 2;
                } else if (IlvSingleHiLoRenderer.this.getType() == 3) {
                    dArray[0] = d7 - d4;
                    dArray2[0] = d2;
                    dArray[1] = d7;
                    dArray2[1] = d2;
                    dArray[2] = d8;
                    dArray2[2] = d3;
                    dArray[3] = d8 + d4;
                    dArray2[3] = d3;
                    n3 = 4;
                } else if (IlvSingleHiLoRenderer.this.getType() == 2) {
                    double d9 = d3 - d2;
                    dArray[0] = d7 - d4 / 2.0;
                    dArray2[0] = d2;
                    dArray[1] = d8 - d4 / 2.0;
                    dArray2[1] = d2 + d9 * 0.8;
                    dArray[2] = dArray[1] - d4 / 2.0;
                    dArray2[2] = dArray2[1];
                    dArray[3] = dArray[1] + d4 / 2.0;
                    dArray2[3] = d3;
                    dArray[4] = d7 + d4;
                    dArray2[4] = dArray2[2];
                    dArray[5] = d7 + d4 / 2.0;
                    dArray2[5] = dArray2[4];
                    dArray[6] = dArray[5];
                    dArray2[6] = dArray2[0];
                    dArray[7] = dArray[0];
                    dArray2[7] = dArray2[0];
                    n3 = 8;
                }
                this.setSize(n3);
            }
        }

        public IlvIMapArea getMapArea(IlvIMapDefinition ilvIMapDefinition, IlvStyle ilvStyle, IlvIMapAttributes ilvIMapAttributes) {
            if (this.a) {
                Rectangle rectangle = this.getBounds(ilvStyle, null).getBounds();
                if (ilvIMapDefinition.isChartOrigin()) {
                    Rectangle rectangle2 = this.a();
                    if (rectangle2.x != 0 || rectangle2.y != 0) {
                        rectangle.translate(rectangle2.x, rectangle2.y);
                    }
                }
                return new IlvIMapArea(rectangle, ilvIMapAttributes);
            }
            return super.getMapArea(ilvIMapDefinition, ilvStyle, ilvIMapAttributes);
        }
    }
}

