/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.renderer;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartDataPicker;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvLegendItem;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataPoints;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDataSetPoint;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import ilog.views.chart.graphic.IlvMarker;
import ilog.views.chart.renderer.IlvPolylineChartRenderer;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.renderer.IlvSingleScatterRenderer;
import ilog.views.chart.servlet.IlvIMapArea;
import ilog.views.chart.servlet.IlvIMapAttributes;
import ilog.views.chart.servlet.IlvIMapDefinition;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvPointsClipper;
import ilog.views.chart.view3d.IlvChart3DLine;
import ilog.views.chart.view3d.IlvChart3DObject;
import ilog.views.chart.view3d.IlvChart3DScene;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IlvSinglePolylineRenderer
extends IlvSingleChartRenderer {
    static final int a = 3;
    private boolean b;
    private IlvStyle c;
    private IlvSingleScatterRenderer d;
    private Paint e = Color.black;

    public IlvSinglePolylineRenderer() {
    }

    public IlvSinglePolylineRenderer(IlvStyle ilvStyle) {
        super(ilvStyle);
    }

    public void setMarker(IlvMarker ilvMarker) {
        this.r().setMarker(ilvMarker);
        this.triggerChange(4);
    }

    public final IlvMarker getMarker() {
        return this.r().getMarker();
    }

    public void setMarkerSize(int n2) {
        this.r().setMarkerSize(n2);
        if (this.r().getMarker() != null) {
            this.triggerChange(4);
        }
    }

    public final int getMarkerSize() {
        return this.r().getMarkerSize();
    }

    public void setMarkerStyle(IlvStyle ilvStyle) {
        this.c = ilvStyle;
        this.r().setStyle(ilvStyle);
        this.triggerChange(4);
    }

    public IlvStyle getMarkerStyle() {
        return this.c;
    }

    final IlvSingleScatterRenderer r() {
        if (this.d == null) {
            this.d = new MarkerRenderer();
        }
        return this.d;
    }

    IlvStyle a(IlvStyle ilvStyle) {
        IlvStyle ilvStyle2 = this.getMarkerStyle();
        if (ilvStyle2 == null) {
            ilvStyle2 = ilvStyle.isFillOn() ? ilvStyle : new IlvStyle(ilvStyle.getStrokePaint());
        }
        return ilvStyle2;
    }

    Rectangle b(Rectangle rectangle) {
        if (this.getMarker() != null) {
            int n2 = this.getMarkerSize() + 1;
            rectangle.grow(n2, n2);
        }
        return rectangle;
    }

    IlvDataPoints a(Rectangle rectangle) {
        if (this.getChart().getType() == 4) {
            return super.a((Rectangle)null);
        }
        return super.a(rectangle);
    }

    public boolean isFilled() {
        return false;
    }

    int g() {
        return 1;
    }

    void d(IlvSingleChartRenderer.Points points) {
        if (points.size() < 1) {
            return;
        }
        IlvDataSet ilvDataSet = points.getDataSet();
        int n2 = ilvDataSet.getDataCount();
        if (points.getDataIndex(points.size() - 1) == n2 - 1) {
            points.addData(ilvDataSet.getXData(0), ilvDataSet.getYData(0));
        } else if (points.getDataIndex(0) == 0) {
            points.addData(0, ilvDataSet.getXData(n2 - 1), ilvDataSet.getYData(n2 - 1));
        }
    }

    void a(IlvSingleChartRenderer.Points points, IlvSingleChartRenderer.ItemAction itemAction) {
        if (this.getChart().getType() == 4) {
            this.d(points);
        }
        boolean bl = itemAction instanceof IlvSingleChartRenderer.ItemContains;
        this.a(points, this.a(itemAction), 1, bl);
    }

    void a(IlvSingleChartRenderer.Points points, IlvSingleChartRenderer.ItemAction itemAction, int n2, boolean bl) {
        double[] dArray = points.getXData();
        double[] dArray2 = points.getYData();
        int n3 = points.size();
        IlvStyle ilvStyle = this.getStyle();
        Double d2 = points.getDataSet().getUndefValue();
        boolean bl2 = this.o();
        if (bl || bl2 || d2 != null) {
            IlvDataRenderingHint ilvDataRenderingHint;
            PolyItem polyItem = null;
            polyItem = n2 == 1 && this.isFilled() ? this.a(n3, 3) : this.a(n3, n2);
            int[] nArray = points.getIndices();
            IlvDisplayPoint ilvDisplayPoint = null;
            boolean bl3 = false;
            IlvStyle ilvStyle2 = ilvStyle;
            if (bl2 && (ilvDataRenderingHint = this.b(ilvDisplayPoint = new IlvDisplayPoint(this, points.getDataSet(), nArray[0], 0.0, 0.0))) != null) {
                ilvStyle2 = ilvDataRenderingHint.getStyle(ilvDisplayPoint, ilvStyle);
            }
            int n4 = d2 != null && d2 == dArray2[0] ? 1 : 0;
            IlvStyle ilvStyle3 = ilvStyle2;
            for (int i2 = 1; i2 < n3; ++i2) {
                boolean bl4;
                if (bl2) {
                    ilvDisplayPoint = new IlvDisplayPoint(this, points.getDataSet(), nArray[i2], 0.0, 0.0);
                    ilvDataRenderingHint = this.b(ilvDisplayPoint);
                    if (ilvDataRenderingHint != null) {
                        ilvStyle3 = ilvDataRenderingHint.getStyle(ilvDisplayPoint, ilvStyle);
                        bl3 = ilvStyle3 == null || !ilvStyle3.equals(ilvStyle2);
                    } else if (ilvStyle2 != ilvStyle) {
                        ilvStyle3 = ilvStyle;
                        bl3 = true;
                    } else {
                        bl3 = false;
                    }
                }
                boolean bl5 = bl4 = ilvStyle3 == null || d2 != null && d2 == dArray2[i2];
                if (!bl && !bl3 && !bl4) continue;
                polyItem.setSize(bl4 ? i2 - n4 : i2 - n4 + 1);
                polyItem.d = polyItem.size();
                if (polyItem.size() > 1 && ilvStyle2 != null) {
                    System.arraycopy(dArray, n4, polyItem.getXValues(), 0, polyItem.size());
                    System.arraycopy(dArray2, n4, polyItem.getYValues(), 0, polyItem.size());
                    itemAction.processItem(points, n4, polyItem, ilvStyle2);
                }
                if (bl3) {
                    ilvStyle2 = ilvStyle3;
                }
                n4 = bl4 ? i2 + 1 : i2;
            }
            polyItem.setSize(n3 - n4);
            polyItem.d = polyItem.size();
            if (polyItem.size() > 1 && ilvStyle2 != null) {
                System.arraycopy(dArray, n4, polyItem.getXValues(), 0, polyItem.size());
                System.arraycopy(dArray2, n4, polyItem.getYValues(), 0, polyItem.size());
                itemAction.processItem(points, n4, polyItem, ilvStyle2);
            }
            polyItem.dispose();
            if (n2 == 1 && this.isFilled()) {
                this.a(points, itemAction, 2, false);
            }
        } else {
            PolyItem polyItem = this.a(n3, n2);
            polyItem.d = n3;
            polyItem.add(dArray, dArray2, n3);
            itemAction.processItem(points, 0, polyItem, ilvStyle);
            polyItem.dispose();
        }
    }

    IlvSingleChartRenderer.BoundsAction m() {
        return new PolyBoundsAction();
    }

    IlvSingleChartRenderer.MapAction a(IlvIMapDefinition ilvIMapDefinition, List list) {
        return new PolyMapAction(ilvIMapDefinition, list);
    }

    PolyItem a(int n2, int n3) {
        return new PolyItem(n2, n3);
    }

    PolyItemAction a(IlvSingleChartRenderer.ItemAction itemAction) {
        return new PolyItemAction(itemAction);
    }

    public boolean has3DSupport() {
        return true;
    }

    public double[] getDepths() {
        IlvPolylineChartRenderer ilvPolylineChartRenderer = this.s();
        if (ilvPolylineChartRenderer != null && ilvPolylineChartRenderer.getMode() != 1) {
            double[] dArray = ilvPolylineChartRenderer.getDepths();
            if (dArray != null) {
                double d2 = (dArray[0] - dArray[1]) * (double)this.getChart().get3DView().getDepthGap() / 200.0;
                dArray[0] = dArray[0] - d2;
                dArray[1] = dArray[1] + d2;
            }
            return dArray;
        }
        return super.getDepths();
    }

    public String getZAnnotationText() {
        IlvPolylineChartRenderer ilvPolylineChartRenderer = this.s();
        if (ilvPolylineChartRenderer == null || ilvPolylineChartRenderer.getMode() == 1) {
            return this.getDefaultLegendText();
        }
        return null;
    }

    IlvPolylineChartRenderer s() {
        return this.getParent() instanceof IlvPolylineChartRenderer ? (IlvPolylineChartRenderer)this.getParent() : null;
    }

    void a(IlvSingleChartRenderer.Points points, boolean bl) {
        int n2 = points.size() - 1;
        IlvChart3DScene ilvChart3DScene = this.getChart().get3DView().getScene();
        double[] dArray = this.getDepths();
        double[] dArray2 = points.getXData();
        double[] dArray3 = points.getYData();
        int[] nArray = points.getIndices();
        IlvDataSet ilvDataSet = points.getDataSet();
        Double d2 = ilvDataSet.getUndefValue();
        Map map = this.k();
        HashMap<Integer, IlvChart3DLine> hashMap = bl ? new HashMap<Integer, IlvChart3DLine>() : null;
        Iterator iterator = bl ? map.values().iterator() : null;
        IlvChart3DLine ilvChart3DLine = null;
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(2);
        IlvDataWindow ilvDataWindow = this.getCoordinateSystem().getVisibleWindow();
        ilvDoublePoints.setSize(2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            if (d2 != null && (dArray3[i2] == d2 || dArray3[i2 + 1] == d2)) continue;
            ilvDoublePoints.set(0, dArray2[i2], dArray3[i2]);
            ilvDoublePoints.set(1, dArray2[i2 + 1], dArray3[i2 + 1]);
            if (!IlvPointsClipper.clipLine(ilvDoublePoints, ilvDataWindow)) continue;
            this.a(ilvDoublePoints);
            if (bl) {
                if (iterator.hasNext()) {
                    ilvChart3DLine = (IlvChart3DLine)iterator.next();
                    ilvChart3DLine.setGeometry(ilvDoublePoints, dArray, n3);
                } else {
                    ilvChart3DLine = new IlvChart3DLine(ilvChart3DScene, ilvDoublePoints, dArray, this, n3);
                }
                ilvChart3DScene.addObject(ilvChart3DLine);
                hashMap.put(new Integer(n3), ilvChart3DLine);
                continue;
            }
            ilvChart3DLine = (IlvChart3DLine)map.get(new Integer(n3));
            if (ilvChart3DLine != null) {
                ilvChart3DLine.setGeometry(ilvDoublePoints, dArray, n3);
                continue;
            }
            ilvChart3DLine = new IlvChart3DLine(ilvChart3DScene, ilvDoublePoints, dArray, this, n3);
            ilvChart3DScene.addObject(ilvChart3DLine, true);
            map.put(new Integer(n3), ilvChart3DLine);
        }
        if (bl) {
            this.a(hashMap);
            while (iterator.hasNext()) {
                ilvChart3DScene.removeObject(iterator.next());
            }
        }
    }

    public void set3DOutlinePaint(Paint paint) {
        this.e = paint;
    }

    public Paint get3DOutlinePaint() {
        return this.e;
    }

    public Point computeDataLabelLocation(IlvDisplayPoint ilvDisplayPoint, Dimension dimension) {
        IlvChart3DObject ilvChart3DObject;
        if (this.getDataLabelLayout() == 2) {
            double d2 = this.getMarker() != null && !this.j() ? (double)(3 + this.getMarkerSize()) : 3.0;
            int n2 = ilvDisplayPoint.getIndex();
            IlvDataSet ilvDataSet = this.e();
            if (n2 > 0 && n2 < ilvDataSet.getDataCount() - 1 && ilvDataSet.getYData(n2) < ilvDataSet.getYData(n2 + 1)) {
                d2 = -d2;
            }
            IlvDoublePoint ilvDoublePoint = new IlvDoublePoint(ilvDisplayPoint.getXCoord(), ilvDisplayPoint.getYCoord());
            return this.a(ilvDoublePoint, dimension, d2, true);
        }
        if (this.j() && (ilvChart3DObject = this.c(ilvDisplayPoint.getIndex())) != null) {
            return ilvChart3DObject.computeDataLabelLocation(ilvDisplayPoint, dimension);
        }
        return super.computeDataLabelLocation(ilvDisplayPoint, dimension);
    }

    public void drawLegendSymbol(IlvLegendItem ilvLegendItem, Graphics graphics, int n2, int n3, int n4, int n5) {
        this.getLegendStyle().drawLine(graphics, n2, n3 + n5 / 2, n2 + n4, n3 + n5 / 2);
        this.a(graphics, n2, n3, n4, n5);
    }

    final void a(Graphics graphics, int n2, int n3, int n4, int n5) {
        if (this.getMarker() != null) {
            this.getMarker().draw(graphics, n2 + n4 / 2, n3 + n5 / 2, Math.min(this.getMarkerSize(), Math.min(n4 / 2, n5 / 2)), this.a(this.getLegendStyle()));
        }
    }

    void b(Graphics graphics, IlvSingleChartRenderer.Points points) {
        super.b(graphics, points);
        if (this.getMarker() != null || this.o()) {
            Rectangle rectangle = graphics.getClipBounds();
            rectangle.grow(this.getMarkerSize(), this.getMarkerSize());
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.d.b(graphics, points);
        }
    }

    IlvDisplayPoint a(IlvChartDataPicker ilvChartDataPicker, IlvSingleChartRenderer.Points points) {
        IlvDisplayPoint ilvDisplayPoint = null;
        if (this.getMarker() != null) {
            ilvDisplayPoint = this.d.a(ilvChartDataPicker, points);
        }
        ilvDisplayPoint = ilvDisplayPoint == null ? super.a(ilvChartDataPicker, points) : new IlvDisplayPoint(this, ilvDisplayPoint.getDataSet(), ilvDisplayPoint.getIndex(), ilvDisplayPoint.getXCoord(), ilvDisplayPoint.getYCoord());
        return ilvDisplayPoint;
    }

    static {
        IlvChartRenderer.register("SinglePolyline", IlvSinglePolylineRenderer.class);
    }

    class MarkerRenderer
    extends IlvSingleScatterRenderer {
        MarkerRenderer() {
            this.setMarker(null);
        }

        public IlvChartRenderer getParent() {
            return IlvSinglePolylineRenderer.this;
        }

        protected IlvStyle makeDefaultStyle() {
            IlvStyle ilvStyle = IlvSinglePolylineRenderer.this.getStyle();
            if (ilvStyle != null) {
                return ilvStyle.isFillOn() ? ilvStyle : new IlvStyle(ilvStyle.getStrokePaint());
            }
            return super.makeDefaultStyle();
        }

        public IlvStyle getStyle() {
            IlvStyle ilvStyle = super.getStyle();
            return ilvStyle == null ? this.makeDefaultStyle() : ilvStyle;
        }

        IlvSingleScatterRenderer.ScatterItem r() {
            return new IlvSingleScatterRenderer.ScatterItem(){
                IlvDataSet a;
                IlvDataInterval b;
                {
                    this.a = IlvSinglePolylineRenderer.this.e();
                    this.b = IlvSinglePolylineRenderer.this.getChart().getXAxis().getVisibleRange();
                }

                public void draw(Graphics graphics, IlvStyle ilvStyle) {
                    if (!this.b.isInside(this.a.getXData(this.dataIdx))) {
                        return;
                    }
                    super.draw(graphics, ilvStyle);
                }
            };
        }

        boolean o() {
            return IlvSinglePolylineRenderer.this.o();
        }

        IlvDataRenderingHint b(IlvDataSetPoint ilvDataSetPoint) {
            return IlvSinglePolylineRenderer.this.b(ilvDataSetPoint);
        }

        IlvDataSet e() {
            return IlvSinglePolylineRenderer.this.e();
        }
    }

    class PolyItem
    extends IlvSingleChartRenderer.DefaultItem {
        static final int a = 1;
        static final int b = 2;
        static final int c = 3;
        int d;
        int e;

        public PolyItem(int n2, int n3) {
            super(n2);
            this.e = n3;
        }

        public void draw(Graphics graphics, IlvStyle ilvStyle) {
            if (ilvStyle.isStrokeOn()) {
                ilvStyle.drawPolyline(graphics, this.getXValues(), this.getYValues(), this.size());
            }
        }

        public boolean contains(IlvStyle ilvStyle, double d2, double d3) {
            if (this.e == 1) {
                return super.contains(ilvStyle, d2, d3);
            }
            if (this.e == 2) {
                return ilvStyle.polylineContains(this.getXValues(), this.getYValues(), this.size(), d2, d3);
            }
            if (this.e == 3) {
                return ilvStyle.polygonContains(this.getXValues(), this.getYValues(), this.size(), d2, d3);
            }
            return false;
        }
    }

    class PolyMapAction
    extends IlvSingleChartRenderer.MapAction {
        PolyMapAction(IlvIMapDefinition ilvIMapDefinition, List list) {
            super(ilvIMapDefinition, list);
        }

        public void processItem(IlvSingleChartRenderer.Points points, int n2, IlvSingleChartRenderer.Item item, IlvStyle ilvStyle) {
            int n3;
            int n4;
            Cloneable cloneable;
            PolyItem polyItem = (PolyItem)item;
            int n5 = n2 + polyItem.d;
            int n6 = IlvSinglePolylineRenderer.this.getMarker() != null ? this.b.getCircleRadius() + IlvSinglePolylineRenderer.this.getMarkerSize() : this.b.getCircleRadius();
            IlvChart.Area area = IlvSinglePolylineRenderer.this.getChart().getChartArea();
            if (IlvSinglePolylineRenderer.this.getChart().isPaintingImage() && IlvSinglePolylineRenderer.this.getChart().getPaintContext().getBounds() != null) {
                cloneable = (Rectangle)IlvSinglePolylineRenderer.this.getChart().getPaintContext().getBounds().get(area);
                n4 = cloneable.x;
                n3 = cloneable.y;
            } else {
                n4 = area.getX();
                n3 = area.getY();
            }
            if (IlvSinglePolylineRenderer.this.isFilled() && this.b.getType() == 1) {
                cloneable = points.a(n2);
                IlvIMapAttributes ilvIMapAttributes = this.b.getAttributes((IlvDataSetPoint)cloneable);
                if (ilvIMapAttributes == null) {
                    return;
                }
                Polygon polygon = IlvGraphicUtil.createPolygon(polyItem.getXValues(), polyItem.getYValues(), polyItem.size());
                if (this.b.isChartOrigin() && (n4 != 0 || n3 != 0)) {
                    polygon.translate(n4, n3);
                }
                this.c.add(new IlvIMapArea(polygon, ilvIMapAttributes));
            } else {
                for (int i2 = n2; i2 < n5; ++i2) {
                    IlvDataSetPoint ilvDataSetPoint;
                    IlvIMapAttributes ilvIMapAttributes;
                    if (points.getDataIndex(i2) == -1 || (ilvIMapAttributes = this.b.getAttributes(ilvDataSetPoint = points.a(i2))) == null) continue;
                    int n7 = IlvGraphicUtil.toInt(points.getXCoord(i2));
                    int n8 = IlvGraphicUtil.toInt(points.getYCoord(i2));
                    if (this.b.isChartOrigin()) {
                        n7 += n4;
                        n8 += n3;
                    }
                    this.c.add(new IlvIMapArea(n7, n8, n6, ilvIMapAttributes));
                }
            }
        }
    }

    class PolyBoundsAction
    extends IlvSingleChartRenderer.DefaultBoundsAction {
        PolyBoundsAction() {
        }

        public Rectangle2D getBounds() {
            Rectangle2D rectangle2D = super.getBounds();
            if (IlvSinglePolylineRenderer.this.getMarker() != null) {
                IlvGraphicUtil.grow(rectangle2D, IlvSinglePolylineRenderer.this.getMarkerSize() + 1, IlvSinglePolylineRenderer.this.getMarkerSize() + 1);
                IlvSinglePolylineRenderer.this.d.getStyle().expand(rectangle2D);
            }
            return rectangle2D;
        }
    }

    class PolyItemAction
    implements IlvSingleChartRenderer.ItemAction {
        IlvSingleChartRenderer.ItemAction a;

        public void startProcessItems() {
            this.a.startProcessItems();
        }

        public void endProcessItems() {
            this.a.endProcessItems();
        }

        PolyItemAction(IlvSingleChartRenderer.ItemAction itemAction) {
            this.a = itemAction;
        }

        void a(PolyItem polyItem) {
            IlvPointsClipper.clipX(polyItem, IlvSinglePolylineRenderer.this.i().getVisibleMin(), IlvSinglePolylineRenderer.this.i().getVisibleMax());
        }

        public void processItem(IlvSingleChartRenderer.Points points, int n2, IlvSingleChartRenderer.Item item, IlvStyle ilvStyle) {
            PolyItem polyItem = (PolyItem)item;
            if (polyItem.size() == 0) {
                return;
            }
            this.processPolyItem(points, n2, polyItem);
            this.a(polyItem);
            IlvSinglePolylineRenderer.this.toDisplay(polyItem);
            this.a.processItem(points, n2, item, ilvStyle);
        }

        protected void processPolyItem(IlvSingleChartRenderer.Points points, int n2, PolyItem polyItem) {
        }
    }
}

