/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.renderer;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvLegendItem;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import ilog.views.chart.graphic.IlvMarker;
import ilog.views.chart.graphic.IlvMarkerFactory;
import ilog.views.chart.graphic.IlvMarkerHint;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.servlet.IlvIMapArea;
import ilog.views.chart.servlet.IlvIMapAttributes;
import ilog.views.chart.servlet.IlvIMapDefinition;
import ilog.views.chart.util.IlvGraphicUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class IlvSingleScatterRenderer
extends IlvSingleChartRenderer {
    static final int a = 3;
    static final IlvMarker b;
    private IlvMarker c;
    private int d;

    public IlvSingleScatterRenderer() {
        this(b, 3, null);
    }

    public IlvSingleScatterRenderer(IlvStyle ilvStyle) {
        this(b, 3, ilvStyle);
    }

    public IlvSingleScatterRenderer(IlvMarker ilvMarker, int n2, IlvStyle ilvStyle) {
        super(ilvStyle);
        this.c = ilvMarker;
        this.d = n2;
    }

    int b() {
        return 1;
    }

    public final IlvMarker getMarker() {
        return this.c;
    }

    public void setMarker(IlvMarker ilvMarker) {
        this.c = ilvMarker;
        this.triggerChange(4);
    }

    public final int getMarkerSize() {
        return this.getSize();
    }

    public void setMarkerSize(int n2) {
        this.setSize(n2);
    }

    public final int getSize() {
        return this.d;
    }

    public void setSize(int n2) {
        this.d = n2;
        this.triggerChange(4);
    }

    public Rectangle getClipRect() {
        Rectangle rectangle = super.getClipRect();
        if (!this.isClipped()) {
            rectangle.grow(this.d, this.d);
        }
        return rectangle;
    }

    public Insets getPreferredMargins() {
        Insets insets = super.getPreferredMargins();
        if (!this.isClipped()) {
            if (insets.left < this.d) {
                insets.left = this.d;
            }
            if (insets.right < this.d) {
                insets.right = this.d;
            }
            if (insets.top < this.d) {
                insets.top = this.d;
            }
            if (insets.bottom < this.d) {
                insets.bottom = this.d;
            }
        }
        return insets;
    }

    protected boolean isClipped() {
        return false;
    }

    boolean c() {
        return false;
    }

    public Point computeDataLabelLocation(IlvDisplayPoint ilvDisplayPoint, Dimension dimension) {
        if (this.getDataLabelLayout() == 2) {
            double d2 = 3 + this.getSize();
            IlvDoublePoint ilvDoublePoint = new IlvDoublePoint(ilvDisplayPoint.getXCoord(), ilvDisplayPoint.getYCoord());
            return this.a(ilvDoublePoint, dimension, d2, true);
        }
        return super.computeDataLabelLocation(ilvDisplayPoint, dimension);
    }

    void a(IlvSingleChartRenderer.Points points, IlvSingleChartRenderer.ItemAction itemAction) {
        ScatterItem scatterItem = this.r();
        double[] dArray = points.getXCoords();
        double[] dArray2 = points.getYCoords();
        int[] nArray = points.getIndices();
        int n2 = points.size();
        IlvStyle ilvStyle = this.getStyle();
        Double d2 = points.getDataSet().getUndefValue();
        if (this.o()) {
            IlvStyle ilvStyle2 = ilvStyle;
            IlvDisplayPoint ilvDisplayPoint = null;
            IlvMarker ilvMarker = this.getMarker();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (d2 != null && points.getYData(i2) == d2.doubleValue()) continue;
                ilvDisplayPoint = new IlvDisplayPoint(this, points.getDataSet(), nArray[i2], 0.0, 0.0);
                IlvDataRenderingHint ilvDataRenderingHint = this.b(ilvDisplayPoint);
                if (ilvDataRenderingHint != null) {
                    ilvStyle2 = ilvDataRenderingHint.getStyle(ilvDisplayPoint, ilvStyle);
                    if (ilvStyle2 == null) continue;
                    if (ilvDataRenderingHint instanceof IlvMarkerHint) {
                        scatterItem.marker = ((IlvMarkerHint)((Object)ilvDataRenderingHint)).getMarker(ilvDisplayPoint, ilvMarker);
                        if (scatterItem.marker == null) {
                            continue;
                        }
                    } else {
                        scatterItem.marker = ilvMarker;
                    }
                } else {
                    ilvStyle2 = ilvStyle;
                    scatterItem.marker = ilvMarker;
                }
                scatterItem.setLocation(dArray[i2], dArray2[i2]);
                scatterItem.setDataIdx(nArray[i2]);
                itemAction.processItem(points, i2, scatterItem, ilvStyle2);
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (d2 != null && points.getYData(i3) == d2.doubleValue()) continue;
                scatterItem.setLocation(dArray[i3], dArray2[i3]);
                scatterItem.setDataIdx(nArray[i3]);
                itemAction.processItem(points, i3, scatterItem, ilvStyle);
            }
        }
    }

    ScatterItem r() {
        return new ScatterItem();
    }

    int d(int n2) {
        return this.getSize();
    }

    Rectangle b(Rectangle rectangle) {
        int n2 = this.getSize() + 1;
        rectangle.grow(n2, n2);
        return rectangle;
    }

    public void drawLegendSymbol(IlvLegendItem ilvLegendItem, Graphics graphics, int n2, int n3, int n4, int n5) {
        this.c.draw(graphics, n2 + n4 / 2, n3 + n5 / 2, Math.min(this.d, Math.min(n4, n5) / 2), this.getLegendStyle());
    }

    static {
        IlvChartRenderer.register("SingleScatter", IlvSingleScatterRenderer.class);
        b = IlvMarkerFactory.getSquareMarker();
    }

    class ScatterItem
    implements IlvSingleChartRenderer.Item {
        protected double x;
        protected double y;
        protected int dataIdx;
        protected IlvMarker marker;

        ScatterItem() {
            this.marker = IlvSingleScatterRenderer.this.getMarker();
        }

        public void draw(Graphics graphics, IlvStyle ilvStyle) {
            if (this.marker != null) {
                this.marker.draw(graphics, IlvGraphicUtil.toInt(this.x), IlvGraphicUtil.toInt(this.y), this.a(), ilvStyle);
            }
        }

        public Rectangle2D getBounds(IlvStyle ilvStyle, Rectangle2D rectangle2D) {
            int n2 = this.a();
            if (rectangle2D == null) {
                rectangle2D = this.marker == null ? new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0) : new Rectangle2D.Double(this.x - (double)n2, this.y - (double)n2, 2 * n2 + 1, 2 * n2 + 1);
            } else if (this.marker == null) {
                rectangle2D.setRect(0.0, 0.0, 0.0, 0.0);
            } else {
                rectangle2D.setRect(this.x - (double)n2, this.y - (double)n2, 2 * n2 + 1, 2 * n2 + 1);
            }
            ilvStyle.expand(rectangle2D);
            return rectangle2D;
        }

        public final void setLocation(double d2, double d3) {
            this.x = d2;
            this.y = d3;
        }

        public final void setDataIdx(int n2) {
            this.dataIdx = n2;
        }

        public boolean contains(IlvStyle ilvStyle, double d2, double d3) {
            return this.marker == null ? false : this.getBounds(ilvStyle, null).contains(d2, d3);
        }

        public IlvIMapArea getMapArea(IlvIMapDefinition ilvIMapDefinition, IlvStyle ilvStyle, IlvIMapAttributes ilvIMapAttributes) {
            if (this.marker == null) {
                return null;
            }
            int n2 = IlvGraphicUtil.toInt(this.x);
            int n3 = IlvGraphicUtil.toInt(this.y);
            if (ilvIMapDefinition.isChartOrigin()) {
                int n4;
                int n5;
                IlvChart.Area area = IlvSingleScatterRenderer.this.getChart().getChartArea();
                if (IlvSingleScatterRenderer.this.getChart().isPaintingImage() && IlvSingleScatterRenderer.this.getChart().getPaintContext().getBounds() != null) {
                    Rectangle rectangle = (Rectangle)IlvSingleScatterRenderer.this.getChart().getPaintContext().getBounds().get(area);
                    n5 = rectangle.x;
                    n4 = rectangle.y;
                } else {
                    n5 = area.getX();
                    n4 = area.getY();
                }
                n2 += n5;
                n3 += n4;
            }
            return new IlvIMapArea(n2, n3, Math.max(this.a(), ilvIMapDefinition.getCircleRadius()), ilvIMapAttributes);
        }

        private final int a() {
            return IlvSingleScatterRenderer.this.d(this.dataIdx);
        }
    }
}

