/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.renderer;

import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.data.IlvAbstractDataSet;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDataSetPoint;
import ilog.views.chart.renderer.IlvAbstractStackedDataSet;
import ilog.views.chart.util.IlvDoubleArray;

class IlvStacked100DataSet
extends IlvAbstractStackedDataSet {
    private int a;

    public IlvStacked100DataSet(int n2, IlvDataSet[] ilvDataSetArray, IlvStacked100DataSet ilvStacked100DataSet) {
        super(ilvStacked100DataSet);
        this.a = n2;
        this.setDataSets(ilvDataSetArray);
    }

    protected IlvDataSet getRefDataSet() {
        return this.getDataSet(this.a);
    }

    public void setData(int n2, double d2, double d3) {
        if (d3 >= 100.0) {
            int n3 = this.getDataSetCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (i2 == this.a) continue;
                this.getDataSet(i2).setData(n2, d2, 0.0);
            }
        } else {
            if (d3 < 0.0) {
                d3 = 0.0;
            }
            super.setData(n2, d2, d3);
        }
    }

    public void unmap(IlvDataSetPoint ilvDataSetPoint, IlvDoublePoint ilvDoublePoint) {
        this.unmap(ilvDataSetPoint);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = ilvDoublePoint.y;
        int n2 = this.getDataSetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 < this.a) {
                d2 += this.getDataSet(i2).getYData(ilvDataSetPoint.index);
                continue;
            }
            if (i2 <= this.a) continue;
            d3 += this.getDataSet(i2).getYData(ilvDataSetPoint.index);
        }
        ilvDoublePoint.y = Math.max(0.0, (d4 * (d2 + d3) - 100.0 * d2) / (100.0 - d4));
    }

    protected IlvDoubleArray computeStackedData(IlvDoubleArray ilvDoubleArray, int n2, int n3) {
        int n4 = this.getDataSetCount();
        int n5 = ilvDoubleArray.size();
        if (this.a == n4 - 1) {
            IlvDataSet ilvDataSet = this.getRefDataSet();
            Double d2 = ilvDataSet.getUndefValue();
            for (int i2 = n2; i2 <= n3; ++i2) {
                double d3 = d2 != null && ilvDataSet.getYData(i2) == d2.doubleValue() ? IlvAbstractDataSet.DEFAULT_UNDEF_VALUE : 100.0;
                if (i2 >= n5) {
                    ilvDoubleArray.add(d3);
                    continue;
                }
                ilvDoubleArray.set(i2, d3);
            }
            return ilvDoubleArray;
        }
        Double[] doubleArray = new Double[n4];
        for (int i3 = 0; i3 < n4; ++i3) {
            doubleArray[i3] = this.getDataSet(i3).getUndefValue();
        }
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = IlvAbstractDataSet.DEFAULT_UNDEF_VALUE;
        for (int i4 = n2; i4 <= n3; ++i4) {
            d5 = 0.0;
            d4 = 0.0;
            for (int i5 = 0; i5 < n4; ++i5) {
                double d7 = this.getDataSet(i5).getYData(i4);
                if (doubleArray[i5] != null && d7 == doubleArray[i5]) {
                    if (i5 != n4 - 1) continue;
                    d4 = d6;
                    break;
                }
                d4 += d7;
                if (i5 > this.a) continue;
                d5 += d7;
            }
            d5 = d4 == d6 ? d6 : (d4 == 0.0 ? 0.0 : (d5 *= 100.0 / d4));
            if (i4 >= n5) {
                ilvDoubleArray.add(d5);
                continue;
            }
            ilvDoubleArray.set(i4, d5);
        }
        return ilvDoubleArray;
    }

    protected void computeLimits(IlvDataInterval ilvDataInterval, IlvDataInterval ilvDataInterval2) {
        this.getDataSet(this.a).getXRange(ilvDataInterval);
        ilvDataInterval2.set(0.0, 100.0);
    }
}

