/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.servlet;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvLegend;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.event.AxisChangeEvent;
import ilog.views.chart.event.AxisListener;
import ilog.views.chart.event.AxisRangeEvent;
import ilog.views.chart.servlet.IlvChartServerAction;
import ilog.views.chart.servlet.IlvChartServerActionEvent;
import ilog.views.chart.servlet.IlvIMapDefinition;
import ilog.views.chart.servlet.IlvImageEncoder;
import ilog.views.chart.servlet.IlvImageMapBuilder;
import ilog.views.chart.servlet.IlvJPEGEncoder;
import ilog.views.chart.servlet.IlvPNGEncoder;
import ilog.views.chart.servlet.IlvParameterException;
import ilog.views.chart.servlet.IlvServletParameters;
import ilog.views.chart.servlet.IlvServletRequestParameters;
import ilog.views.chart.servlet.IlvServletRunnable;
import ilog.views.chart.servlet.IlvServletUtil;
import ilog.views.util.event.IlvEventListenerCollection;
import ilog.views.util.event.IlvEventListenerList;
import ilog.views.util.swing.IlvJHiddenPrintWindowFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.JComponent;

public abstract class IlvChartServletSupport {
    public static final String REQUEST_PARAM = "request";
    public static final String IMAGE_REQUEST = "image";
    public static final String IMAGEMAP_REQUEST = "imagemap";
    public static final String VERBOSE_PARAM = "verbose";
    public static final String IMAGE_FORMAT_PARAM = "format";
    public static final String JPEG_IMAGE_FORMAT = "JPEG";
    public static final String PNG_IMAGE_FORMAT = "PNG";
    public static final String X_MIN_PARAM = "xMin";
    public static final String X_MAX_PARAM = "xMax";
    public static final String Y_MIN_PARAM = "yMin";
    public static final String Y_MAX_PARAM = "yMax";
    public static final String BG_COLOR_PARAM = "bgcolor";
    public static final String ACTION_PARAM = "action";
    public static final String COMPONENT_PARAM = "comp";
    public static final String CHART_COMPONENT = "chart";
    public static final String AREA_COMPONENT = "area";
    public static final String LEGEND_COMPONENT = "legend";
    public static final String OVERVIEW_COMPONENT = "overview";
    public static final String IMAGEMAP_NAME = "mapname";
    public static final String[] VALID_COMPONENTS = new String[]{"chart", "area", "legend", "overview"};
    public static final String CAPABILITIES_REQUEST = "capabilities";
    public static final String CAP_FORMAT_PARAM = "format";
    public static final String HTML_CAP_FORMAT = "html";
    public static final String OCTET_CAP_FORMAT = "octet-stream";
    public static final String[] VALID_CAP_FORMATS = new String[]{"html", "octet-stream"};
    private static String a = "__Ilv_Overview_Listener_set";
    private static Object b = new Object();
    private Hashtable c;
    private IlvServletParameters d;
    private HashMap e = new HashMap();
    private HttpServlet f;

    public IlvChartServletSupport() {
        this.c = new Hashtable();
        this.a();
    }

    private void a() {
        this.setImageEncoder(JPEG_IMAGE_FORMAT, new IlvJPEGEncoder());
        this.setImageEncoder(PNG_IMAGE_FORMAT, new IlvPNGEncoder());
    }

    public void setServlet(HttpServlet httpServlet) {
        this.f = httpServlet;
    }

    public final HttpServlet getServlet() {
        return this.f;
    }

    public IlvServletParameters getConfigParameters() {
        return this.d;
    }

    public void setConfigParameters(IlvServletParameters ilvServletParameters) {
        this.d = ilvServletParameters;
    }

    public boolean isVerbose(IlvServletRequestParameters ilvServletRequestParameters) {
        try {
            return ilvServletRequestParameters.getBoolean(VERBOSE_PARAM);
        }
        catch (Exception exception) {
            IlvServletParameters ilvServletParameters = this.getConfigParameters();
            if (ilvServletParameters != null) {
                return ilvServletParameters.getBoolean(VERBOSE_PARAM, false);
            }
            return false;
        }
    }

    private final IlvChart a(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
        String string = ilvServletRequestParameters.getString(COMPONENT_PARAM, CHART_COMPONENT);
        if (OVERVIEW_COMPONENT.equals(string)) {
            return this.b(ilvServletRequestParameters);
        }
        return this.getChart(ilvServletRequestParameters);
    }

    protected abstract IlvChart getChart(IlvServletRequestParameters var1) throws ServletException;

    protected IlvChart getOverviewChart(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
        return null;
    }

    private IlvChart b(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
        IlvChart ilvChart = this.getOverviewChart(ilvServletRequestParameters);
        if (ilvChart != null && ilvChart.getClientProperty(a) == null) {
            OverviewUpdater overviewUpdater = new OverviewUpdater(ilvChart, this.getChart(ilvServletRequestParameters));
            ilvChart.putClientProperty(a, b);
        }
        return ilvChart;
    }

    protected void prepareOverviewChart(IlvServletRequestParameters ilvServletRequestParameters, IlvChart ilvChart) {
    }

    protected void prepareChart(IlvServletRequestParameters ilvServletRequestParameters, IlvChart ilvChart) throws ServletException {
    }

    final void a(IlvServletRequestParameters ilvServletRequestParameters, IlvChart ilvChart) throws ServletException {
        this.prepareVisibleWindow(ilvServletRequestParameters, ilvChart);
        this.prepareChart(ilvServletRequestParameters, ilvChart);
    }

    protected IlvDataWindow getRequestedVisibleWindow(IlvServletRequestParameters ilvServletRequestParameters, IlvChart ilvChart) throws ServletException {
        IlvDataInterval ilvDataInterval = ilvChart.getXAxis().getVisibleRange();
        IlvDataInterval ilvDataInterval2 = ilvChart.getYAxis(0).getVisibleRange();
        IlvDataWindow ilvDataWindow = new IlvDataWindow(new IlvDataInterval(ilvDataInterval), new IlvDataInterval(ilvDataInterval2));
        IlvDataInterval ilvDataInterval3 = ilvDataWindow.xRange;
        IlvDataInterval ilvDataInterval4 = ilvDataWindow.yRange;
        try {
            ilvDataInterval3.min = ilvServletRequestParameters.getDouble(X_MIN_PARAM);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServletException(numberFormatException.getMessage());
        }
        catch (IlvParameterException ilvParameterException) {
            // empty catch block
        }
        try {
            ilvDataInterval3.max = ilvServletRequestParameters.getDouble(X_MAX_PARAM);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServletException(numberFormatException.getMessage());
        }
        catch (IlvParameterException ilvParameterException) {
            // empty catch block
        }
        try {
            ilvDataInterval4.min = ilvServletRequestParameters.getDouble(Y_MIN_PARAM);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServletException(numberFormatException.getMessage());
        }
        catch (IlvParameterException ilvParameterException) {
            // empty catch block
        }
        try {
            ilvDataInterval4.max = ilvServletRequestParameters.getDouble(Y_MAX_PARAM);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServletException(numberFormatException.getMessage());
        }
        catch (IlvParameterException ilvParameterException) {
            // empty catch block
        }
        return ilvDataWindow;
    }

    protected void prepareVisibleWindow(IlvServletRequestParameters ilvServletRequestParameters, IlvChart ilvChart) throws ServletException {
        try {
            if (LEGEND_COMPONENT.equals(ilvServletRequestParameters.getString(COMPONENT_PARAM))) {
                return;
            }
        }
        catch (IlvParameterException ilvParameterException) {
            // empty catch block
        }
        if (this.isVerbose(ilvServletRequestParameters)) {
            System.out.println("  current visible window= " + ilvChart.getCoordinateSystem(0).getVisibleWindow());
        }
        IlvDataWindow ilvDataWindow = this.getRequestedVisibleWindow(ilvServletRequestParameters, ilvChart);
        if (this.isVerbose(ilvServletRequestParameters)) {
            System.out.println("  requested visible window= " + ilvDataWindow);
        }
        IlvDataInterval ilvDataInterval = ilvChart.getXAxis().getVisibleRange();
        IlvDataInterval ilvDataInterval2 = ilvChart.getYAxis(0).getVisibleRange();
        IlvDataInterval ilvDataInterval3 = ilvDataWindow.xRange;
        IlvDataInterval ilvDataInterval4 = ilvDataWindow.yRange;
        double d2 = ilvDataInterval3.max - ilvDataInterval.max;
        double d3 = ilvDataInterval4.max - ilvDataInterval2.max;
        if (d2 != 0.0 && IlvChartServletSupport.a(d2, ilvDataInterval3.min, ilvDataInterval.min) && d3 != 0.0 && IlvChartServletSupport.a(d3, ilvDataInterval4.min, ilvDataInterval2.min)) {
            ilvChart.scroll(d2, d3, 0);
        } else if (!ilvDataInterval3.equals(ilvDataInterval) || !ilvDataInterval4.equals(ilvDataInterval2)) {
            ilvChart.zoom(new IlvDataWindow(ilvDataInterval3, ilvDataInterval4), 0);
        }
        if (this.isVerbose(ilvServletRequestParameters)) {
            System.out.println("  new visible window= " + ilvChart.getCoordinateSystem(0).getVisibleWindow());
        }
    }

    private static boolean a(double d2, double d3, double d4) {
        return d2 >= d3 - d4 - 1.0E-9 && d2 <= d3 - d4 + 1.0E-9;
    }

    protected IlvImageMapBuilder createImageMapBuilder(IlvServletRequestParameters ilvServletRequestParameters, IlvChart ilvChart) {
        return new IlvImageMapBuilder(ilvChart);
    }

    protected IlvIMapDefinition getIMapDefinition(IlvServletRequestParameters ilvServletRequestParameters, IlvChart ilvChart) {
        return null;
    }

    public boolean handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        IlvServletRequestParameters ilvServletRequestParameters = new IlvServletRequestParameters(httpServletRequest);
        this.executeAction(ilvServletRequestParameters, this.a(ilvServletRequestParameters), 2);
        String string = ilvServletRequestParameters.getString(REQUEST_PARAM, null);
        if (IMAGE_REQUEST.equals(string)) {
            this.d(httpServletResponse, ilvServletRequestParameters);
            return true;
        }
        if (IMAGEMAP_REQUEST.equals(string)) {
            this.a(httpServletResponse, ilvServletRequestParameters);
            return true;
        }
        if (CAPABILITIES_REQUEST.equals(string)) {
            this.e(httpServletResponse, ilvServletRequestParameters);
            return true;
        }
        return false;
    }

    private boolean c(IlvServletRequestParameters ilvServletRequestParameters) {
        if (this.isVerbose(ilvServletRequestParameters)) {
            System.out.println("From image map: " + ilvServletRequestParameters.getBoolean("fromImageMap", false));
        }
        return ilvServletRequestParameters.getBoolean("fromImageMap", false);
    }

    private void a(HttpServletResponse httpServletResponse, IlvServletRequestParameters ilvServletRequestParameters) throws IOException, ServletException {
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        if (IlvChart.getNoEventThreadUpdate()) {
            this.c(httpServletResponse, ilvServletRequestParameters);
        } else {
            this.b(httpServletResponse, ilvServletRequestParameters);
        }
    }

    private void b(HttpServletResponse httpServletResponse, IlvServletRequestParameters ilvServletRequestParameters) throws ServletException, IOException {
        String string;
        if (this.isVerbose(ilvServletRequestParameters)) {
            System.out.println("Starts generating image map");
        }
        String string2 = ilvServletRequestParameters.getString(IMAGEMAP_NAME, IMAGEMAP_REQUEST);
        try {
            int n2 = ilvServletRequestParameters.getInteger("width");
            int n3 = ilvServletRequestParameters.getInteger("height");
            String string3 = ilvServletRequestParameters.getString(IMAGE_REQUEST, null);
            string = ilvServletRequestParameters.getString(COMPONENT_PARAM, VALID_COMPONENTS, CHART_COMPONENT);
        }
        catch (IlvParameterException ilvParameterException) {
            throw new ServletException(ilvParameterException.getMessage());
        }
        final PrintWriter printWriter = new PrintWriter((Writer)httpServletResponse.getWriter(), true);
        final IlvServletRequestParameters ilvServletRequestParameters2 = ilvServletRequestParameters;
        final IlvJComponentIMapWriter ilvJComponentIMapWriter = this.b(string, ilvServletRequestParameters);
        if (ilvJComponentIMapWriter == null) {
            throw new ServletException("Unknown or missing component");
        }
        IlvServletRunnable ilvServletRunnable = new IlvServletRunnable(){

            public void run() throws ServletException, IOException {
                ilvJComponentIMapWriter.validateComponent();
                ilvJComponentIMapWriter.prepareComponent(ilvServletRequestParameters2);
                ilvJComponentIMapWriter.writeIMap(printWriter, ilvServletRequestParameters2);
            }
        };
        IlvServletUtil.invokeAndWait(ilvServletRunnable);
        if (this.isVerbose(ilvServletRequestParameters)) {
            System.out.println("Ends generating ImageMap");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(HttpServletResponse httpServletResponse, IlvServletRequestParameters ilvServletRequestParameters) throws ServletException, IOException {
        String string;
        int n2;
        int n3;
        if (this.isVerbose(ilvServletRequestParameters)) {
            System.out.println("Starts generating MT image map");
        }
        String string2 = ilvServletRequestParameters.getString(IMAGEMAP_NAME, IMAGEMAP_REQUEST);
        try {
            n3 = ilvServletRequestParameters.getInteger("width");
            n2 = ilvServletRequestParameters.getInteger("height");
            String string3 = ilvServletRequestParameters.getString(IMAGE_REQUEST, null);
            string = ilvServletRequestParameters.getString(COMPONENT_PARAM, VALID_COMPONENTS, CHART_COMPONENT);
        }
        catch (IlvParameterException ilvParameterException) {
            throw new ServletException(ilvParameterException.getMessage());
        }
        PrintWriter printWriter = new PrintWriter((Writer)httpServletResponse.getWriter(), true);
        IlvServletRequestParameters ilvServletRequestParameters2 = ilvServletRequestParameters;
        IlvIMapWriterMT ilvIMapWriterMT = this.c(string, ilvServletRequestParameters);
        if (ilvIMapWriterMT == null) {
            throw new ServletException("Unknown or missing component");
        }
        if (LEGEND_COMPONENT.equals(string)) {
            IlvLegend ilvLegend = this.getLegend(ilvServletRequestParameters);
            Object object = ilvLegend.getLock();
            synchronized (object) {
                ilvIMapWriterMT.prepareComponent(ilvServletRequestParameters2);
                ilvIMapWriterMT.writeIMapMT(printWriter, ilvServletRequestParameters2);
            }
        }
        IlvChart ilvChart = ilvIMapWriterMT.getChart();
        IlvChart.IlvChartPaintContext ilvChartPaintContext = CHART_COMPONENT.equals(string) ? new IlvChart.IlvChartPaintContext(n3, n2, ilvChart) : new IlvChart.IlvChartPaintContext(n3, n2, ilvChart.getChartArea());
        Object object = ilvChart.getLock();
        synchronized (object) {
            Map map;
            Rectangle rectangle;
            IlvLegend ilvLegend;
            ilvChart.startSession(ilvChartPaintContext);
            ilvIMapWriterMT.prepareComponent(ilvServletRequestParameters2);
            if (AREA_COMPONENT.equals(string) || (ilvLegend = ilvChart.getLegend()) == null || ilvLegend.getParent() != ilvChart || (rectangle = (Rectangle)(map = ilvChartPaintContext.getBounds()).get(ilvLegend)) != null) {
                // empty if block
            }
            ilvIMapWriterMT.writeIMapMT(printWriter, ilvServletRequestParameters2);
            ilvChart.endSession(ilvChartPaintContext);
        }
        if (this.isVerbose(ilvServletRequestParameters)) {
            System.out.println("Ends generating ImageMap");
        }
    }

    protected void generateMapAreaTags(PrintWriter printWriter, IlvServletRequestParameters ilvServletRequestParameters, IlvChart ilvChart) throws IOException {
        int n2;
        HttpServletRequest httpServletRequest = ilvServletRequestParameters.getServletRequest();
        IlvImageMapBuilder ilvImageMapBuilder = this.createImageMapBuilder(ilvServletRequestParameters, ilvChart);
        IlvIMapDefinition ilvIMapDefinition = this.getIMapDefinition(ilvServletRequestParameters, ilvChart);
        if (ilvIMapDefinition == null) {
            return;
        }
        String string = ilvServletRequestParameters.getString(COMPONENT_PARAM, CHART_COMPONENT);
        ilvIMapDefinition.setChartOrigin(CHART_COMPONENT.equals(string));
        String[] stringArray = null;
        if (!LEGEND_COMPONENT.equals(string)) {
            stringArray = ilvImageMapBuilder.getRendererTags(ilvIMapDefinition);
            if (stringArray == null) {
                return;
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                printWriter.println(stringArray[n2]);
            }
        }
        if (LEGEND_COMPONENT.equals(string) || CHART_COMPONENT.equals(string) && ilvChart.getLegend() != null && ilvChart.getLegend().getParent() == ilvChart) {
            stringArray = ilvImageMapBuilder.getLegendItemTags(ilvIMapDefinition);
            if (stringArray == null) {
                return;
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                printWriter.println(stringArray[n2]);
            }
        }
    }

    private void d(HttpServletResponse httpServletResponse, IlvServletRequestParameters ilvServletRequestParameters) throws IOException, ServletException {
        String string = ilvServletRequestParameters.getString("format", JPEG_IMAGE_FORMAT);
        IlvImageEncoder ilvImageEncoder = this.getImageEncoder(string);
        if (ilvImageEncoder == null) {
            throw new ServletException("No image encoder registered for format \"" + string + "\"");
        }
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        BufferedImage bufferedImage = IlvChart.getNoEventThreadUpdate() ? this.generateImageMT(ilvServletRequestParameters) : this.generateImage(ilvServletRequestParameters);
        ilvImageEncoder.encode(bufferedImage, httpServletResponse, ilvServletRequestParameters);
    }

    protected BufferedImage generateImage(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
        Object object;
        Object object2;
        int n2;
        int n3;
        String string;
        try {
            string = ilvServletRequestParameters.getString(COMPONENT_PARAM, VALID_COMPONENTS, CHART_COMPONENT);
            n3 = ilvServletRequestParameters.getInteger("width");
            n2 = ilvServletRequestParameters.getInteger("height");
        }
        catch (IlvParameterException ilvParameterException) {
            throw new ServletException(ilvParameterException.getMessage());
        }
        if (this.isVerbose(ilvServletRequestParameters)) {
            System.out.println("Starts generating image");
            System.out.println("  component=" + string);
            System.out.println("  width=" + n3);
            System.out.println("  height=" + n2);
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n2, 1);
        String string2 = ilvServletRequestParameters.getString(BG_COLOR_PARAM, null);
        if (string2 != null) {
            object2 = null;
            try {
                object2 = IlvChartServletSupport.b(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ServletException(numberFormatException.getMessage());
            }
            if (object2 != null && (object = bufferedImage.getGraphics()) != null) {
                ((Graphics)object).setColor((Color)object2);
                ((Graphics)object).fillRect(0, 0, n3, n2);
                ((Graphics)object).dispose();
            }
        }
        if ((object2 = this.a(string, ilvServletRequestParameters)) == null) {
            throw new ServletException();
        }
        object = ilvServletRequestParameters;
        BufferedImage bufferedImage2 = bufferedImage;
        IlvServletRunnable ilvServletRunnable = new IlvServletRunnable((IlvAWTPainter)object2, (IlvServletRequestParameters)object, bufferedImage2, string2){
            private final /* synthetic */ IlvAWTPainter a;
            private final /* synthetic */ IlvServletRequestParameters b;
            private final /* synthetic */ BufferedImage c;
            private final /* synthetic */ String d;
            {
                this.a = ilvAWTPainter;
                this.b = ilvServletRequestParameters;
                this.c = bufferedImage;
                this.d = string;
            }

            public void run() throws ServletException {
                this.a.validateComponent();
                if (!IlvChartServletSupport.this.c(this.b)) {
                    this.a.prepareComponent(this.b);
                }
                this.a.dump(this.c, this.d == null);
            }
        };
        try {
            IlvServletUtil.invokeAndWait(ilvServletRunnable);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.isVerbose(ilvServletRequestParameters)) {
            System.out.println("Ends generating Image");
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage generateImageMT(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
        try {
            IlvMTPainter ilvMTPainter;
            int n2;
            int n3;
            String string;
            try {
                string = ilvServletRequestParameters.getString(COMPONENT_PARAM, VALID_COMPONENTS, CHART_COMPONENT);
                n3 = ilvServletRequestParameters.getInteger("width");
                n2 = ilvServletRequestParameters.getInteger("height");
            }
            catch (IlvParameterException ilvParameterException) {
                throw new ServletException(ilvParameterException.getMessage());
            }
            if (this.isVerbose(ilvServletRequestParameters)) {
                System.out.println("Starts generating image");
                System.out.println("  component=" + string);
                System.out.println("  width=" + n3);
                System.out.println("  height=" + n2);
            }
            if ((ilvMTPainter = this.e(string, ilvServletRequestParameters)) == null) {
                throw new ServletException();
            }
            IlvChart ilvChart = ilvMTPainter.getChart();
            String string2 = ilvServletRequestParameters.getString(BG_COLOR_PARAM, null);
            Color color = null;
            if (string2 != null) {
                try {
                    color = IlvChartServletSupport.b(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ServletException(numberFormatException.getMessage());
                }
            }
            BufferedImage bufferedImage = null;
            if (LEGEND_COMPONENT.equals(string)) {
                Container container = (Container)ilvMTPainter.getRoot();
                bufferedImage = ilvMTPainter.toImage(n3, n2, color);
                if (this.isVerbose(ilvServletRequestParameters)) {
                    System.out.println("Ends generating Image");
                }
            } else {
                IlvChart.IlvChartImagePaintContext ilvChartImagePaintContext = CHART_COMPONENT.equals(string) || OVERVIEW_COMPONENT.equals(string) ? new IlvChart.IlvChartImagePaintContext(n3, n2, ilvChart) : new IlvChart.IlvChartImagePaintContext(n3, n2, ilvChart.getChartArea());
                Object object = ilvChart.getLock();
                synchronized (object) {
                    ilvChart.startSession(ilvChartImagePaintContext);
                    if (!this.c(ilvServletRequestParameters)) {
                        ilvMTPainter.prepareComponent(ilvServletRequestParameters);
                    }
                    bufferedImage = ilvMTPainter.toImage(n3, n2, color);
                    if (this.isVerbose(ilvServletRequestParameters)) {
                        System.out.println("Ends generating Image");
                    }
                    ilvChart.endSession(ilvChartImagePaintContext);
                }
            }
            return bufferedImage;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static Color b(String string) throws NumberFormatException {
        Color color = null;
        if (string != null) {
            string.trim();
            int n2 = Integer.decode(string);
            color = new Color(n2);
        }
        if (color != null) {
            return color;
        }
        throw new NumberFormatException("bad color " + string);
    }

    private void e(HttpServletResponse httpServletResponse, IlvServletRequestParameters ilvServletRequestParameters) throws IOException, ServletException {
        if (IlvChart.getNoEventThreadUpdate()) {
            this.g(httpServletResponse, ilvServletRequestParameters);
        } else {
            this.f(httpServletResponse, ilvServletRequestParameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void f(HttpServletResponse httpServletResponse, IlvServletRequestParameters ilvServletRequestParameters) throws IOException, ServletException {
        IlvAWTComponentCapWriter ilvAWTComponentCapWriter;
        String string;
        String string2;
        try {
            string2 = ilvServletRequestParameters.getString("format", VALID_CAP_FORMATS, null);
            string = ilvServletRequestParameters.getString(COMPONENT_PARAM, CHART_COMPONENT);
        }
        catch (IlvParameterException ilvParameterException) {
            throw new ServletException(ilvParameterException.getMessage());
        }
        final IlvServletRequestParameters ilvServletRequestParameters2 = ilvServletRequestParameters;
        if (this.isVerbose(ilvServletRequestParameters)) {
            System.out.println("*********** Starts generating capabilities");
        }
        if ((ilvAWTComponentCapWriter = this.d(string, ilvServletRequestParameters)) == null) {
            throw new ServletException();
        }
        if (string2.equals(HTML_CAP_FORMAT)) {
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setHeader("pragma", "no-cache");
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            final PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<html>");
            printWriter.println("<head>");
            printWriter.println("<script language=\"JavaScript\">");
            IlvServletRunnable ilvServletRunnable = new IlvServletRunnable(){

                public void run() throws IOException, ServletException {
                    ilvAWTComponentCapWriter.validateComponent();
                    ilvAWTComponentCapWriter.prepareComponent(ilvServletRequestParameters2);
                    ilvAWTComponentCapWriter.writeHTMLCapabilities(printWriter, ilvServletRequestParameters2);
                }
            };
            try {
                IlvServletUtil.invokeAndWait(ilvServletRunnable);
                printWriter.println("</script>");
                printWriter.println("</head>");
                String string3 = ilvServletRequestParameters.getString("onload", null);
                if (string3 != null && string3.length() != 0) {
                    printWriter.println("<body onLoad=" + string3 + "></body>");
                } else {
                    printWriter.println("<body></body>");
                }
                printWriter.println("</html>");
            }
            finally {
                printWriter.close();
            }
        } else if (string2.equals(OCTET_CAP_FORMAT)) {
            final DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
            httpServletResponse.setContentType("application/octet-stream");
            httpServletResponse.setHeader("pragma", "no-cache");
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            IlvServletRunnable ilvServletRunnable = new IlvServletRunnable(){

                public void run() throws IOException, ServletException {
                    ilvAWTComponentCapWriter.validateComponent();
                    ilvAWTComponentCapWriter.prepareComponent(ilvServletRequestParameters2);
                    ilvAWTComponentCapWriter.writeOctetCapabilities(dataOutputStream, ilvServletRequestParameters2);
                }
            };
            try {
                IlvServletUtil.invokeAndWait(ilvServletRunnable);
            }
            finally {
                dataOutputStream.close();
            }
        } else {
            throw new ServletException();
        }
        if (this.isVerbose(ilvServletRequestParameters)) {
            System.out.println("Ends generating capabilities");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void g(HttpServletResponse httpServletResponse, IlvServletRequestParameters ilvServletRequestParameters) throws IOException, ServletException {
        IlvJComponentCapWriter ilvJComponentCapWriter;
        String string;
        String string2;
        try {
            string2 = ilvServletRequestParameters.getString("format", VALID_CAP_FORMATS, null);
            string = ilvServletRequestParameters.getString(COMPONENT_PARAM, CHART_COMPONENT);
        }
        catch (IlvParameterException ilvParameterException) {
            throw new ServletException(ilvParameterException.getMessage());
        }
        IlvServletRequestParameters ilvServletRequestParameters2 = ilvServletRequestParameters;
        if (this.isVerbose(ilvServletRequestParameters)) {
            System.out.println("*********** Starts generating capabilities");
        }
        if ((ilvJComponentCapWriter = this.f(string, ilvServletRequestParameters)) == null) {
            throw new ServletException();
        }
        int n2 = 0;
        int n3 = 0;
        try {
            n2 = ilvServletRequestParameters.getInteger("imageWidth");
            n3 = ilvServletRequestParameters.getInteger("imageHeight");
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
        IlvChart ilvChart = ilvJComponentCapWriter.getChart();
        IlvChart.IlvChartPaintContext ilvChartPaintContext = CHART_COMPONENT.equals(string) || OVERVIEW_COMPONENT.equals(string) ? new IlvChart.IlvChartPaintContext(n2, n3, ilvChart) : new IlvChart.IlvChartPaintContext(n2, n3, ilvChart.getChartArea());
        Object object = ilvChart.getLock();
        synchronized (object) {
            ilvChart.startSession(ilvChartPaintContext);
            if (string2.equals(HTML_CAP_FORMAT)) {
                httpServletResponse.setContentType("text/html");
                httpServletResponse.setHeader("pragma", "no-cache");
                httpServletResponse.setHeader("Cache-Control", "no-cache");
                PrintWriter printWriter = httpServletResponse.getWriter();
                printWriter.println("<html>");
                printWriter.println("<head>");
                printWriter.println("<script language=\"JavaScript\">");
                ilvJComponentCapWriter.prepareComponent(ilvServletRequestParameters2);
                ilvJComponentCapWriter.writeHTMLCapabilities(printWriter, ilvServletRequestParameters2);
                try {
                    printWriter.println("</script>");
                    printWriter.println("</head>");
                    String string3 = ilvServletRequestParameters.getString("onload", null);
                    if (string3 != null && string3.length() != 0) {
                        printWriter.println("<body onLoad=" + string3 + "></body>");
                    } else {
                        printWriter.println("<body></body>");
                    }
                    printWriter.println("</html>");
                }
                finally {
                    printWriter.close();
                }
            } else if (string2.equals(OCTET_CAP_FORMAT)) {
                DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
                httpServletResponse.setContentType("application/octet-stream");
                httpServletResponse.setHeader("pragma", "no-cache");
                httpServletResponse.setHeader("Cache-Control", "no-cache");
                ilvJComponentCapWriter.prepareComponent(ilvServletRequestParameters2);
                ilvJComponentCapWriter.writeOctetCapabilities(dataOutputStream, ilvServletRequestParameters2);
            } else {
                throw new ServletException();
            }
            if (this.isVerbose(ilvServletRequestParameters)) {
                System.out.println("Ends generating capabilities");
            }
            ilvChart.endSession(ilvChartPaintContext);
        }
    }

    protected void additionalTextCapabilities(IlvChart ilvChart, IlvServletRequestParameters ilvServletRequestParameters, PrintWriter printWriter) throws IOException, ServletException {
    }

    protected void additionalBinaryCapabilities(IlvChart ilvChart, IlvServletRequestParameters ilvServletRequestParameters, DataOutputStream dataOutputStream) throws IOException, ServletException {
    }

    protected void additionalOverviewTextCapabilities(IlvChart ilvChart, IlvServletRequestParameters ilvServletRequestParameters, PrintWriter printWriter) throws IOException, ServletException {
    }

    protected void additionalOverviewBinaryCapabilities(IlvChart ilvChart, IlvServletRequestParameters ilvServletRequestParameters, DataOutputStream dataOutputStream) throws IOException, ServletException {
    }

    public void setImageEncoder(String string, IlvImageEncoder ilvImageEncoder) {
        if (ilvImageEncoder != null) {
            this.c.put(string, ilvImageEncoder);
        } else {
            this.c.remove(string);
        }
    }

    public IlvImageEncoder getImageEncoder(String string) {
        return (IlvImageEncoder)this.c.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addServerAction(String string, IlvChartServerAction ilvChartServerAction) {
        HashMap hashMap = this.e;
        synchronized (hashMap) {
            IlvEventListenerCollection ilvEventListenerCollection = (IlvEventListenerCollection)this.e.get(string);
            if (ilvEventListenerCollection == null) {
                ilvEventListenerCollection = new IlvEventListenerList();
                this.e.put(string, ilvEventListenerCollection);
            }
            ilvEventListenerCollection.addListener((EventListener)ilvChartServerAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void removeServerAction(String string, IlvChartServerAction ilvChartServerAction) {
        HashMap hashMap = this.e;
        synchronized (hashMap) {
            IlvEventListenerCollection ilvEventListenerCollection = (IlvEventListenerCollection)this.e.get(string);
            if (ilvEventListenerCollection != null) {
                ilvEventListenerCollection.removeListener((EventListener)ilvChartServerAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAction(IlvServletRequestParameters ilvServletRequestParameters, IlvChart ilvChart, int n2) throws ServletException {
        IlvEventListenerCollection ilvEventListenerCollection;
        String[] stringArray;
        try {
            stringArray = ilvServletRequestParameters.getStringArray(ACTION_PARAM, ",()");
        }
        catch (IlvParameterException ilvParameterException) {
            return;
        }
        String string = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        if (this.isVerbose(ilvServletRequestParameters)) {
            System.out.print("  action=" + string + "(");
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                if (i2 != 0) {
                    System.out.print(",");
                }
                System.out.print(stringArray2[i2]);
            }
            System.out.println(")");
        }
        Object object = this.e;
        synchronized (object) {
            ilvEventListenerCollection = (IlvEventListenerCollection)this.e.get(string);
        }
        if (ilvEventListenerCollection == null) {
            return;
        }
        object = ilvEventListenerCollection.getListeners();
        if (object.hasNext()) {
            IlvChartServerActionEvent ilvChartServerActionEvent = new IlvChartServerActionEvent(this, ilvServletRequestParameters.getServletRequest(), ilvChart, string, stringArray2);
            while (object.hasNext()) {
                IlvChartServerAction ilvChartServerAction = (IlvChartServerAction)object.next();
                if (ilvChartServerAction.getExecutionThread() != n2) continue;
                ilvChartServerAction.actionPerformed(ilvChartServerActionEvent);
            }
        }
    }

    public static Rectangle toRefComp(Rectangle rectangle, IlvServletRequestParameters ilvServletRequestParameters, IlvChart ilvChart) throws IlvParameterException {
        String string = ilvServletRequestParameters.getString(COMPONENT_PARAM, VALID_COMPONENTS, CHART_COMPONENT);
        if (string.equals(CHART_COMPONENT) || string.equals(OVERVIEW_COMPONENT)) {
            Insets insets = ilvChart.getInsets();
            if (ilvChart.isPaintingImage()) {
                Rectangle rectangle2 = ilvChart.getPaintContext().getDrawRect();
                return new Rectangle(rectangle2.x + rectangle.x, rectangle2.y + rectangle.y, rectangle.width, rectangle.height);
            }
            return new Rectangle(ilvChart.getChartArea().getX() + rectangle.x, ilvChart.getChartArea().getY() + rectangle.y, rectangle.width, rectangle.height);
        }
        return rectangle;
    }

    public static Point toRefComp(Point point, IlvServletRequestParameters ilvServletRequestParameters, IlvChart ilvChart) throws IlvParameterException {
        String string = ilvServletRequestParameters.getString(COMPONENT_PARAM, VALID_COMPONENTS, CHART_COMPONENT);
        if (string.equals(CHART_COMPONENT) || string.equals(OVERVIEW_COMPONENT)) {
            if (ilvChart.isPaintingImage()) {
                Rectangle rectangle = ilvChart.getPaintContext().getDrawRect();
                return new Point(rectangle.x + point.x, rectangle.y + point.y);
            }
            return new Point(ilvChart.getChartArea().getX() + point.x, ilvChart.getChartArea().getY() + point.y);
        }
        return point;
    }

    public static Rectangle toChartArea(Rectangle rectangle, IlvServletRequestParameters ilvServletRequestParameters, IlvChart ilvChart) throws IlvParameterException {
        String string = ilvServletRequestParameters.getString(COMPONENT_PARAM, VALID_COMPONENTS, CHART_COMPONENT);
        if (string.equals(CHART_COMPONENT) || string.equals(OVERVIEW_COMPONENT)) {
            if (ilvChart.isPaintingImage()) {
                Rectangle rectangle2 = ilvChart.getPaintContext().getDrawRect();
                return new Rectangle(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y, rectangle.width, rectangle.height);
            }
            return new Rectangle(rectangle.x - ilvChart.getChartArea().getX(), rectangle.y - ilvChart.getChartArea().getY(), rectangle.width, rectangle.height);
        }
        return rectangle;
    }

    public static Point toChartArea(Point point, IlvServletRequestParameters ilvServletRequestParameters, IlvChart ilvChart) throws IlvParameterException {
        String string = ilvServletRequestParameters.getString(COMPONENT_PARAM, VALID_COMPONENTS, CHART_COMPONENT);
        if (string.equals(CHART_COMPONENT) || string.equals(OVERVIEW_COMPONENT)) {
            if (ilvChart.isPaintingImage()) {
                Rectangle rectangle = ilvChart.getPaintContext().getDrawRect();
                return new Point(point.x - rectangle.x, point.y - rectangle.y);
            }
            return new Point(point.x - ilvChart.getChartArea().getX(), point.y - ilvChart.getChartArea().getY());
        }
        return point;
    }

    private static String c(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        block3: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case ' ': {
                    stringBuffer.append("%20");
                    continue block3;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String d(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        block3: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block3;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    protected IlvLegend getLegend(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
        return this.getChart(ilvServletRequestParameters).getLegend();
    }

    private IlvAWTPainter a(String string, IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
        IlvChart ilvChart = this.a(ilvServletRequestParameters);
        IlvAWTPainter ilvAWTPainter = null;
        if (CHART_COMPONENT.equals(string) || OVERVIEW_COMPONENT.equals(string)) {
            ilvAWTPainter = new IlvChartPainter(ilvChart);
        } else if (AREA_COMPONENT.equals(string)) {
            ilvAWTPainter = new IlvChartAreaPainter(ilvChart.getChartArea());
        } else if (LEGEND_COMPONENT.equals(string)) {
            ilvAWTPainter = new IlvLegendPainter(this.getLegend(ilvServletRequestParameters));
        }
        return ilvAWTPainter;
    }

    private IlvJComponentIMapWriter b(String string, IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
        IlvChart ilvChart = this.a(ilvServletRequestParameters);
        IlvJComponentIMapWriter ilvJComponentIMapWriter = null;
        if (CHART_COMPONENT.equals(string)) {
            ilvJComponentIMapWriter = new IlvChartIMapWriter(ilvChart);
        } else if (AREA_COMPONENT.equals(string)) {
            ilvJComponentIMapWriter = new IlvChartAreaIMapWriter(ilvChart.getChartArea());
        } else if (LEGEND_COMPONENT.equals(string)) {
            ilvJComponentIMapWriter = new IlvLegendIMapWriter(this.getLegend(ilvServletRequestParameters));
        }
        return ilvJComponentIMapWriter;
    }

    private IlvIMapWriterMT c(String string, IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
        IlvChart ilvChart = this.a(ilvServletRequestParameters);
        IlvIMapWriterMT ilvIMapWriterMT = null;
        if (CHART_COMPONENT.equals(string)) {
            ilvIMapWriterMT = new IlvChartIMapWriterMT(ilvChart);
        } else if (AREA_COMPONENT.equals(string)) {
            ilvIMapWriterMT = new IlvChartAreaIMapWriterMT(ilvChart.getChartArea());
        } else if (LEGEND_COMPONENT.equals(string)) {
            ilvIMapWriterMT = new IlvLegendIMapWriterMT(this.getLegend(ilvServletRequestParameters));
        }
        return ilvIMapWriterMT;
    }

    private IlvAWTComponentCapWriter d(String string, IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
        IlvAWTComponentCapWriter ilvAWTComponentCapWriter = null;
        if (CHART_COMPONENT.equals(string)) {
            ilvAWTComponentCapWriter = new IlvAWTChartCapWriter(this.getChart(ilvServletRequestParameters));
        } else if (OVERVIEW_COMPONENT.equals(string)) {
            IlvChart ilvChart = this.b(ilvServletRequestParameters);
            if (ilvChart == null) {
                throw new ServletException("Overview capabilities requested while there is no overview chart.");
            }
            ilvAWTComponentCapWriter = new IlvAWTOverviewCapWriter(ilvChart);
        }
        return ilvAWTComponentCapWriter;
    }

    private IlvMTPainter e(String string, IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
        IlvChart ilvChart = this.a(ilvServletRequestParameters);
        IlvMTPainter ilvMTPainter = null;
        if (CHART_COMPONENT.equals(string) || OVERVIEW_COMPONENT.equals(string)) {
            ilvMTPainter = new IlvChartMTPainter(ilvChart);
        } else if (AREA_COMPONENT.equals(string)) {
            ilvMTPainter = new IlvChartAreaMTPainter(ilvChart.getChartArea());
        } else if (LEGEND_COMPONENT.equals(string)) {
            ilvMTPainter = new IlvLegendMTPainter(this.getLegend(ilvServletRequestParameters));
        }
        return ilvMTPainter;
    }

    private IlvJComponentCapWriter f(String string, IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
        IlvJComponentCapWriter ilvJComponentCapWriter = null;
        if (CHART_COMPONENT.equals(string) || AREA_COMPONENT.equals(string)) {
            ilvJComponentCapWriter = new IlvMTChartCapWriter(this.getChart(ilvServletRequestParameters));
        } else if (OVERVIEW_COMPONENT.equals(string)) {
            IlvChart ilvChart = this.b(ilvServletRequestParameters);
            if (ilvChart == null) {
                throw new ServletException("Overview capabilities requested while there is no overview chart.");
            }
            ilvJComponentCapWriter = new IlvMTOverviewCapWriter(ilvChart);
        }
        return ilvJComponentCapWriter;
    }

    class OverviewCapWriter
    implements CapWriter {
        OverviewCapWriter() {
        }

        public void writeHTMLCapabilities(JComponent jComponent, PrintWriter printWriter, IlvServletRequestParameters ilvServletRequestParameters) throws IOException, ServletException {
            IlvChart ilvChart = (IlvChart)jComponent;
            IlvDataWindow ilvDataWindow = IlvChartServletSupport.this.getChart(ilvServletRequestParameters).getCoordinateSystem(0).getVisibleWindow();
            Rectangle rectangle = ilvChart.getProjector().toRectangle(ilvDataWindow, ilvChart.getProjectorRect(), ilvChart.getCoordinateSystem(0));
            try {
                rectangle = IlvChartServletSupport.toRefComp(rectangle, ilvServletRequestParameters, ilvChart);
            }
            catch (IlvParameterException ilvParameterException) {
                throw new ServletException(ilvParameterException.getMessage());
            }
            printWriter.println("var visLeft=" + rectangle.getX());
            printWriter.println("var visTop=" + rectangle.getY());
            printWriter.println("var visWidth=" + rectangle.getWidth());
            printWriter.println("var visHeight=" + rectangle.getHeight());
            Rectangle rectangle2 = ilvChart.getChartArea().getPlotRect();
            try {
                rectangle2 = IlvChartServletSupport.toRefComp(rectangle2, ilvServletRequestParameters, ilvChart);
            }
            catch (IlvParameterException ilvParameterException) {
                throw new ServletException(ilvParameterException.getMessage());
            }
            printWriter.println("var xPlotRect=" + rectangle2.x + ";");
            printWriter.println("var yPlotRect=" + rectangle2.y + ";");
            printWriter.println("var widthPlotRect=" + rectangle2.width + ";");
            printWriter.println("var heightPlotRect=" + rectangle2.height + ";");
            printWriter.println("var is3D=" + ilvChart.is3D() + ";");
            printWriter.println("var isCartesian=" + (ilvChart.getType() == 1) + ";");
            IlvChartServletSupport.this.additionalOverviewTextCapabilities(ilvChart, ilvServletRequestParameters, printWriter);
        }

        public void writeOctetCapabilities(JComponent jComponent, DataOutputStream dataOutputStream, IlvServletRequestParameters ilvServletRequestParameters) throws IOException, ServletException {
            IlvChart ilvChart = (IlvChart)jComponent;
            IlvDataWindow ilvDataWindow = IlvChartServletSupport.this.getChart(ilvServletRequestParameters).getCoordinateSystem(0).getVisibleWindow();
            Rectangle rectangle = ilvChart.getProjector().toRectangle(ilvDataWindow, ilvChart.getProjectorRect(), ilvChart.getCoordinateSystem(0));
            dataOutputStream.writeInt(rectangle.x);
            dataOutputStream.writeInt(rectangle.y);
            dataOutputStream.writeInt(rectangle.width);
            dataOutputStream.writeInt(rectangle.height);
            Rectangle rectangle2 = ilvChart.getChartArea().getPlotRect();
            try {
                rectangle2 = IlvChartServletSupport.toRefComp(rectangle2, ilvServletRequestParameters, ilvChart);
            }
            catch (IlvParameterException ilvParameterException) {
                throw new ServletException(ilvParameterException.getMessage());
            }
            dataOutputStream.writeInt(rectangle2.x);
            dataOutputStream.writeInt(rectangle2.y);
            dataOutputStream.writeInt(rectangle2.width);
            dataOutputStream.writeInt(rectangle2.height);
            dataOutputStream.writeBoolean(ilvChart.is3D());
            dataOutputStream.writeBoolean(ilvChart.getType() == 1);
            IlvChartServletSupport.this.additionalOverviewBinaryCapabilities(ilvChart, ilvServletRequestParameters, dataOutputStream);
        }
    }

    class ChartCapWriter
    implements CapWriter {
        ChartCapWriter() {
        }

        protected Rectangle computePlotRect(IlvChart ilvChart, IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            Rectangle rectangle = ilvChart.getChartArea().getPlotRect();
            try {
                rectangle = IlvChartServletSupport.toRefComp(rectangle, ilvServletRequestParameters, ilvChart);
            }
            catch (IlvParameterException ilvParameterException) {
                throw new ServletException(ilvParameterException.getMessage());
            }
            return rectangle;
        }

        public void writeHTMLCapabilities(JComponent jComponent, PrintWriter printWriter, IlvServletRequestParameters ilvServletRequestParameters) throws IOException, ServletException {
            IlvChart ilvChart = (IlvChart)jComponent;
            IlvAxis ilvAxis = ilvChart.getXAxis();
            printWriter.println("var xVisibleMin=" + ilvAxis.getVisibleMin() + ";");
            printWriter.println("var xVisibleMax=" + ilvAxis.getVisibleMax() + ";");
            printWriter.println("var xDataMin=" + ilvAxis.getDataMin() + ";");
            printWriter.println("var xDataMax=" + ilvAxis.getDataMax() + ";");
            ilvAxis = ilvChart.getYAxis(0);
            printWriter.println("var yVisibleMin=" + ilvAxis.getVisibleMin() + ";");
            printWriter.println("var yVisibleMax=" + ilvAxis.getVisibleMax() + ";");
            printWriter.println("var yDataMin=" + ilvAxis.getDataMin() + ";");
            printWriter.println("var yDataMax=" + ilvAxis.getDataMax() + ";");
            printWriter.println("var xHorizontal=" + !ilvChart.isProjectorReversed() + ";");
            Rectangle rectangle = this.computePlotRect(ilvChart, ilvServletRequestParameters);
            printWriter.println("var xPlotRect=" + rectangle.x + ";");
            printWriter.println("var yPlotRect=" + rectangle.y + ";");
            printWriter.println("var widthPlotRect=" + rectangle.width + ";");
            printWriter.println("var heightPlotRect=" + rectangle.height + ";");
            printWriter.println("var is3D=" + ilvChart.is3D() + ";");
            printWriter.println("var isCartesian=" + (ilvChart.getType() == 1) + ";");
            printWriter.println("var dataSets=new Array();");
            HashSet<IlvDataSet> hashSet = new HashSet<IlvDataSet>();
            Iterator iterator = ilvChart.getDataSetIterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                IlvDataSet ilvDataSet = (IlvDataSet)iterator.next();
                if (!hashSet.add(ilvDataSet)) continue;
                printWriter.println("dataSets[" + n2++ + "]=\"" + ilvDataSet.getName() + "\";");
            }
            printWriter.flush();
            IlvChartServletSupport.this.additionalTextCapabilities(ilvChart, ilvServletRequestParameters, printWriter);
        }

        public void writeOctetCapabilities(JComponent jComponent, DataOutputStream dataOutputStream, IlvServletRequestParameters ilvServletRequestParameters) throws IOException, ServletException {
            IlvChart ilvChart = (IlvChart)jComponent;
            IlvAxis ilvAxis = ilvChart.getXAxis();
            dataOutputStream.writeDouble(ilvAxis.getVisibleMin());
            dataOutputStream.writeDouble(ilvAxis.getVisibleMax());
            dataOutputStream.writeDouble(ilvAxis.getDataMin());
            dataOutputStream.writeDouble(ilvAxis.getDataMax());
            ilvAxis = ilvChart.getYAxis(0);
            dataOutputStream.writeDouble(ilvAxis.getVisibleMin());
            dataOutputStream.writeDouble(ilvAxis.getVisibleMax());
            dataOutputStream.writeDouble(ilvAxis.getDataMin());
            dataOutputStream.writeDouble(ilvAxis.getDataMax());
            dataOutputStream.writeBoolean(!ilvChart.isProjectorReversed());
            Rectangle rectangle = this.computePlotRect(ilvChart, ilvServletRequestParameters);
            dataOutputStream.writeInt(rectangle.x);
            dataOutputStream.writeInt(rectangle.y);
            dataOutputStream.writeInt(rectangle.width);
            dataOutputStream.writeInt(rectangle.height);
            dataOutputStream.writeBoolean(ilvChart.is3D());
            dataOutputStream.writeBoolean(ilvChart.getType() == 1);
            HashSet<IlvDataSet> hashSet = new HashSet<IlvDataSet>();
            Iterator iterator = ilvChart.getDataSetIterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                IlvDataSet ilvDataSet = (IlvDataSet)iterator.next();
                if (!hashSet.add(ilvDataSet)) continue;
                dataOutputStream.writeUTF(ilvDataSet.getName());
            }
            dataOutputStream.flush();
            IlvChartServletSupport.this.additionalBinaryCapabilities(ilvChart, ilvServletRequestParameters, dataOutputStream);
        }
    }

    class IlvAWTOverviewCapWriter
    extends IlvAWTComponentCapWriter {
        public IlvAWTOverviewCapWriter(IlvChart ilvChart) {
            super(ilvChart, new OverviewCapWriter());
        }

        public void prepareComponent(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            IlvChartServletSupport.this.prepareOverviewChart(ilvServletRequestParameters, (IlvChart)this.component);
        }

        protected IlvChart getChart() {
            return (IlvChart)this.component;
        }
    }

    class IlvMTOverviewCapWriter
    extends IlvJComponentCapWriter {
        public IlvMTOverviewCapWriter(IlvChart ilvChart) {
            super(ilvChart, new OverviewCapWriter());
        }

        public void prepareComponent(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            IlvChartServletSupport.this.prepareOverviewChart(ilvServletRequestParameters, (IlvChart)this.component);
        }

        protected IlvChart getChart() {
            return (IlvChart)this.component;
        }
    }

    class IlvMTChartCapWriter
    extends IlvJComponentCapWriter {
        public IlvMTChartCapWriter(IlvChart ilvChart) {
            super(ilvChart, new ChartCapWriter());
        }

        public void prepareComponent(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            IlvChartServletSupport.this.a(ilvServletRequestParameters, (IlvChart)this.component);
            IlvChartServletSupport.this.executeAction(ilvServletRequestParameters, (IlvChart)this.component, 1);
        }

        protected IlvChart getChart() {
            return (IlvChart)this.component;
        }
    }

    class IlvAWTChartCapWriter
    extends IlvAWTComponentCapWriter {
        public IlvAWTChartCapWriter(IlvChart ilvChart) {
            super(ilvChart, new ChartCapWriter());
        }

        public void prepareComponent(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            IlvChartServletSupport.this.a(ilvServletRequestParameters, (IlvChart)this.component);
            IlvChartServletSupport.this.executeAction(ilvServletRequestParameters, (IlvChart)this.component, 1);
        }

        protected IlvChart getChart() {
            return (IlvChart)this.component;
        }
    }

    abstract class IlvAWTComponentCapWriter
    extends IlvJComponentCapWriter {
        public IlvAWTComponentCapWriter(JComponent jComponent, CapWriter capWriter) {
            super(jComponent, capWriter);
        }

        protected void writeHTMLCapabilities(PrintWriter printWriter, IlvServletRequestParameters ilvServletRequestParameters) throws IOException, ServletException {
            this.component.validate();
            super.writeHTMLCapabilities(printWriter, ilvServletRequestParameters);
        }

        protected void writeOctetCapabilities(DataOutputStream dataOutputStream, IlvServletRequestParameters ilvServletRequestParameters) throws IOException, ServletException {
            this.component.validate();
            super.writeOctetCapabilities(dataOutputStream, ilvServletRequestParameters);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void validateComponent() {
            Component component;
            Component component2 = component = this.getRoot();
            synchronized (component2) {
                if (component.getParent() == null) {
                    Container container = IlvJHiddenPrintWindowFactory.createHiddenPrintWindow();
                    container.add(component);
                }
            }
        }
    }

    abstract class IlvJComponentCapWriter
    extends IlvJComponentHandler {
        CapWriter a;

        public IlvJComponentCapWriter(JComponent jComponent, CapWriter capWriter) {
            super(jComponent);
            this.a = capWriter;
        }

        protected void writeHTMLCapabilities(PrintWriter printWriter, IlvServletRequestParameters ilvServletRequestParameters) throws IOException, ServletException {
            this.a.writeHTMLCapabilities(this.component, printWriter, ilvServletRequestParameters);
        }

        protected void writeOctetCapabilities(DataOutputStream dataOutputStream, IlvServletRequestParameters ilvServletRequestParameters) throws IOException, ServletException {
            this.a.writeOctetCapabilities(this.component, dataOutputStream, ilvServletRequestParameters);
        }

        protected abstract IlvChart getChart();
    }

    private static interface CapWriter {
        public void writeHTMLCapabilities(JComponent var1, PrintWriter var2, IlvServletRequestParameters var3) throws IOException, ServletException;

        public void writeOctetCapabilities(JComponent var1, DataOutputStream var2, IlvServletRequestParameters var3) throws IOException, ServletException;
    }

    static final class IlvLegendMTPainter
    extends IlvMTPainter {
        public IlvLegendMTPainter(IlvLegend ilvLegend) {
            super(ilvLegend);
        }

        public BufferedImage toImage(int n2, int n3, Color color) {
            return ((IlvLegend)this.component).toImage(null, n2, n3, color);
        }

        protected IlvChart getChart() {
            return ((IlvLegend)this.component).getChart();
        }
    }

    final class IlvChartAreaMTPainter
    extends IlvMTPainter {
        public IlvChartAreaMTPainter(IlvChart.Area area) {
            super(area);
        }

        public void prepareComponent(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            IlvChart ilvChart = ((IlvChart.Area)this.component).getChart();
            IlvChartServletSupport.this.a(ilvServletRequestParameters, ilvChart);
            IlvChartServletSupport.this.executeAction(ilvServletRequestParameters, ilvChart, 1);
        }

        public BufferedImage toImage(int n2, int n3, Color color) {
            return ((IlvChart.Area)this.component).toImage(n2, n3, color);
        }

        protected IlvChart getChart() {
            return ((IlvChart.Area)this.component).getChart();
        }
    }

    class IlvChartMTPainter
    extends IlvMTPainter {
        public IlvChartMTPainter(IlvChart ilvChart) {
            super(ilvChart);
        }

        public void prepareComponent(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            IlvChartServletSupport.this.a(ilvServletRequestParameters, (IlvChart)this.component);
            IlvChartServletSupport.this.executeAction(ilvServletRequestParameters, (IlvChart)this.component, 1);
        }

        public BufferedImage toImage(int n2, int n3, Color color) {
            return ((IlvChart)this.component).toImage(n2, n3, color);
        }

        protected IlvChart getChart() {
            return (IlvChart)this.component;
        }
    }

    static abstract class IlvMTPainter
    extends IlvJComponentHandler {
        public IlvMTPainter(JComponent jComponent) {
            super(jComponent);
        }

        public abstract BufferedImage toImage(int var1, int var2, Color var3);

        protected abstract IlvChart getChart();
    }

    static final class IlvLegendPainter
    extends IlvAWTPainter {
        public IlvLegendPainter(IlvLegend ilvLegend) {
            super(ilvLegend);
        }

        protected Component getRoot() {
            IlvChart ilvChart = ((IlvLegend)this.component).getChart();
            return this.component.getParent() == ilvChart ? ilvChart : this.component;
        }

        protected void resizeComponent(int n2, int n3) {
            super.resizeComponent(n2, n3);
            IlvChart ilvChart = ((IlvLegend)this.component).getChart();
            if (this.component.getParent() == ilvChart && !((IlvLegend)this.component).isFloating()) {
                ilvChart.setPreferredSize(null);
                ilvChart.setSize(ilvChart.getPreferredSize());
            }
        }

        protected void toImage(BufferedImage bufferedImage, boolean bl) {
            ((IlvLegend)this.component).toImage(bufferedImage, bl);
        }
    }

    final class IlvChartAreaPainter
    extends IlvAWTPainter {
        public IlvChartAreaPainter(IlvChart.Area area) {
            super(area);
        }

        public void prepareComponent(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            IlvChart ilvChart = ((IlvChart.Area)this.component).getChart();
            IlvChartServletSupport.this.a(ilvServletRequestParameters, ilvChart);
            IlvChartServletSupport.this.executeAction(ilvServletRequestParameters, ilvChart, 1);
        }

        protected Component getRoot() {
            return this.component.getParent();
        }

        protected void resizeComponent(int n2, int n3) {
            super.resizeComponent(n2, n3);
            IlvChart ilvChart = ((IlvChart.Area)this.component).getChart();
            ilvChart.setPreferredSize(null);
            ilvChart.setSize(ilvChart.getPreferredSize());
        }

        protected void toImage(BufferedImage bufferedImage, boolean bl) {
            ((IlvChart.Area)this.component).toImage(bufferedImage, bl);
        }
    }

    class IlvChartPainter
    extends IlvAWTPainter {
        public IlvChartPainter(IlvChart ilvChart) {
            super(ilvChart);
        }

        public void prepareComponent(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            IlvChartServletSupport.this.a(ilvServletRequestParameters, (IlvChart)this.component);
            IlvChartServletSupport.this.executeAction(ilvServletRequestParameters, (IlvChart)this.component, 1);
        }

        protected void toImage(BufferedImage bufferedImage, boolean bl) {
            ((IlvChart)this.component).toImage(bufferedImage, bl);
        }
    }

    static abstract class IlvAWTPainter
    extends IlvAWTJComponentHandler {
        public IlvAWTPainter(JComponent jComponent) {
            super(jComponent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(BufferedImage bufferedImage, boolean bl) {
            Container container = this.getParent();
            LayoutManager layoutManager = container.getLayout();
            try {
                container.setLayout(null);
                this.resizeComponent(bufferedImage.getWidth(), bufferedImage.getHeight());
                container.validate();
                this.toImage(bufferedImage, bl);
            }
            finally {
                container.setLayout(layoutManager);
            }
        }

        protected abstract void toImage(BufferedImage var1, boolean var2);
    }

    final class IlvLegendIMapWriterMT
    extends IlvIMapWriterMT {
        public IlvLegendIMapWriterMT(IlvLegend ilvLegend) {
            super(ilvLegend);
        }

        protected IlvChart getChart() {
            return ((IlvLegend)this.component).getChart();
        }

        protected Component getRoot() {
            IlvChart ilvChart = ((IlvLegend)this.component).getChart();
            return this.component.getParent() == ilvChart ? ilvChart : this.component;
        }

        public void prepareComponent(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            super.prepareComponent(ilvServletRequestParameters);
            try {
                int n2 = ilvServletRequestParameters.getInteger("width");
                int n3 = ilvServletRequestParameters.getInteger("height");
                this.component.putClientProperty("_Ilv_Legend_Bounds_NOAWT", new Dimension(n2, n3));
            }
            catch (IlvParameterException ilvParameterException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeIMapMT(PrintWriter printWriter, IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            try {
                super.writeIMapMT(printWriter, ilvServletRequestParameters);
            }
            finally {
                this.component.putClientProperty("_Ilv_Legend_Bounds_NOAWT", null);
            }
        }
    }

    final class IlvLegendIMapWriter
    extends IlvJComponentIMapWriter {
        public IlvLegendIMapWriter(IlvLegend ilvLegend) {
            super(ilvLegend);
        }

        protected IlvChart getChart() {
            return ((IlvLegend)this.component).getChart();
        }

        protected Component getRoot() {
            IlvChart ilvChart = ((IlvLegend)this.component).getChart();
            return this.component.getParent() == ilvChart ? ilvChart : this.component;
        }

        protected void resizeComponent(int n2, int n3) {
            super.resizeComponent(n2, n3);
            IlvChart ilvChart = ((IlvLegend)this.component).getChart();
            if (this.component.getParent() == ilvChart && !((IlvLegend)this.component).isFloating()) {
                ilvChart.setPreferredSize(null);
                ilvChart.setSize(ilvChart.getPreferredSize());
            }
        }
    }

    class IlvChartAreaIMapWriterMT
    extends IlvIMapWriterMT {
        public IlvChartAreaIMapWriterMT(IlvChart.Area area) {
            super(area);
        }

        public void prepareComponent(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            IlvChart ilvChart = ((IlvChart.Area)this.component).getChart();
            IlvChartServletSupport.this.a(ilvServletRequestParameters, ilvChart);
            IlvChartServletSupport.this.executeAction(ilvServletRequestParameters, ilvChart, 2);
        }

        protected IlvChart getChart() {
            return ((IlvChart.Area)this.component).getChart();
        }

        protected Component getRoot() {
            return this.component.getParent();
        }

        protected void resizeComponent(int n2, int n3) {
            super.resizeComponent(n2, n3);
            IlvChart ilvChart = ((IlvChart.Area)this.component).getChart();
            ilvChart.setPreferredSize(null);
            ilvChart.setSize(ilvChart.getPreferredSize());
        }
    }

    class IlvChartAreaIMapWriter
    extends IlvJComponentIMapWriter {
        public IlvChartAreaIMapWriter(IlvChart.Area area) {
            super(area);
        }

        public void prepareComponent(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            IlvChart ilvChart = ((IlvChart.Area)this.component).getChart();
            IlvChartServletSupport.this.a(ilvServletRequestParameters, ilvChart);
            IlvChartServletSupport.this.executeAction(ilvServletRequestParameters, ilvChart, 1);
        }

        protected IlvChart getChart() {
            return ((IlvChart.Area)this.component).getChart();
        }

        protected Component getRoot() {
            return this.component.getParent();
        }

        protected void resizeComponent(int n2, int n3) {
            super.resizeComponent(n2, n3);
            IlvChart ilvChart = ((IlvChart.Area)this.component).getChart();
            ilvChart.setPreferredSize(null);
            ilvChart.setSize(ilvChart.getPreferredSize());
        }
    }

    class IlvChartIMapWriterMT
    extends IlvIMapWriterMT {
        public IlvChartIMapWriterMT(IlvChart ilvChart) {
            super(ilvChart);
        }

        public void prepareComponent(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            IlvChartServletSupport.this.a(ilvServletRequestParameters, (IlvChart)this.component);
            IlvChartServletSupport.this.executeAction(ilvServletRequestParameters, (IlvChart)this.component, 2);
        }

        protected IlvChart getChart() {
            return (IlvChart)this.component;
        }
    }

    class IlvChartIMapWriter
    extends IlvJComponentIMapWriter {
        public IlvChartIMapWriter(IlvChart ilvChart) {
            super(ilvChart);
        }

        public void prepareComponent(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            IlvChartServletSupport.this.a(ilvServletRequestParameters, (IlvChart)this.component);
            IlvChartServletSupport.this.executeAction(ilvServletRequestParameters, (IlvChart)this.component, 1);
        }

        protected IlvChart getChart() {
            return (IlvChart)this.component;
        }
    }

    abstract class IlvJComponentIMapWriter
    extends IlvAWTJComponentHandler {
        public IlvJComponentIMapWriter(JComponent jComponent) {
            super(jComponent);
        }

        protected abstract IlvChart getChart();

        public void writeIMap(PrintWriter printWriter, IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            CharSequence charSequence;
            StringBuffer stringBuffer;
            int n2 = 0;
            int n3 = 0;
            String string = null;
            String string2 = ilvServletRequestParameters.getString(IlvChartServletSupport.IMAGEMAP_NAME, IlvChartServletSupport.IMAGEMAP_REQUEST);
            try {
                n2 = ilvServletRequestParameters.getInteger("width");
                n3 = ilvServletRequestParameters.getInteger("height");
                string = ilvServletRequestParameters.getString(IlvChartServletSupport.IMAGE_REQUEST, null);
            }
            catch (IlvParameterException ilvParameterException) {
                // empty catch block
            }
            Container container = this.getParent();
            LayoutManager layoutManager = container.getLayout();
            boolean bl = false;
            try {
                container.setLayout(null);
                this.resizeComponent(n2, n3);
                container.validate();
                bl = this.a(printWriter, ilvServletRequestParameters);
                stringBuffer = new StringBuffer("<map name=\"");
                charSequence = stringBuffer.append(string2).append("\" id=\"").append(string2).append("\">").toString();
                printWriter.println((String)charSequence);
                IlvChartServletSupport.this.generateMapAreaTags(printWriter, ilvServletRequestParameters, this.getChart());
                printWriter.println("</map>");
            }
            catch (IOException iOException) {
                throw new ServletException(iOException.getMessage());
            }
            finally {
                container.setLayout(layoutManager);
            }
            if (string == null || string.length() == 0) {
                CharSequence charSequence2;
                stringBuffer = ilvServletRequestParameters.getServletRequest();
                charSequence = new StringBuffer(stringBuffer.getRequestURI());
                ((StringBuffer)charSequence).append("?request=image");
                Enumeration enumeration = stringBuffer.getParameterNames();
                while (enumeration.hasMoreElements()) {
                    charSequence2 = (String)enumeration.nextElement();
                    if (((String)charSequence2).equals(IlvChartServletSupport.REQUEST_PARAM) || this.a((String)charSequence2)) continue;
                    String[] stringArray = stringBuffer.getParameterValues((String)charSequence2);
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        ((StringBuffer)charSequence).append("&");
                        ((StringBuffer)charSequence).append((String)charSequence2);
                        ((StringBuffer)charSequence).append("=");
                        ((StringBuffer)charSequence).append(IlvChartServletSupport.c(stringArray[i2]));
                    }
                }
                ((StringBuffer)charSequence).append("&fromImageMap=true");
                charSequence2 = new StringBuffer("<img usemap=\"#");
                ((StringBuffer)charSequence2).append(string2).append("\" width=\"").append(n2);
                ((StringBuffer)charSequence2).append("\" height=\"").append(n3);
                ((StringBuffer)charSequence2).append("\" src=\"").append(((StringBuffer)charSequence).toString());
                ((StringBuffer)charSequence2).append("\" border=0>");
                printWriter.println(((StringBuffer)charSequence2).toString());
            } else {
                stringBuffer = new StringBuffer("<img usemap=\"#");
                stringBuffer.append(string2).append("\" width=\"").append(n2);
                stringBuffer.append("\" height=\"").append(n3);
                stringBuffer.append("\" src=\"").append(string);
                stringBuffer.append("\" border=0>");
                printWriter.println(stringBuffer.toString());
            }
            if (bl) {
                printWriter.println("</body>");
            }
        }

        boolean a(String string) {
            return !string.equals("onload") && !string.equals("onclick") && !string.equals("onmouseover");
        }

        boolean a(PrintWriter printWriter, IlvServletRequestParameters ilvServletRequestParameters) {
            String string = null;
            String string2 = null;
            String string3 = null;
            string = ilvServletRequestParameters.getString("onload", null);
            string2 = ilvServletRequestParameters.getString("onclick", null);
            string3 = ilvServletRequestParameters.getString("onmouseover", null);
            if (string != null || string3 != null || string2 != null) {
                StringBuffer stringBuffer = new StringBuffer("<body");
                if (string != null) {
                    stringBuffer.append(" onload=");
                    stringBuffer.append(string);
                }
                if (string2 != null) {
                    stringBuffer.append(" onclick=");
                    stringBuffer.append(string2);
                }
                if (string3 != null) {
                    stringBuffer.append(" onmouseover=");
                    stringBuffer.append(string3);
                }
                stringBuffer.append(">");
                printWriter.println(stringBuffer.toString());
                return true;
            }
            return false;
        }
    }

    abstract class IlvIMapWriterMT
    extends IlvJComponentIMapWriter {
        public IlvIMapWriterMT(JComponent jComponent) {
            super(jComponent);
        }

        public void writeIMapMT(PrintWriter printWriter, IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
            CharSequence charSequence;
            StringBuffer stringBuffer;
            int n2 = 0;
            int n3 = 0;
            String string = null;
            String string2 = ilvServletRequestParameters.getString(IlvChartServletSupport.IMAGEMAP_NAME, IlvChartServletSupport.IMAGEMAP_REQUEST);
            try {
                n2 = ilvServletRequestParameters.getInteger("width");
                n3 = ilvServletRequestParameters.getInteger("height");
                string = ilvServletRequestParameters.getString(IlvChartServletSupport.IMAGE_REQUEST, null);
            }
            catch (IlvParameterException ilvParameterException) {
                // empty catch block
            }
            boolean bl = false;
            try {
                bl = this.a(printWriter, ilvServletRequestParameters);
                stringBuffer = new StringBuffer("<map name=\"");
                charSequence = stringBuffer.append(string2).append("\" id=\"").append(string2).append("\">").toString();
                printWriter.println((String)charSequence);
                IlvChartServletSupport.this.generateMapAreaTags(printWriter, ilvServletRequestParameters, this.getChart());
                printWriter.println("</map>");
            }
            catch (IOException iOException) {
                throw new ServletException(iOException.getMessage());
            }
            if (string == null || string.length() == 0) {
                CharSequence charSequence2;
                stringBuffer = ilvServletRequestParameters.getServletRequest();
                charSequence = new StringBuffer(stringBuffer.getRequestURI());
                ((StringBuffer)charSequence).append("?request=image");
                Enumeration enumeration = stringBuffer.getParameterNames();
                while (enumeration.hasMoreElements()) {
                    charSequence2 = (String)enumeration.nextElement();
                    if (((String)charSequence2).equals(IlvChartServletSupport.REQUEST_PARAM) || this.a((String)charSequence2)) continue;
                    String[] stringArray = stringBuffer.getParameterValues((String)charSequence2);
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        ((StringBuffer)charSequence).append("&");
                        ((StringBuffer)charSequence).append((String)charSequence2);
                        ((StringBuffer)charSequence).append("=");
                        ((StringBuffer)charSequence).append(IlvChartServletSupport.c(stringArray[i2]));
                    }
                }
                ((StringBuffer)charSequence).append("&fromImageMap=true");
                charSequence2 = new StringBuffer("<img usemap=\"#");
                ((StringBuffer)charSequence2).append(string2).append("\" width=\"").append(n2);
                ((StringBuffer)charSequence2).append("\" height=\"").append(n3);
                ((StringBuffer)charSequence2).append("\" src=\"").append(((StringBuffer)charSequence).toString());
                ((StringBuffer)charSequence2).append("\" border=0>");
                printWriter.println(((StringBuffer)charSequence2).toString());
            } else {
                stringBuffer = new StringBuffer("<img usemap=\"#");
                stringBuffer.append(string2).append("\" width=\"").append(n2);
                stringBuffer.append("\" height=\"").append(n3);
                stringBuffer.append("\" src=\"").append(string);
                stringBuffer.append("\" border=0>");
                printWriter.println(stringBuffer.toString());
            }
            if (bl) {
                printWriter.println("</body>");
            }
        }
    }

    static abstract class IlvAWTJComponentHandler
    extends IlvJComponentHandler {
        public IlvAWTJComponentHandler(JComponent jComponent) {
            super(jComponent);
        }

        protected void resizeComponent(int n2, int n3) {
            this.component.setSize(n2, n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void validateComponent() {
            Component component;
            Component component2 = component = this.getRoot();
            synchronized (component2) {
                if (component.getParent() == null) {
                    Container container = IlvJHiddenPrintWindowFactory.createHiddenPrintWindow();
                    container.add(component);
                }
            }
        }
    }

    static abstract class IlvJComponentHandler {
        protected JComponent component;

        public IlvJComponentHandler(JComponent jComponent) {
            this.component = jComponent;
        }

        public void prepareComponent(IlvServletRequestParameters ilvServletRequestParameters) throws ServletException {
        }

        protected final Container getParent() {
            return this.getRoot().getParent();
        }

        protected Component getRoot() {
            return this.component;
        }
    }

    private static class OverviewUpdater
    implements AxisListener {
        private IlvChart a;
        private IlvChart b;

        public OverviewUpdater(IlvChart ilvChart, IlvChart ilvChart2) {
            this.a = ilvChart;
            this.b = ilvChart2;
            ilvChart2.getXAxis().addAxisListener(this);
            ilvChart2.getYAxis(0).addAxisListener(this);
        }

        public void axisRangeChanged(AxisRangeEvent axisRangeEvent) {
            if (axisRangeEvent.isChangedEvent() && !axisRangeEvent.isVisibleRangeEvent()) {
                IlvAxis ilvAxis = axisRangeEvent.getAxis().isXAxis() ? this.a.getXAxis() : this.a.getYAxis(0);
                ilvAxis.setVisibleRange(axisRangeEvent.getNewMin(), axisRangeEvent.getNewMax());
            }
        }

        public void axisChanged(AxisChangeEvent axisChangeEvent) {
        }
    }
}

