/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.servlet;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvLegend;
import ilog.views.chart.servlet.IlvIMapArea;
import ilog.views.chart.servlet.IlvIMapAttributes;
import ilog.views.chart.servlet.IlvIMapDefinition;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class IlvImageMapBuilder {
    private IlvChart a;

    public IlvImageMapBuilder(IlvChart ilvChart) {
        this.a = ilvChart;
    }

    public final IlvChart getChart() {
        return this.a;
    }

    public String getFooterTag(IlvIMapAttributes ilvIMapAttributes) {
        JComponent jComponent = this.a.getFooter();
        return jComponent == null ? null : IlvIMapArea.createTag(jComponent.getBounds(), ilvIMapAttributes);
    }

    public String getHeaderTag(IlvIMapAttributes ilvIMapAttributes) {
        JComponent jComponent = this.a.getHeader();
        return jComponent == null ? null : IlvIMapArea.createTag(jComponent.getBounds(), ilvIMapAttributes);
    }

    public String getLegendTag(IlvIMapAttributes ilvIMapAttributes) {
        IlvLegend ilvLegend = this.a.getLegend();
        if (ilvLegend == null || ilvLegend.getParent() != this.a) {
            return null;
        }
        return IlvIMapArea.createTag(ilvLegend.getBounds(), ilvIMapAttributes);
    }

    public String[] getLegendItemTags(IlvIMapDefinition ilvIMapDefinition) {
        IlvLegend ilvLegend = this.a.getLegend();
        if (ilvLegend == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(ilvLegend.getComponentCount());
        ilvLegend.addImageMapAreas(ilvIMapDefinition, arrayList);
        int n2 = arrayList.size();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = ((IlvIMapArea)arrayList.get(i2)).getTag();
        }
        return stringArray;
    }

    public String getDataWindowTag(IlvDataWindow ilvDataWindow, int n2, IlvIMapAttributes ilvIMapAttributes, boolean bl) {
        String string = null;
        try {
            Shape shape = this.a.getProjector().getShape(ilvDataWindow, this.a.getProjectorRect(), this.a.getCoordinateSystem(n2));
            int n3 = bl ? this.a.getChartArea().getX() : 0;
            int n4 = bl ? this.a.getChartArea().getY() : 0;
            string = IlvIMapArea.a(shape, n3, n4, ilvIMapAttributes);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public String[] getRendererTags(IlvIMapDefinition ilvIMapDefinition) {
        List list = null;
        if (this.a.is3D()) {
            list = this.a.get3DView().getScene().getImageMapTags(ilvIMapDefinition);
        } else {
            list = new ArrayList(16);
            IlvChartRenderer ilvChartRenderer = null;
            int n2 = this.a.getRendererCount();
            while (--n2 >= 0) {
                ilvChartRenderer = this.a.getRenderer(n2);
                if (!ilvChartRenderer.isViewable() || !ilvIMapDefinition.mustGenerate(ilvChartRenderer)) continue;
                ilvChartRenderer.addImageMapAreas(ilvIMapDefinition, list);
            }
        }
        int n3 = list.size();
        String[] stringArray = new String[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            stringArray[i2] = ((IlvIMapArea)list.get(i2)).getTag();
        }
        return stringArray;
    }
}

