/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChart3DView;
import ilog.views.chart.IlvChartDataPicker;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvScale;
import ilog.views.chart.servlet.IlvIMapAttributes;
import ilog.views.chart.servlet.IlvIMapDefinition;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvMathUtil;
import ilog.views.chart.view3d.Ilv3DBounds;
import ilog.views.chart.view3d.Ilv3DMatrix;
import ilog.views.chart.view3d.Ilv3DScene;
import ilog.views.chart.view3d.Ilv3DTransform;
import ilog.views.chart.view3d.Ilv3DVector;
import ilog.views.chart.view3d.IlvChart3DArea;
import ilog.views.chart.view3d.IlvChart3DLine;
import ilog.views.chart.view3d.IlvChart3DObject;
import ilog.views.chart.view3d.IlvChart3DSlice;
import ilog.views.chart.view3d.IlvChart3DWalls;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class IlvChart3DScene
extends Ilv3DScene {
    private IlvChart3DView a;
    private IlvChart3DWalls b;
    private Ilv3DBounds c = new Ilv3DBounds(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0);
    private transient boolean d = false;
    private transient boolean e = false;
    private transient int f;
    private static final int g = 3;

    public IlvChart3DScene(IlvChart3DView ilvChart3DView) {
        this.a = ilvChart3DView;
        this.b = new IlvChart3DWalls(this);
    }

    public final IlvChart3DView get3DView() {
        return this.a;
    }

    public void invalidateAll() {
        this.d = false;
        this.e = false;
        this.invalidateTransform();
    }

    protected void updateScene() {
        Serializable serializable;
        if (this.getScreenPort().isEmpty()) {
            this.clearObjects();
            return;
        }
        if (!this.d) {
            if (!this.b()) {
                this.b.update();
            }
            this.clearObjects();
            serializable = this.get3DView().getChart();
            int n2 = ((IlvChart)serializable).getRendererCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                IlvChartRenderer ilvChartRenderer = ((IlvChart)serializable).getRenderer(i2);
                if (!ilvChartRenderer.isViewable()) continue;
                ilvChartRenderer.draw(null);
            }
            this.d = true;
        }
        if (!this.b() && !this.tObjectsValid) {
            serializable = this.getValidatedTransform();
            this.b.applyTransform((Ilv3DTransform)serializable, 1);
        }
        super.updateScene();
    }

    protected void drawContent(Graphics graphics) {
        if (!this.b()) {
            this.b.draw(graphics);
        }
        super.drawContent(graphics);
        IlvChart ilvChart = this.get3DView().getChart();
        int n2 = ilvChart.getRendererCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvChartRenderer ilvChartRenderer = ilvChart.getRenderer(i2);
            if (!ilvChartRenderer.isViewable() || !ilvChartRenderer.has3DSupport()) continue;
            ilvChartRenderer.drawAnnotations(graphics);
        }
    }

    public void setScreenPort(double d2, double d3, double d4, double d5) {
        Rectangle2D rectangle2D = this.getScreenPort();
        if (rectangle2D.getX() == d2 && rectangle2D.getY() == d3 && rectangle2D.getWidth() == d4 && rectangle2D.getHeight() == d5) {
            return;
        }
        super.setScreenPort(d2, d3, d4, d5);
        this.invalidateAll();
    }

    public Rectangle2D getScreenPort() {
        IlvChart ilvChart = this.get3DView().getChart();
        if (ilvChart.isPrinting() || ilvChart.isPaintingImage()) {
            return ilvChart.getProjectorRect();
        }
        return super.getScreenPort();
    }

    Ilv3DBounds a() {
        IlvChart ilvChart = this.get3DView().getChart();
        if (!this.e && ilvChart != null) {
            Rectangle rectangle = ilvChart.getProjectorRect();
            if (this.b()) {
                int n2 = rectangle.x + rectangle.width / 2;
                int n3 = rectangle.y + rectangle.height / 2;
                int n4 = Math.min(rectangle.width, rectangle.height);
                rectangle.setBounds(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
            }
            this.c = new Ilv3DBounds(rectangle.x, rectangle.y, this.a.getBackDepth(), rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, this.a.getFrontDepth());
            this.e = true;
        }
        return this.c;
    }

    public void setProjectionType(int n2) {
        this.f = n2;
        super.setProjectionType(n2);
    }

    protected void updateTransform() {
        if (this.b()) {
            this.getTransform().setProjectionType(0);
        } else {
            this.getTransform().setProjectionType(this.f);
            this.b.update();
        }
        super.updateTransform();
    }

    protected void adjustViewTransform() {
        Ilv3DBounds ilv3DBounds = this.a();
        Ilv3DVector ilv3DVector = ilv3DBounds.getCenter();
        Ilv3DTransform ilv3DTransform = this.getTransform();
        IlvChart3DView ilvChart3DView = this.get3DView();
        ilv3DTransform.setTranslation(-ilv3DVector.x, -ilv3DVector.y, -ilv3DVector.z);
        if (this.b()) {
            ilv3DTransform.setRotation(-ilvChart3DView.getElevation(), 0.0, IlvMathUtil.mod360(ilvChart3DView.getRotation()));
        } else {
            ilv3DTransform.setRotation(ilvChart3DView.getElevation(), ilvChart3DView.getRotation(), 0.0);
        }
        double d2 = (double)ilvChart3DView.getDepth() * ilv3DBounds.getXExtents() / (100.0 * ilv3DBounds.getZExtents());
        ilv3DTransform.setScale(1.0, 1.0, d2);
    }

    protected void adjustScreenTransform() {
        Object object;
        Ilv3DMatrix ilv3DMatrix = new Ilv3DMatrix();
        if (this.getTransform().isUsingPerspective()) {
            this.b.applyTransform(this.getTransform(), 0);
            object = this.b.getBounds(true, null);
            double d2 = ((Ilv3DBounds)object).getZExtents();
            double d3 = d2 * (200.0 / (double)this.getPerspective() - 1.0);
            this.getTransform().setScreenDist(-d3);
            ilv3DMatrix.translate(0.0, 0.0, -d3 - d2 / 2.0);
        } else if (this.get3DView().isAutoScaling() && !this.b()) {
            this.getTransform().setScreenMatrix(ilv3DMatrix);
            this.b.applyTransform(this.getTransform(), 0);
            object = this.b.getBounds(true, null);
            this.transfoValid = true;
            Rectangle2D rectangle2D = this.b(null);
            Rectangle2D rectangle2D2 = IlvGraphicUtil.addToRect(((Ilv3DBounds)object).getXYBounds(null), rectangle2D);
            Rectangle2D rectangle2D3 = (Rectangle2D)this.getScreenPort().clone();
            IlvGraphicUtil.grow(rectangle2D3, -1.0, -1.0);
            ilv3DMatrix = this.a(rectangle2D2, rectangle2D3, !this.getTransform().isOblique(), ilv3DMatrix);
            Ilv3DMatrix ilv3DMatrix2 = null;
            int n2 = this.getTransform().isOblique() ? 50 : 3;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.getTransform().setScreenMatrix(ilv3DMatrix);
                this.b.applyTransform(this.getTransform(), 1);
                object = this.b.getBounds(true, (Ilv3DBounds)object);
                rectangle2D = this.b(rectangle2D);
                rectangle2D2 = IlvGraphicUtil.addToRect(((Ilv3DBounds)object).getXYBounds(rectangle2D2), rectangle2D);
                if (!rectangle2D3.contains(rectangle2D)) {
                    ilv3DMatrix2 = this.a(rectangle2D2, rectangle2D3, !this.getTransform().isOblique(), ilv3DMatrix2);
                    ilv3DMatrix.mult(ilv3DMatrix2, ilv3DMatrix);
                    continue;
                }
                break;
            }
        } else {
            object = this.a();
            Ilv3DVector ilv3DVector = ((Ilv3DBounds)object).getCenter();
            ilv3DMatrix.translate(ilv3DVector.x, ilv3DVector.y, ilv3DVector.z);
        }
        object = new Ilv3DMatrix();
        ((Ilv3DMatrix)object).scale(this.get3DView().getZoom(), this.get3DView().getZoom(), 1.0);
        this.getTransform().setScreenMatrix(ilv3DMatrix.mult((Ilv3DMatrix)object, ilv3DMatrix));
    }

    private static String a(Rectangle2D rectangle2D) {
        return IlvGraphicUtil.toRectangle(rectangle2D, null).toString();
    }

    private Ilv3DMatrix a(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl, Ilv3DMatrix ilv3DMatrix) {
        double d2;
        double d3;
        double d4 = rectangle2D2.getWidth() / rectangle2D.getWidth();
        double d5 = rectangle2D2.getHeight() / rectangle2D.getHeight();
        if (bl) {
            d3 = rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0 - rectangle2D.getX() - rectangle2D.getWidth() / 2.0;
            d2 = rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0 - rectangle2D.getY() - rectangle2D.getHeight() / 2.0;
            if (d4 > d5) {
                d4 = d5;
            } else {
                d5 = d4;
            }
        } else {
            d3 = rectangle2D2.getX() - d4 * rectangle2D.getX();
            d2 = rectangle2D2.getY() - d5 * rectangle2D.getY();
        }
        if (ilv3DMatrix == null) {
            return new Ilv3DMatrix(d4, 0.0, 0.0, d3, 0.0, d5, 0.0, d2, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        }
        return ilv3DMatrix.set(d4, 0.0, 0.0, d3, 0.0, d5, 0.0, d2, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public IlvDisplayPoint getDisplayItem(IlvChartDataPicker ilvChartDataPicker) {
        IlvChart3DObject ilvChart3DObject = null;
        int n2 = this.objects.size();
        while (--n2 >= 0) {
            try {
                ilvChart3DObject = (IlvChart3DObject)this.objects.get(n2);
                if (!ilvChartDataPicker.accept(ilvChart3DObject.getRenderer()) || !ilvChart3DObject.contains(ilvChartDataPicker.getPickX(), ilvChartDataPicker.getPickY())) continue;
                return ilvChart3DObject.getDisplayPoint();
            }
            catch (ClassCastException classCastException) {
            }
        }
        return null;
    }

    public List getImageMapTags(IlvIMapDefinition ilvIMapDefinition) {
        this.updateScene();
        ArrayList arrayList = new ArrayList(this.objects.size());
        IlvChart3DObject ilvChart3DObject = null;
        IlvIMapAttributes ilvIMapAttributes = null;
        int n2 = this.objects.size();
        while (--n2 >= 0) {
            try {
                ilvChart3DObject = (IlvChart3DObject)this.objects.get(n2);
                if (!ilvIMapDefinition.mustGenerate(ilvChart3DObject.getRenderer()) || (ilvIMapAttributes = ilvIMapDefinition.getAttributes(ilvChart3DObject.getDataSetPoint())) == null) continue;
                arrayList.addAll(ilvChart3DObject.getIMapAreas(ilvIMapDefinition, ilvIMapAttributes));
            }
            catch (ClassCastException classCastException) {}
        }
        return arrayList;
    }

    public final IlvChart3DWalls getWalls() {
        return this.b;
    }

    private boolean b() {
        return this.get3DView().getChart().getType() == 3;
    }

    protected Comparator getObjectComparator() {
        if (this.b()) {
            return IlvChart3DSlice.ZComparator.getInstance();
        }
        return ZComparator.getInstance();
    }

    private Rectangle2D b(Rectangle2D rectangle2D) {
        IlvChart ilvChart = this.get3DView().getChart();
        int n2 = ilvChart.getYAxisCount();
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double();
        } else {
            rectangle2D.setRect(0.0, 0.0, 0.0, 0.0);
        }
        Rectangle2D rectangle2D2 = null;
        IlvScale ilvScale = null;
        for (int i2 = -1; i2 < n2; ++i2) {
            ilvScale = i2 == -1 ? ilvChart.getXScale() : ilvChart.getYScale(i2);
            if (ilvScale == null || !ilvScale.isVisible()) continue;
            rectangle2D2 = ilvScale.getBounds(rectangle2D2);
            IlvGraphicUtil.addToRect(rectangle2D, rectangle2D2);
        }
        if (!this.b() && this.b.isZAnnotationVisible()) {
            IlvGraphicUtil.addToRect(rectangle2D, this.b.getZAnnotationBounds());
        }
        return rectangle2D;
    }

    private static class ZComparator
    implements Comparator {
        private static ZComparator a = new ZComparator();

        private ZComparator() {
        }

        public static final Comparator getInstance() {
            return a;
        }

        public int compare(Object object, Object object2) {
            IlvChart3DObject ilvChart3DObject = (IlvChart3DObject)object;
            IlvChart3DObject ilvChart3DObject2 = (IlvChart3DObject)object2;
            Ilv3DVector ilv3DVector = ilvChart3DObject.getCenter(false);
            Ilv3DVector ilv3DVector2 = ilvChart3DObject2.getCenter(false);
            double d2 = ilv3DVector.z - ilv3DVector2.z;
            if (d2 == 0.0) {
                Ilv3DTransform ilv3DTransform = ilvChart3DObject.getScene().getTransform();
                IlvChart ilvChart = ilvChart3DObject.get3DView().getChart();
                d2 = ilvChart.isProjectorReversed() ? (ilv3DVector2.y - ilv3DVector.y) * ilv3DTransform.getXRotation() : (ilv3DVector.x - ilv3DVector2.x) * ilv3DTransform.getYRotation();
                if (d2 == 0.0) {
                    d2 = ilvChart3DObject instanceof IlvChart3DLine && ilvChart3DObject2 instanceof IlvChart3DLine ? ((d2 = ilvChart.isProjectorReversed() ? ilv3DVector.x - ilv3DVector2.x : ilv3DVector2.y - ilv3DVector.y) < 0.0 ? (d2 *= ((IlvChart3DLine)ilvChart3DObject2).getFace((int)0).getNormal((boolean)true).z) : (d2 *= ((IlvChart3DLine)ilvChart3DObject).getFace((int)0).getNormal((boolean)true).z)) : (ilvChart.isProjectorReversed() ? (ilv3DVector.x - ilv3DVector2.x) * ilv3DTransform.getYRotation() : (ilv3DVector2.y - ilv3DVector.y) * ilv3DTransform.getXRotation());
                    if (d2 == 0.0) {
                        d2 = ilvChart3DObject.getCenter((boolean)true).z - ilvChart3DObject2.getCenter((boolean)true).z;
                    }
                }
            }
            return this.a(d2);
        }

        double a(IlvChart3DLine ilvChart3DLine, IlvChart3DLine ilvChart3DLine2) {
            return 0.0;
        }

        int a(IlvChart3DArea ilvChart3DArea, IlvChart3DArea ilvChart3DArea2) {
            Ilv3DTransform ilv3DTransform = ilvChart3DArea.getScene().getTransform();
            IlvChart ilvChart = ilvChart3DArea.get3DView().getChart();
            Ilv3DVector ilv3DVector = ilvChart3DArea.getCenter(false);
            Ilv3DVector ilv3DVector2 = ilvChart3DArea2.getCenter(false);
            if (ilv3DTransform.getPerspective() == 0) {
                double d2 = 0.0;
                d2 = ilvChart.isProjectorReversed() ? (ilv3DVector2.y - ilv3DVector.y) * ilv3DTransform.getXRotation() : (ilv3DVector.x - ilv3DVector2.x) * ilv3DTransform.getYRotation();
                if (d2 != 0.0) {
                    return this.a(d2);
                }
            } else {
                double d3 = 0.0;
                if (ilvChart.isProjectorReversed()) {
                    if (ilv3DTransform.getXRotation() > 0.0) {
                        // empty if block
                    }
                } else {
                    if (ilv3DTransform.getYRotation() >= 0.0) {
                        if (ilvChart3DArea.c().isVisible()) {
                            if (!ilvChart3DArea2.c().isVisible()) {
                                return -1;
                            }
                            d3 = (ilv3DVector2.x - ilv3DVector.x) * ilv3DTransform.getYRotation();
                        } else {
                            if (ilvChart3DArea2.c().isVisible()) {
                                return 1;
                            }
                            d3 = (ilv3DVector.x - ilv3DVector2.x) * ilv3DTransform.getYRotation();
                        }
                    } else if (ilv3DTransform.getYRotation() < 0.0) {
                        if (ilvChart3DArea.b().isVisible()) {
                            if (!ilvChart3DArea2.b().isVisible()) {
                                return -1;
                            }
                            d3 = (ilv3DVector2.x - ilv3DVector.x) * ilv3DTransform.getYRotation();
                        } else {
                            if (ilvChart3DArea2.b().isVisible()) {
                                return 1;
                            }
                            d3 = (ilv3DVector.x - ilv3DVector2.x) * ilv3DTransform.getYRotation();
                        }
                    }
                    if (d3 != 0.0) {
                        return this.a(d3);
                    }
                }
            }
            if ((ilv3DVector = ilvChart3DArea.e().getCenter(false)).equals(ilv3DVector2 = ilvChart3DArea2.f().getCenter(false))) {
                if (ilvChart3DArea.e().isVisible()) {
                    return -1;
                }
                return 1;
            }
            ilv3DVector = ilvChart3DArea.f().getCenter(false);
            if (ilv3DVector.equals(ilv3DVector2 = ilvChart3DArea2.e().getCenter(false))) {
                if (ilvChart3DArea2.e().isVisible()) {
                    return 1;
                }
                return -1;
            }
            return this.a(ilvChart3DArea.getCenter((boolean)true).z - ilvChart3DArea2.getCenter((boolean)true).z);
        }

        final int a(double d2) {
            return d2 > 0.0 ? 1 : (d2 < 0.0 ? -1 : 0);
        }
    }
}

