/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.css;

import ilog.views.util.css.Expression;
import ilog.views.util.css.IlvCSSModel;
import ilog.views.util.styling.IlvCSSFunction;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FormatFunctions
extends IlvCSSFunction {
    public String getName() {
        return "customFormat";
    }

    public String getDelimiters() {
        return ",";
    }

    public boolean returnDelimitersAsToken() {
        return false;
    }

    public Object call(Object[] objectArray, Class clazz, IlvCSSModel ilvCSSModel, Object object, Object object2, Object object3) {
        String string = null;
        int n2 = objectArray.length;
        if (n2 > 1) {
            Object object4 = objectArray[0];
            if (object4 instanceof MessageFormat) {
                Object[] objectArray2 = new Object[n2 - 1];
                for (int i2 = 1; i2 < n2; ++i2) {
                    objectArray2[i2 - 1] = objectArray[i2];
                }
                string = ((MessageFormat)object4).format(objectArray2);
            } else if (object4 instanceof NumberFormat) {
                try {
                    long l2 = Expression.b(objectArray[1]);
                    string = ((NumberFormat)object4).format(l2);
                }
                catch (Exception exception) {
                    double d2 = Expression.a(objectArray[1]);
                    string = ((NumberFormat)object4).format(d2);
                }
            } else if (object4 instanceof DateFormat) {
                Object object5 = objectArray[1];
                string = ((Format)object4).format(object5);
            }
        }
        if (null == string) {
            throw new IllegalArgumentException("bad argument \"" + objectArray[0] + "\"");
        }
        return string;
    }

    public static class MessageFormatFunction
    extends FormatFunctions {
        public Object call(Object[] objectArray, Class clazz, IlvCSSModel ilvCSSModel, Object object, Object object2, Object object3) {
            if (objectArray.length == 0) {
                throw new IllegalArgumentException("no parameter");
            }
            Object[] objectArray2 = new Object[objectArray.length - 1];
            System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
            return MessageFormat.format(objectArray[0].toString(), objectArray2);
        }

        public String getName() {
            return "messageFormat";
        }
    }

    public static class DecimalFormatFunction
    extends FormatFunctions {
        public Object call(Object[] objectArray, Class clazz, IlvCSSModel ilvCSSModel, Object object, Object object2, Object object3) {
            if (objectArray.length != 2) {
                throw new IllegalArgumentException("2 parameters expected in function");
            }
            DecimalFormat decimalFormat = new DecimalFormat(objectArray[0].toString());
            if (objectArray[1] instanceof Number) {
                return decimalFormat.format(objectArray[1]);
            }
            try {
                return decimalFormat.format(Long.parseLong(objectArray[1].toString()));
            }
            catch (Exception exception) {
                return decimalFormat.format(Double.parseDouble(objectArray[1].toString()));
            }
        }

        public String getName() {
            return "decimalFormat";
        }
    }

    public static class SimpleDateFormatFunction
    extends FormatFunctions {
        public Object call(Object[] objectArray, Class clazz, IlvCSSModel ilvCSSModel, Object object, Object object2, Object object3) {
            String string = null;
            if (objectArray.length == 2) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(objectArray[0].toString());
                if (simpleDateFormat != null) {
                    string = simpleDateFormat.format((Date)objectArray[1]);
                }
            } else {
                throw new IllegalArgumentException("syntax: \"@|simpleDateFormat(<pattern>,<java.util.Date>);\" expected");
            }
            return string;
        }

        public String getName() {
            return "simpleDateFormat";
        }
    }
}

