/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.calendar.plaf;

import ilog.views.util.swing.calendar.IlvCalendarModel;
import ilog.views.util.swing.calendar.IlvJTimeChooser;
import ilog.views.util.swing.calendar.event.CalendarModelEvent;
import ilog.views.util.swing.calendar.event.CalendarModelListener;
import ilog.views.util.swing.calendar.plaf.TimeChooserUI;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;

public class BasicTimeChooserUI
extends TimeChooserUI {
    protected IlvJTimeChooser timeChooser;
    protected JTextField timeText;
    protected PropertyChangeListener propertyChangeListener;
    protected CalendarModelListener modelListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTimeChooserUI();
    }

    public void installUI(JComponent jComponent) {
        this.timeChooser = (IlvJTimeChooser)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.timeChooser = null;
    }

    protected void installComponents() {
        this.timeChooser.setLayout(new FlowLayout());
        Color color = this.timeChooser.getBackground();
        this.timeText = new TimeTextField(this.timeChooser);
        this.timeText.setBackground(color);
        this.timeText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = BasicTimeChooserUI.this.timeText.getText();
                Date date = null;
                try {
                    date = BasicTimeChooserUI.this.timeChooser.getTimeFormat().parse(string);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                Calendar calendar = BasicTimeChooserUI.this.timeChooser.getCalendar();
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTime(date);
                calendar.set(11, calendar2.get(11));
                calendar.set(12, calendar2.get(12));
                calendar.set(13, calendar2.get(13));
                calendar.set(14, calendar2.get(14));
                BasicTimeChooserUI.this.timeChooser.setCalendar(calendar);
            }
        });
        this.timeChooser.add(this.timeText);
    }

    protected void uninstallComponents() {
        this.timeChooser.remove(this.timeText);
    }

    protected void installDefaults() {
        this.timeChooser.setOpaque(true);
        LookAndFeel.installColorsAndFont(this.timeChooser, "TimeChooser.background", "TimeChooser.foreground", "TimeChooser.font");
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.modelListener = this.createCalendarModelListener();
        this.timeChooser.addPropertyChangeListener(this.propertyChangeListener);
        IlvCalendarModel ilvCalendarModel = this.timeChooser.getModel();
        if (ilvCalendarModel != null) {
            ilvCalendarModel.addCalendarModelListener(this.modelListener);
        }
    }

    protected void uninstallListeners() {
        this.timeChooser.removePropertyChangeListener(this.propertyChangeListener);
        IlvCalendarModel ilvCalendarModel = this.timeChooser.getModel();
        if (ilvCalendarModel != null) {
            ilvCalendarModel.removeCalendarModelListener(this.modelListener);
        }
        this.propertyChangeListener = null;
        this.modelListener = null;
    }

    protected CalendarModelListener createCalendarModelListener() {
        return new CalendarModelHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void repaintTime() {
        Date date = this.timeChooser.getCalendar().getTime();
        String string = this.timeChooser.getTimeFormat().format(date);
        this.timeText.setText(string);
    }

    static class TimeTextField
    extends JTextField {
        private IlvJTimeChooser a;

        TimeTextField(IlvJTimeChooser ilvJTimeChooser) {
            this.a = ilvJTimeChooser;
            this.updateUI();
            this.setColumns(15);
            this.setHorizontalAlignment(0);
        }

        public void updateUI() {
            if (this.a == null) {
                return;
            }
            super.updateUI();
            this.setFont(this.a.getFont());
            this.setForeground(this.a.getForeground());
            this.setBackground(this.a.getBackground());
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                IlvCalendarModel ilvCalendarModel = (IlvCalendarModel)propertyChangeEvent.getOldValue();
                IlvCalendarModel ilvCalendarModel2 = (IlvCalendarModel)propertyChangeEvent.getNewValue();
                if (ilvCalendarModel != null) {
                    ilvCalendarModel.removeCalendarModelListener(BasicTimeChooserUI.this.modelListener);
                }
                if (ilvCalendarModel2 != null) {
                    ilvCalendarModel2.addCalendarModelListener(BasicTimeChooserUI.this.modelListener);
                }
                BasicTimeChooserUI.this.timeChooser.repaint();
            } else if (string.equals("timeFormat")) {
                BasicTimeChooserUI.this.repaintTime();
            } else if (string.equals("font")) {
                BasicTimeChooserUI.this.timeText.setFont(BasicTimeChooserUI.this.timeChooser.getFont());
            } else if (string.equals("foreground")) {
                BasicTimeChooserUI.this.timeText.setForeground(BasicTimeChooserUI.this.timeChooser.getForeground());
            } else if (string.equals("background")) {
                BasicTimeChooserUI.this.timeText.setBackground(BasicTimeChooserUI.this.timeChooser.getBackground());
            }
        }
    }

    public class CalendarModelHandler
    implements CalendarModelListener {
        public void calendarChanged(CalendarModelEvent calendarModelEvent) {
            if (!calendarModelEvent.getOldCalendar().equals(calendarModelEvent.getNewCalendar())) {
                BasicTimeChooserUI.this.repaintTime();
            }
        }
    }
}

