/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle;

import hk.com.realink.chart.dto.minChart.access.AccessStockMinChart;
import hk.com.realink.chart.dto.minChart.access.StockMinChartMessage;
import hk.com.realink.histnews.history.HistRaw;
import hk.com.realink.histnews.typeimple.HistRecordReq;
import hk.com.realink.histnews.typeimple.HistRecordRes;
import hk.com.realink.login.Message;
import hk.com.realink.socketagent.AgentMessage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import leaseLineQuote.candle.CandleNewFrame;
import leaseLineQuote.candle.control.HKIndexCode;
import leaseLineQuote.candle.datasource.histrecord.HistRecordReader;
import leaseLineQuote.candle.graph.ControlInterface;
import leaseLineQuote.candle.graph.FutureSelectedListener;
import leaseLineQuote.candle.testpart.InputBoxFrm;
import leaseLineQuote.candle.testpart.LoginAgentHandler;

public class MainTest {
    private static MainTest mainTest = null;

    private MainTest() {
        final LoginAgentHandler loginAgentHandler = LoginAgentHandler.getInstance();
        loginAgentHandler.connect("128.0.0.108", 9000, "", 2);
        CandleNewFrame candleFrame = CandleNewFrame.getInstance();
        final ControlInterface cnf = candleFrame.getControlInterface();
        loginAgentHandler.setDataReceiveListence(new LoginAgentHandler.DataReceiveListener(){

            @Override
            public void receive(Message msg) {
                HistRecordRes h2 = (HistRecordRes)msg.details;
                System.out.println(" ************************** ");
                System.out.println("MainTest -- receive()");
                HistRaw[] hr = h2.getHistRaws();
                if (hr != null) {
                    System.out.println(hr.length);
                }
                cnf.updateHistRecordRes((HistRecordRes)msg.details);
            }

            @Override
            public void receiveAgentMessage(Message msg) {
                AgentMessage agentMessage = (AgentMessage)msg.details;
                if (agentMessage.getContent() instanceof StockMinChartMessage) {
                    StockMinChartMessage smcm = (StockMinChartMessage)agentMessage.getContent();
                    for (Object obj : smcm.getAccessModeList()) {
                        AccessStockMinChart asmc = (AccessStockMinChart)obj;
                        System.out.println(" ************************** ");
                        System.out.println("MainTest -- receiveAgentMessage() " + asmc.getStockCode() + " " + asmc.getPeriod());
                        HistRaw[] raw = asmc.getHistRecordRes().getHistRaws();
                        if (raw != null) {
                            System.out.println(raw.length);
                        }
                        if (asmc.getDate() > 0L) {
                            System.out.println("asmc.getDate()>0:" + asmc.getDate());
                            cnf.updateHistRecordRes(asmc.getHistRecordRes());
                            continue;
                        }
                        cnf.updateHistRecordRes(asmc.getHistRecordRes());
                    }
                }
            }
        });
        cnf.addHistRecordReaderListener(new HistRecordReader.RequestListener(){

            @Override
            public boolean request(String symbol, int monthPeriodIdx, boolean isInterDay) {
                System.out.println("MainTest -- cnf request(" + symbol + "," + monthPeriodIdx + "," + isInterDay + ")");
                if (!HKIndexCode.isCode(symbol)) {
                    try {
                        int code = Integer.parseInt(symbol);
                        if (code <= 0 || code > 99999) {
                            System.out.println("MainTest -- code <= 0 || code > 99999");
                            return false;
                        }
                    }
                    catch (Exception code) {
                        // empty catch block
                    }
                }
                System.out.println("MainTest -- request() code in range");
                try {
                    HistRecordReq historyReq = new HistRecordReq();
                    if (isInterDay) {
                        historyReq.reqCompanyHistory(symbol, (byte)monthPeriodIdx);
                        historyReq.setAccessMode(4);
                        loginAgentHandler.send(historyReq);
                    } else {
                        historyReq.reqCompanyHistory(symbol);
                        loginAgentHandler.send(historyReq);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("MainTest -- END request()");
                return true;
            }

            @Override
            public boolean requestAgentMessage(String symbol, int period, int monthIndex, long date) {
                System.out.println("MainTest -- requestAgentMessage(" + symbol + "," + period + "," + monthIndex + "," + date + ")");
                if (!HKIndexCode.isCode(symbol)) {
                    try {
                        int code = Integer.parseInt(symbol);
                        if (code <= 0 || code > 99999) {
                            return false;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    loginAgentHandler.reqMessage(symbol, period, monthIndex, date);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
        });
        cnf.addFutureSelectedListener(new FutureSelectedListener(){

            @Override
            public void futureSelected(String symbol, int monthPeriodIdx) {
                System.out.println("MainTest -- MainTest() futureSelected(" + symbol + "," + monthPeriodIdx + ")");
                cnf.loadQuote(symbol, monthPeriodIdx, 3, 1);
            }
        });
        candleFrame.setUpdateTime(60000L, 15000L);
        candleFrame.setAutoRefresh(true);
        candleFrame.getStyledFrame().setLocation(0, 30);
        candleFrame.getStyledFrame().setSize(1024, 768);
        candleFrame.setFutureMinChartVisible(true);
        candleFrame.setStockMinChartVisible(true);
        candleFrame.setChinese();
        candleFrame.getStyledFrame().setVisible(true);
    }

    public static MainTest getIntance() {
        if (mainTest == null) {
            mainTest = new MainTest();
        }
        return mainTest;
    }

    public static void main(String[] args) {
        MainTest mainTest = MainTest.getIntance();
        mainTest.showJFrame();
    }

    private void showStyledFrame() {
        JFrame topFrame = new JFrame("Realink Candle Chart v0.1b");
        JDesktopPane desktop = new JDesktopPane();
        desktop.setDragMode(0);
        topFrame.setResizable(false);
        topFrame.setContentPane(desktop);
        topFrame.setDefaultCloseOperation(3);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int insetx = 125;
        int insety = 97;
        topFrame.setBounds(insetx, insety, screenSize.width - insetx * 2, screenSize.height - insety * 2);
        topFrame.setVisible(true);
        InputBoxFrm inputBox = new InputBoxFrm();
        inputBox.setLocation(0, 0);
        inputBox.setSize(1024, 30);
        desktop.add((Component)((Object)inputBox));
        desktop.add((Component)CandleNewFrame.getInstance().getStyledFrame());
    }

    private void showJFrame() {
        JFrame candleFrame = CandleNewFrame.getInstance().getJFrame();
        candleFrame.setSize(1024, 768);
        candleFrame.setVisible(true);
        CandleNewFrame.getInstance().request("1");
    }
}

