/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.cfgpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import leaseLineQuote.StyledFont;
import leaseLineQuote.candle.cfgpanel.CandleConfigFrame;
import leaseLineQuote.candle.cfgpanel.CfgPanel;
import leaseLineQuote.candle.cfgpanel.HiLoCfgPanel;
import leaseLineQuote.candle.cfgpanel.LowerCfgPanel;
import leaseLineQuote.candle.cfgpanel.MaCfgPanel;
import leaseLineQuote.candle.cfgpanel.MacdCfgPanel;
import leaseLineQuote.candle.cfgpanel.RsiCfgPanel;
import leaseLineQuote.candle.cfgpanel.SICfgPanel;
import leaseLineQuote.candle.cfgpanel.VolCfgPanel;
import leaseLineQuote.candle.cfgpanel.WrCfgPanel;
import leaseLineQuote.candle.graph.core.CandlePanel;

public class CandleConfigPanel
extends JPanel {
    private CandleConfigFrame parentFrame;
    private JTabbedPane jtb = new JTabbedPane();
    private JPanel controlPanel = new JPanel();
    private JButton cmdConfirm = new JButton("Confirm");
    private JButton cmdCancel = new JButton("Cancel");
    private MaCfgPanel ma;
    private RsiCfgPanel rsi;
    private HiLoCfgPanel hilo;
    private MacdCfgPanel macd;
    private LowerCfgPanel lower;
    private VolCfgPanel vol;
    private WrCfgPanel wr;
    private SICfgPanel si;
    private static CandleConfigPanel candleCfgPanel;
    private CandlePanel candlePanel;

    private CandleConfigPanel(CandleConfigFrame papa) {
        this.parentFrame = papa;
        this.jbInit();
    }

    public static CandleConfigPanel getInstance(CandleConfigFrame papa) {
        if (candleCfgPanel == null) {
            candleCfgPanel = new CandleConfigPanel(papa);
        }
        return candleCfgPanel;
    }

    public static CandleConfigPanel getInstance() {
        return candleCfgPanel;
    }

    public CfgPanel[] getCfgPanel() {
        CfgPanel[] cfgPanels = new CfgPanel[]{this.rsi, this.macd, this.vol, this.wr, this.si};
        return cfgPanels;
    }

    public void updateSetting() {
        CandlePanel ctrInf = this.candlePanel = CandlePanel.getInstance();
        ctrInf.setYPanAllowed(true);
        this.vol.loadSetting();
        this.rsi.loadSetting();
        this.macd.loadSetting();
        this.ma.loadSetting();
        this.wr.loadSetting();
        this.si.loadSetting();
        this.hilo.loadSetting();
    }

    public void setChinese() {
        this.rsi.setChinese();
        this.ma.setChinese();
        this.hilo.setChinese();
        this.macd.setChinese();
        this.lower.setChinese();
        this.vol.setChinese();
        this.wr.setChinese();
        this.si.setChinese();
        this.cmdConfirm.setText("\u78ba\u5b9a");
        this.cmdConfirm.setFont(StyledFont.PLAIN_CHINESE);
        this.cmdCancel.setText("\u53d6\u6d88");
        this.cmdCancel.setFont(StyledFont.PLAIN_CHINESE);
        this.jtb.setTitleAt(0, "\u4e3b\u5716\u5206\u6790\u7dda");
        this.jtb.setTitleAt(1, "\u526f\u5716\u5206\u6790\u7dda");
        this.jtb.setTitleAt(2, "\u9670\u967d\u71ed\u5716");
        this.jtb.setTitleAt(3, "RSI");
        this.jtb.setTitleAt(4, "MACD");
        this.jtb.setTitleAt(5, "\u5a01\u5ec9\u6307\u6a19");
        this.jtb.setTitleAt(6, "\u96a8\u6a5fKD\u6307\u6a19");
        this.jtb.setFont(StyledFont.PLAIN_CHINESE);
    }

    public void setEnglish() {
        this.rsi.setEnglish();
        this.ma.setEnglish();
        this.hilo.setEnglish();
        this.macd.setEnglish();
        this.lower.setEnglish();
        this.vol.setEnglish();
        this.wr.setEnglish();
        this.si.setEnglish();
        this.cmdConfirm.setText("Confirm");
        this.cmdConfirm.setFont(StyledFont.PLAINFONT);
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.setFont(StyledFont.PLAINFONT);
        this.jtb.setTitleAt(0, "Main Charts");
        this.jtb.setTitleAt(1, "Auxiliary Charts");
        this.jtb.setTitleAt(2, "Candle Stick");
        this.jtb.setTitleAt(3, "RSI");
        this.jtb.setTitleAt(4, "MACD");
        this.jtb.setTitleAt(5, "Williams'%R");
        this.jtb.setTitleAt(6, "Stochastics KD");
        this.jtb.setFont(StyledFont.PLAINFONT);
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.ma = MaCfgPanel.getInstance(this.parentFrame);
        this.hilo = HiLoCfgPanel.getInstance(this.parentFrame);
        this.rsi = RsiCfgPanel.getInstance(this.parentFrame);
        this.macd = MacdCfgPanel.getInstance(this.parentFrame);
        this.lower = LowerCfgPanel.getInstance(this.parentFrame);
        this.vol = VolCfgPanel.getInstance(this.parentFrame);
        this.wr = WrCfgPanel.getInstance(this.parentFrame);
        this.si = SICfgPanel.getInstance(this.parentFrame);
        this.jtb.add((Component)this.ma, "Main Charts");
        this.jtb.add((Component)this.lower, "Auxiliary Charts");
        this.jtb.add((Component)this.hilo, "Candle Stick");
        this.jtb.add((Component)this.rsi, "RSI");
        this.jtb.add((Component)this.macd, "MACD");
        this.jtb.add((Component)this.wr, "WR");
        this.jtb.add((Component)this.si, "KD");
        this.add((Component)this.jtb, "Center");
        this.add((Component)this.controlPanel, "South");
        this.controlPanel.add(this.cmdConfirm);
        this.controlPanel.add(this.cmdCancel);
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CandleConfigPanel.this.processCancel();
            }
        });
        this.cmdConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CandleConfigPanel.this.processConfirm();
            }
        });
    }

    private void processCancel() {
        this.parentFrame.dispose();
    }

    private void processConfirm() {
        try {
            this.processCancel();
            this.ma.processConfirm();
            this.lower.processConfirm();
            this.hilo.processConfirm();
            this.candlePanel.xRangeChanged(false);
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
    }
}

