/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.cfgpanel;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import leaseLineQuote.UserProfile;
import leaseLineQuote.candle.CandleNewFrame;
import leaseLineQuote.candle.cfgpanel.CandleConfigFrame;
import leaseLineQuote.candle.cfgpanel.UpperLineCfg;
import leaseLineQuote.candle.graph.ControlInterface;

public class MaCfgPanel
extends JPanel {
    private LineProc lcfgSMA_1;
    private LineProc lcfgSMA_2;
    private LineProc lcfgSMA_3;
    private LineProc lcfgEMA_1;
    private LineProc lcfgEMA_2;
    private LineProc lcfgEMA_3;
    private LineProc lcfgBB;
    private LineProc lcfgPC;
    private static MaCfgPanel maCfgPanel;
    private CandleConfigFrame parentFrame;

    private MaCfgPanel(CandleConfigFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.createPanel();
    }

    public static MaCfgPanel getInstance(CandleConfigFrame parentFrame) {
        if (maCfgPanel == null) {
            maCfgPanel = new MaCfgPanel(parentFrame);
        }
        return maCfgPanel;
    }

    public void createPanel() {
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.lcfgSMA_1 = new LineProc("SMA", 0, new float[]{10.0f}, Color.RED.darker(), 10, this.parentFrame, true);
        this.lcfgSMA_1.add(this);
        this.lcfgSMA_2 = new LineProc("SMA", 1, new float[]{20.0f}, Color.GREEN.darker(), 38, this.parentFrame, true);
        this.lcfgSMA_2.add(this);
        this.lcfgSMA_3 = new LineProc("SMA", 2, new float[]{50.0f}, Color.BLUE.darker(), 66, this.parentFrame, true);
        this.lcfgSMA_3.add(this);
        this.lcfgEMA_1 = new LineProc("EMA", 0, new float[]{10.0f}, Color.RED, 94, this.parentFrame, false);
        this.lcfgEMA_1.add(this);
        this.lcfgEMA_2 = new LineProc("EMA", 1, new float[]{20.0f}, Color.GREEN.darker(), 122, this.parentFrame, false);
        this.lcfgEMA_2.add(this);
        this.lcfgEMA_3 = new LineProc("EMA", 2, new float[]{50.0f}, Color.BLUE, 150, this.parentFrame, false);
        this.lcfgEMA_3.add(this);
        this.lcfgBB = new LineProc("BB", 0, new float[]{20.0f, 2.0f}, Color.CYAN.darker(), 178, this.parentFrame, false);
        this.lcfgBB.add(this);
        this.lcfgPC = new LineProc("PC", 0, new float[]{20.0f}, Color.GREEN.darker(), 234, this.parentFrame, false);
        this.lcfgPC.add(this);
    }

    public void setChinese() {
        this.lcfgSMA_1.setChinese("\u79fb\u52d5\u5e73\u5747\u7dda 1\uff1a");
        this.lcfgSMA_2.setChinese("\u79fb\u52d5\u5e73\u5747\u7dda 2\uff1a");
        this.lcfgSMA_3.setChinese("\u79fb\u52d5\u5e73\u5747\u7dda 3\uff1a");
        this.lcfgEMA_1.setChinese("\u6307\u6578\u79fb\u52d5\u5e73\u5747\u7dda 1\uff1a");
        this.lcfgEMA_2.setChinese("\u6307\u6578\u79fb\u52d5\u5e73\u5747\u7dda 2\uff1a");
        this.lcfgEMA_3.setChinese("\u6307\u6578\u79fb\u52d5\u5e73\u5747\u7dda 3\uff1a");
        this.lcfgBB.setChinese("\u4fdd\u6b77\u52a0\u901a\u9053\uff1a");
        this.lcfgPC.setChinese("\u50f9\u683c\u901a\u9053\uff1a");
    }

    public void setEnglish() {
        this.lcfgSMA_1.setEnglish("SMA 1:");
        this.lcfgSMA_2.setEnglish("SMA 2:");
        this.lcfgSMA_3.setEnglish("SMA 3:");
        this.lcfgEMA_1.setEnglish("EMA 1:");
        this.lcfgEMA_2.setEnglish("EMA 2:");
        this.lcfgEMA_3.setEnglish("EMA 3:");
        this.lcfgBB.setEnglish("Bollinger Bands:");
        this.lcfgPC.setEnglish("Price Channel:");
    }

    public void processConfirm() {
        this.lcfgSMA_1.processConfirm();
        this.lcfgSMA_2.processConfirm();
        this.lcfgSMA_3.processConfirm();
        this.lcfgEMA_1.processConfirm();
        this.lcfgEMA_2.processConfirm();
        this.lcfgEMA_3.processConfirm();
        this.lcfgBB.processConfirm();
        this.lcfgPC.processConfirm();
    }

    public void loadSetting() {
        this.lcfgSMA_1.loadSetting();
        this.lcfgSMA_2.loadSetting();
        this.lcfgSMA_3.loadSetting();
        this.lcfgEMA_1.loadSetting();
        this.lcfgEMA_2.loadSetting();
        this.lcfgEMA_3.loadSetting();
        this.lcfgBB.loadSetting();
        this.lcfgPC.loadSetting();
    }

    class LineProc
    extends UpperLineCfg {
        public LineProc(String type, int idx, float[] typeVals, Color color, int y, JFrame parentFrame, boolean selected) {
            super(type, idx, typeVals, color, y, parentFrame);
            this.chk.setSelected(selected);
        }

        public void processConfirm() {
            this.processSetting();
            this.storeSetting();
        }

        private void processSetting() {
            ControlInterface ctrInf = CandleNewFrame.getControlInterface();
            if (this.isEnable != this.chk.isSelected()) {
                if (this.chk.isSelected()) {
                    ctrInf.createUpperIndicators(this.type, this.idx, this.color, this.typeVals);
                } else {
                    ctrInf.removeUpperIndicators(this.type, this.idx);
                }
                this.isEnable = this.chk.isSelected();
            } else if (this.chk.isSelected()) {
                this.color = this.btnColor.getBackground();
                try {
                    for (int i2 = 0; i2 < this.inputs.length; ++i2) {
                        this.typeVals[i2] = Float.parseFloat(this.inputs[i2].getText());
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    for (int i3 = 0; i3 < this.inputs.length; ++i3) {
                        this.typeVals[i3] = 10.0f;
                    }
                }
                ctrInf.setUpperIndicatorsColor(this.type, this.idx, new Color[]{this.color});
                ctrInf.setUpperIndicatorsCfg(this.type, this.idx, this.typeVals);
            }
        }

        private void storeSetting() {
            UserProfile.put((Object)("MaCfgPanel:" + this.type + ":" + this.idx + ":typeVal"), (Object)this.typeVals);
            UserProfile.put((Object)("MaCfgPanel:" + this.type + ":" + this.idx + ":color"), (Object)this.color);
            UserProfile.put((Object)("MaCfgPanel:" + this.type + ":" + this.idx + ":isSelected"), (Object)new Boolean(this.chk.isSelected()));
        }

        public void loadSetting() {
            float[] vals = null;
            try {
                Object data = UserProfile.get((Object)("MaCfgPanel:" + this.type + ":" + this.idx + ":typeVal"));
                if (data instanceof float[]) {
                    vals = (float[])data;
                } else if (data instanceof Integer) {
                    vals = new float[]{((Integer)data).floatValue()};
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            Color color = (Color)UserProfile.get((Object)("MaCfgPanel:" + this.type + ":" + this.idx + ":color"));
            Boolean chkSelected = (Boolean)UserProfile.get((Object)("MaCfgPanel:" + this.type + ":" + this.idx + ":isSelected"));
            if (vals != null && color != null && chkSelected != null) {
                for (int i2 = 0; i2 < this.inputs.length && i2 < vals.length; ++i2) {
                    this.inputs[i2].setText("" + vals[i2]);
                }
                this.btnColor.setBackground(color);
                this.chk.setSelected(chkSelected);
            }
            this.processSetting();
        }
    }
}

