/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.cfgpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import leaseLineQuote.ColorButton;
import leaseLineQuote.IntegerTextField;
import leaseLineQuote.StyledFont;
import leaseLineQuote.UserProfile;
import leaseLineQuote.candle.CandleNewFrame;
import leaseLineQuote.candle.cfgpanel.CandleConfigFrame;
import leaseLineQuote.candle.cfgpanel.CfgPanel;
import leaseLineQuote.candle.graph.ControlInterface;

public class MacdCfgPanel
extends JPanel
implements CfgPanel {
    public int valMacdFast = 12;
    public int valMacdSlow = 26;
    public int valMacdSignal = 9;
    public IntegerTextField macdInputFast;
    public IntegerTextField macdInputSlow;
    public IntegerTextField macdInputSignal;
    public JLabel lblMacdFast;
    public JLabel lblMacdSlow;
    public JLabel lblMacdSignal;
    public JLabel lblMacdDiv;
    public ColorButton colorMacdFastSlow;
    public ColorButton colorMacdSignal;
    public ColorButton colorMacdDiv;
    public Color valColorFastSlow;
    public Color valColorSignal;
    public Color valColorDiv;
    private JLabel lblColorFastSlow;
    private JLabel lblColorSignal;
    private JLabel lblColorDiv;
    private CandleConfigFrame parentFrame;
    private static MacdCfgPanel macdPanel;
    private ControlInterface ctrInf;
    private int chartIdx = 2;
    private boolean isStartup = true;

    private MacdCfgPanel(CandleConfigFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.createPanel();
    }

    @Override
    public String getKey() {
        return "MACD";
    }

    public static MacdCfgPanel getInstance(CandleConfigFrame parentFrame) {
        if (macdPanel == null) {
            macdPanel = new MacdCfgPanel(parentFrame);
        }
        return macdPanel;
    }

    public void setChinese() {
        this.lblMacdFast.setText("\u5feb\u7dda\uff1a");
        this.lblMacdFast.setFont(StyledFont.PLAIN_CHINESE);
        this.lblMacdSlow.setText("\u6162\u7dda\uff1a");
        this.lblMacdSlow.setFont(StyledFont.PLAIN_CHINESE);
        this.lblMacdSignal.setText("\u4fe1\u865f\u7dda\uff1a");
        this.lblMacdSignal.setFont(StyledFont.PLAIN_CHINESE);
        this.lblMacdDiv.setText("\u5dee\u8ddd\uff1a");
        this.lblMacdDiv.setFont(StyledFont.PLAIN_CHINESE);
        this.lblColorFastSlow.setText("\u8272\u5f69\uff1a");
        this.lblColorFastSlow.setFont(StyledFont.PLAIN_CHINESE);
        this.lblColorSignal.setText("\u8272\u5f69\uff1a");
        this.lblColorSignal.setFont(StyledFont.PLAIN_CHINESE);
        this.lblColorDiv.setText("\u8272\u5f69\uff1a");
        this.lblColorDiv.setFont(StyledFont.PLAIN_CHINESE);
    }

    public void setEnglish() {
        this.lblMacdFast.setText("Fast: ");
        this.lblMacdFast.setFont(StyledFont.PLAINFONT);
        this.lblMacdSlow.setText("Slow: ");
        this.lblMacdSlow.setFont(StyledFont.PLAINFONT);
        this.lblMacdSignal.setText("Signal: ");
        this.lblMacdSignal.setFont(StyledFont.PLAINFONT);
        this.lblMacdDiv.setText("Diff: ");
        this.lblMacdDiv.setFont(StyledFont.PLAINFONT);
        this.lblColorFastSlow.setText("Color: ");
        this.lblColorFastSlow.setFont(StyledFont.PLAINFONT);
        this.lblColorSignal.setText("Color: ");
        this.lblColorSignal.setFont(StyledFont.PLAINFONT);
        this.lblColorDiv.setText("Color: ");
        this.lblColorDiv.setFont(StyledFont.PLAINFONT);
    }

    private void createPanel() {
        this.lblMacdFast = new JLabel("Fast: ");
        this.lblMacdFast.setBounds(new Rectangle(5, 10, 100, 16));
        this.lblMacdFast.setForeground(Color.black);
        this.lblMacdFast.setFont(StyledFont.PLAINFONT);
        this.lblMacdSlow = new JLabel("Slow: ");
        this.lblMacdSlow.setBounds(new Rectangle(5, 38, 100, 16));
        this.lblMacdSlow.setForeground(Color.black);
        this.lblMacdSlow.setFont(StyledFont.PLAINFONT);
        this.lblMacdSignal = new JLabel("Signal: ");
        this.lblMacdSignal.setBounds(new Rectangle(5, 66, 100, 16));
        this.lblMacdSignal.setForeground(Color.black);
        this.lblMacdSignal.setFont(StyledFont.PLAINFONT);
        this.lblMacdDiv = new JLabel("Diff: ");
        this.lblMacdDiv.setBounds(new Rectangle(5, 94, 100, 16));
        this.lblMacdDiv.setForeground(Color.black);
        this.lblMacdDiv.setFont(StyledFont.PLAINFONT);
        this.macdInputFast = new IntegerTextField(3);
        this.macdInputFast.setBounds(new Rectangle(110, 7, 33, 23));
        this.macdInputFast.setText("12");
        this.macdInputSlow = new IntegerTextField(3);
        this.macdInputSlow.setBounds(new Rectangle(110, 35, 33, 23));
        this.macdInputSlow.setText("26");
        this.macdInputSignal = new IntegerTextField(3);
        this.macdInputSignal.setBounds(new Rectangle(110, 63, 33, 23));
        this.macdInputSignal.setText("9");
        this.lblColorFastSlow = new JLabel("Color: ");
        this.lblColorFastSlow.setBounds(new Rectangle(165, 10, 50, 16));
        this.lblColorFastSlow.setForeground(Color.black);
        this.lblColorFastSlow.setFont(StyledFont.PLAINFONT);
        this.lblColorSignal = new JLabel("Color: ");
        this.lblColorSignal.setBounds(new Rectangle(165, 66, 50, 16));
        this.lblColorSignal.setForeground(Color.black);
        this.lblColorSignal.setFont(StyledFont.PLAINFONT);
        this.lblColorDiv = new JLabel("Color: ");
        this.lblColorDiv.setBounds(new Rectangle(165, 94, 50, 16));
        this.lblColorDiv.setForeground(Color.black);
        this.lblColorDiv.setFont(StyledFont.PLAINFONT);
        this.valColorFastSlow = Color.RED.darker();
        this.valColorSignal = Color.GREEN.darker();
        this.valColorDiv = Color.BLUE.darker();
        this.colorMacdFastSlow = new ColorButton(this.valColorFastSlow, (JFrame)this.parentFrame);
        this.colorMacdFastSlow.setBounds(new Rectangle(215, 13, 10, 10));
        this.colorMacdSignal = new ColorButton(this.valColorSignal, (JFrame)this.parentFrame);
        this.colorMacdSignal.setBounds(new Rectangle(215, 69, 10, 10));
        this.colorMacdDiv = new ColorButton(this.valColorDiv, (JFrame)this.parentFrame);
        this.colorMacdDiv.setBounds(new Rectangle(215, 97, 10, 10));
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.lblMacdFast, null);
        this.add((Component)this.macdInputFast, null);
        this.add((Component)this.lblColorFastSlow, null);
        this.add((Component)this.colorMacdFastSlow, null);
        this.add((Component)this.lblMacdSlow, null);
        this.add((Component)this.macdInputSlow, null);
        this.add((Component)this.lblColorSignal, null);
        this.add((Component)this.colorMacdSignal, null);
        this.add((Component)this.lblMacdSignal, null);
        this.add((Component)this.macdInputSignal, null);
        this.add((Component)this.lblColorDiv, null);
        this.add((Component)this.lblMacdDiv, null);
        this.add((Component)this.colorMacdDiv, null);
    }

    @Override
    public void unshowLines() {
        this.ctrInf = CandleNewFrame.getControlInterface();
        this.ctrInf.removeLowerIndicators(this.chartIdx, "MACD", 0);
    }

    @Override
    public void showLines(int chartIdx) {
        this.ctrInf = CandleNewFrame.getControlInterface();
        this.chartIdx = chartIdx;
        this.ctrInf.createLowerIndicators(chartIdx, "MACD", 0, new Color[]{this.valColorFastSlow, this.valColorSignal, this.valColorDiv}, new int[]{this.valMacdFast, this.valMacdSlow, this.valMacdSignal});
    }

    @Override
    public void processConfirm() {
        this.processSetting();
        this.storeSetting();
    }

    private void processSetting() {
        this.ctrInf = CandleNewFrame.getControlInterface();
        this.valColorFastSlow = this.colorMacdFastSlow.getBackground();
        this.valColorSignal = this.colorMacdSignal.getBackground();
        this.valColorDiv = this.colorMacdDiv.getBackground();
        try {
            this.valMacdFast = Integer.parseInt(this.macdInputFast.getText());
        }
        catch (Exception e2) {
            this.valMacdFast = 12;
        }
        try {
            this.valMacdSlow = Integer.parseInt(this.macdInputSlow.getText());
        }
        catch (Exception e3) {
            this.valMacdSlow = 26;
        }
        try {
            this.valMacdSignal = Integer.parseInt(this.macdInputSignal.getText());
        }
        catch (Exception e4) {
            this.valMacdSignal = 9;
        }
        if (this.isStartup) {
            this.ctrInf.createLowerIndicators(2, "MACD", 0, new Color[]{this.valColorFastSlow, this.valColorSignal, this.valColorDiv}, new int[]{this.valMacdFast, this.valMacdSlow, this.valMacdSignal});
            this.isStartup = false;
        } else {
            this.ctrInf.setLowerIndicatorsCfg(this.chartIdx, "MACD", 0, new int[]{this.valMacdFast, this.valMacdSlow, this.valMacdSignal});
            this.ctrInf.setLowerIndicatorsColor(this.chartIdx, "MACD", 0, new Color[]{this.valColorFastSlow, this.valColorSignal, this.valColorDiv});
        }
    }

    private void storeSetting() {
        UserProfile.put((Object)"MacdCfgPanel:valMacdFast", (Object)new Integer(this.valMacdFast));
        UserProfile.put((Object)"MacdCfgPanel:valMacdSlow", (Object)new Integer(this.valMacdSlow));
        UserProfile.put((Object)"MacdCfgPanel:valMacdSignal", (Object)new Integer(this.valMacdSignal));
        UserProfile.put((Object)"MacdCfgPanel:valColorFastSlow", (Object)this.valColorFastSlow);
        UserProfile.put((Object)"MacdCfgPanel:valColorSignal", (Object)this.valColorSignal);
        UserProfile.put((Object)"MacdCfgPanel:valColorDiv", (Object)this.valColorDiv);
    }

    public void loadSetting() {
        Integer valFast = (Integer)UserProfile.get((Object)"MacdCfgPanel:valMacdFast");
        Integer valSlow = (Integer)UserProfile.get((Object)"MacdCfgPanel:valMacdSlow");
        Integer valSignal = (Integer)UserProfile.get((Object)"MacdCfgPanel:valMacdSignal");
        Color colorFastSlow = (Color)UserProfile.get((Object)"MacdCfgPanel:valColorFastSlow");
        Color colorSignal = (Color)UserProfile.get((Object)"MacdCfgPanel:valColorSignal");
        Color colorDiv = (Color)UserProfile.get((Object)"MacdCfgPanel:valColorDiv");
        if (valFast != null && valSlow != null && valSignal != null && colorFastSlow != null && colorSignal != null && colorDiv != null) {
            this.macdInputFast.setText(valFast.toString());
            this.macdInputSlow.setText(valSlow.toString());
            this.macdInputSignal.setText(valSignal.toString());
            this.colorMacdFastSlow.setBackground(colorFastSlow);
            this.colorMacdSignal.setBackground(colorSignal);
            this.colorMacdDiv.setBackground(colorDiv);
        }
        this.processSetting();
    }
}

