/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.cfgpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import leaseLineQuote.ColorButton;
import leaseLineQuote.IntegerTextField;
import leaseLineQuote.StyledFont;
import leaseLineQuote.UserProfile;
import leaseLineQuote.candle.CandleNewFrame;
import leaseLineQuote.candle.cfgpanel.CandleConfigFrame;
import leaseLineQuote.candle.cfgpanel.CfgPanel;
import leaseLineQuote.candle.graph.ControlInterface;

public class SICfgPanel
extends JPanel
implements CfgPanel {
    private SILineCfg lcfgSi_1;
    private SILineNcCfg lcfgSi_2;
    private SILineCfg lcfgSi_3;
    private static SICfgPanel wrCfgPanel;
    private CandleConfigFrame parentFrame;
    private int chartIdx;
    private ControlInterface ctrInf;

    private SICfgPanel(CandleConfigFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.createPanel();
    }

    public static SICfgPanel getInstance(CandleConfigFrame parentFrame) {
        if (wrCfgPanel == null) {
            wrCfgPanel = new SICfgPanel(parentFrame);
        }
        return wrCfgPanel;
    }

    @Override
    public String getKey() {
        return "KD";
    }

    public void createPanel() {
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.lcfgSi_1 = new SILineCfg(Color.ORANGE.darker(), 14, 20, this.parentFrame);
        this.lcfgSi_1.add(this);
        this.lcfgSi_2 = new SILineNcCfg(1, 48, this.parentFrame);
        this.lcfgSi_2.add(this);
        this.lcfgSi_3 = new SILineCfg(Color.CYAN.darker(), 3, 76, this.parentFrame);
        this.lcfgSi_3.add(this);
    }

    public void setChinese() {
        this.lcfgSi_1.setChinese("\u96a8\u6a5f%K\u6307\u6a19\uff1a");
        this.lcfgSi_2.setChinese("\u96a8\u6a5f\u5e73\u5747%K\u6307\u6a19\uff1a");
        this.lcfgSi_3.setChinese("\u96a8\u6a5f\u5e73\u5747%D\u6307\u6a19\uff1a");
    }

    public void setEnglish() {
        this.lcfgSi_1.setEnglish("Stochastic %K: ");
        this.lcfgSi_2.setEnglish("Stochastic Avg%K: ");
        this.lcfgSi_3.setEnglish("Stochastic Avg%D: ");
    }

    @Override
    public void unshowLines() {
        this.ctrInf = CandleNewFrame.getControlInterface();
        this.ctrInf.removeLowerIndicators(this.chartIdx, "KD", 0);
    }

    @Override
    public void showLines(int chartIdx) {
        this.ctrInf = CandleNewFrame.getControlInterface();
        this.chartIdx = chartIdx;
        this.ctrInf.createLowerIndicators(chartIdx, "KD", 0, new Color[]{this.lcfgSi_1.getColor(), this.lcfgSi_3.getColor()}, new int[]{this.lcfgSi_1.getTypeVal(), this.lcfgSi_2.getTypeVal(), this.lcfgSi_3.getTypeVal()});
    }

    @Override
    public void processConfirm() {
        this.processSetting();
        this.storeSetting();
    }

    public void loadSetting() {
        this.lcfgSi_1.loadSetting();
        this.lcfgSi_2.loadSetting();
        this.lcfgSi_3.loadSetting();
        this.processSetting();
    }

    public void storeSetting() {
        this.lcfgSi_1.storeSetting();
        this.lcfgSi_2.storeSetting();
        this.lcfgSi_3.storeSetting();
    }

    private void processSetting() {
        this.ctrInf = CandleNewFrame.getControlInterface();
        this.ctrInf.setLowerIndicatorsCfg(this.chartIdx, "KD", 0, new int[]{this.lcfgSi_1.getTypeVal(), this.lcfgSi_2.getTypeVal(), this.lcfgSi_3.getTypeVal()});
        this.ctrInf.setLowerIndicatorsColor(this.chartIdx, "KD", 0, new Color[]{this.lcfgSi_1.getColor(), this.lcfgSi_3.getColor()});
    }

    class SILineNcCfg {
        private JLabel lblType;
        private IntegerTextField input;
        private int typeVal;

        public SILineNcCfg(int typeVal, int y, JFrame parentFrame) {
            this.typeVal = typeVal;
            this.lblType = new JLabel("Stochastics KD: ");
            this.lblType.setBounds(new Rectangle(5, y, 110, 16));
            this.lblType.setForeground(Color.black);
            this.lblType.setFont(StyledFont.PLAINFONT);
            this.input = new IntegerTextField(3);
            this.input.setBounds(new Rectangle(110, y - 3, 33, 23));
            this.input.setText(String.valueOf(this.typeVal));
        }

        public void setTypeVal(int typeVal) {
            this.input.setText(String.valueOf(typeVal));
        }

        public int getTypeVal() {
            return this.input.getValue();
        }

        public void setChinese(String type) {
            this.lblType.setText(type);
            this.lblType.setFont(StyledFont.PLAIN_CHINESE);
        }

        public void setEnglish(String type) {
            this.lblType.setText(type);
            this.lblType.setFont(StyledFont.PLAINFONT);
        }

        public void add(JPanel p2) {
            p2.add((Component)this.lblType, null);
            p2.add((Component)this.input, null);
        }

        private void storeSetting() {
            UserProfile.put((Object)"SILineCfg:typeVal", (Object)new Integer(this.typeVal));
        }

        private void loadSetting() {
            Integer typeVal = (Integer)UserProfile.get((Object)"SILineCfg:typeVal");
            if (typeVal != null) {
                this.input.setText(typeVal.toString());
            }
        }
    }

    class SILineCfg {
        private JLabel lblType;
        private IntegerTextField input;
        private JLabel lblColor;
        private ColorButton btnColor;
        private int typeVal;

        public SILineCfg(Color color, int typeVal, int y, JFrame parentFrame) {
            this.typeVal = typeVal;
            this.lblType = new JLabel("Stochastics KD: ");
            this.lblType.setBounds(new Rectangle(5, y, 110, 16));
            this.lblType.setForeground(Color.black);
            this.lblType.setFont(StyledFont.PLAINFONT);
            this.input = new IntegerTextField(3);
            this.input.setBounds(new Rectangle(110, y - 3, 33, 23));
            this.input.setText(String.valueOf(this.typeVal));
            this.lblColor = new JLabel("Color :");
            this.lblColor.setBounds(new Rectangle(165, y, 50, 16));
            this.lblColor.setForeground(Color.black);
            this.lblColor.setFont(StyledFont.PLAINFONT);
            this.btnColor = new ColorButton(color, parentFrame);
            this.btnColor.setBounds(new Rectangle(215, y + 3, 10, 10));
        }

        public Color getColor() {
            return this.btnColor.getColor();
        }

        public void setTypeVal(int typeVal) {
            this.input.setText(String.valueOf(typeVal));
        }

        public int getTypeVal() {
            return this.input.getValue();
        }

        public void setChinese(String type) {
            this.lblType.setText(type);
            this.lblType.setFont(StyledFont.PLAIN_CHINESE);
            this.lblColor.setText("\u8272\u5f69\uff1a");
            this.lblColor.setFont(StyledFont.PLAIN_CHINESE);
        }

        public void setEnglish(String type) {
            this.lblType.setText(type);
            this.lblType.setFont(StyledFont.PLAINFONT);
            this.lblColor.setText("Color: ");
            this.lblColor.setFont(StyledFont.PLAINFONT);
        }

        public void add(JPanel p2) {
            p2.add((Component)this.lblType, null);
            p2.add((Component)this.input, null);
            p2.add((Component)this.lblColor, null);
            p2.add((Component)this.btnColor, null);
        }

        private void storeSetting() {
            UserProfile.put((Object)"SILineCfg:typeVal", (Object)new Integer(this.typeVal));
            UserProfile.put((Object)"SILineCfg:color", (Object)this.btnColor.getColor());
        }

        private void loadSetting() {
            Integer typeVal = (Integer)UserProfile.get((Object)"SILineCfg:typeVal");
            Color color = (Color)UserProfile.get((Object)"SILineCfg:color");
            if (typeVal != null && color != null) {
                this.input.setText(typeVal.toString());
                this.btnColor.setBackground(color);
            }
        }
    }
}

