/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.cfgpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import leaseLineQuote.ColorButton;
import leaseLineQuote.IntegerTextField;
import leaseLineQuote.StyledFont;
import leaseLineQuote.UserProfile;
import leaseLineQuote.candle.CandleNewFrame;
import leaseLineQuote.candle.cfgpanel.CandleConfigFrame;
import leaseLineQuote.candle.cfgpanel.CfgPanel;
import leaseLineQuote.candle.graph.ControlInterface;

public class VolCfgPanel
extends JPanel
implements CfgPanel {
    private VolLineCfg lcfgVOL;
    private static VolCfgPanel volCfgPanel;
    private CandleConfigFrame parentFrame;
    private ControlInterface ctrInf;
    private int chartIdx = 0;
    private boolean isStartup = true;

    private VolCfgPanel(CandleConfigFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.createPanel();
    }

    public static VolCfgPanel getInstance(CandleConfigFrame parentFrame) {
        if (volCfgPanel == null) {
            volCfgPanel = new VolCfgPanel(parentFrame);
        }
        return volCfgPanel;
    }

    public void createPanel() {
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.lcfgVOL = new VolLineCfg(Color.GREEN.darker(), 10, this.parentFrame);
        this.lcfgVOL.add(this);
    }

    public void setChinese() {
        this.lcfgVOL.setChinese("\u6210\u4ea4\u91cf\u984f\u8272\uff1a");
    }

    public void setEnglish() {
        this.lcfgVOL.setEnglish("VOL Color:");
    }

    @Override
    public void processConfirm() {
        this.processSetting();
        this.lcfgVOL.storeSetting();
    }

    @Override
    public String getKey() {
        return "VOL";
    }

    private void processSetting() {
        this.ctrInf = CandleNewFrame.getControlInterface();
        Color color = this.lcfgVOL.btnColor.getBackground();
        if (this.isStartup) {
            this.ctrInf.createLowerIndicators(0, "VOL", 0, new Color[]{Color.red}, null);
        } else {
            this.ctrInf.setLowerIndicatorsColor(this.chartIdx, "VOL", 0, new Color[]{color});
        }
        this.isStartup = false;
    }

    public void loadSetting() {
        this.lcfgVOL.loadSetting();
        this.processSetting();
    }

    @Override
    public void unshowLines() {
        this.ctrInf = CandleNewFrame.getControlInterface();
        this.ctrInf.removeLowerIndicators(this.chartIdx, "VOL", 0);
    }

    @Override
    public void showLines(int chartIdx) {
        this.ctrInf = CandleNewFrame.getControlInterface();
        this.chartIdx = chartIdx;
        this.ctrInf.createLowerIndicators(chartIdx, "VOL", 0, new Color[]{this.lcfgVOL.color}, null);
    }

    public class VolLineCfg {
        public JLabel lblType = new JLabel("Vol Color:");
        public ColorButton btnColor;
        public Color color;
        public IntegerTextField input;

        public VolLineCfg(Color color, int y, JFrame parentFrame) {
            this.lblType.setBounds(new Rectangle(5, y, 110, 16));
            this.lblType.setForeground(Color.black);
            this.lblType.setFont(StyledFont.PLAINFONT);
            this.btnColor = new ColorButton(color, parentFrame);
            this.btnColor.setBounds(new Rectangle(215, y + 3, 10, 10));
            this.color = color;
        }

        public void setChinese(String type) {
            this.lblType.setText(type);
            this.lblType.setFont(StyledFont.PLAIN_CHINESE);
        }

        public void setEnglish(String type) {
            this.lblType.setText(type);
            this.lblType.setFont(StyledFont.PLAINFONT);
        }

        public void add(JPanel p2) {
            p2.add((Component)this.lblType, null);
            p2.add((Component)this.btnColor, null);
        }

        public void storeSetting() {
            UserProfile.put((Object)"VolLineCfg:Color", (Object)this.color);
        }

        public void loadSetting() {
            Color c2 = (Color)UserProfile.get((Object)"VolLineCfg:Color");
            if (c2 != null) {
                this.color = c2;
            }
        }
    }
}

