/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.control;

public class BaseCodeList<T> {
    private final T[] codeList;
    private final String[] chiName;
    private final String[] engName;

    public BaseCodeList(T[] codeList, String[] chiName, String[] engName) {
        this.codeList = codeList;
        this.chiName = chiName;
        this.engName = engName;
    }

    public T nameToCode(String name) {
        int i2 = BaseCodeList.indexOf(this.chiName, name);
        if (i2 == -1) {
            i2 = BaseCodeList.indexOf(this.engName, name);
        }
        if (i2 == -1) {
            return null;
        }
        return this.codeList[i2];
    }

    public boolean isCode(T code) {
        return BaseCodeList.indexOf(this.codeList, code) != -1;
    }

    public String codeToChiName(T code) {
        int i2 = BaseCodeList.indexOf(this.codeList, code);
        if (i2 == -1) {
            return null;
        }
        return this.chiName[i2];
    }

    public String codeToEngName(T code) {
        int i2 = BaseCodeList.indexOf(this.codeList, code);
        if (i2 == -1) {
            return null;
        }
        return this.engName[i2];
    }

    public T[] getCodeList() {
        return this.codeList;
    }

    public String[] getChiNameList() {
        return this.chiName;
    }

    public String[] getEngNameList() {
        return this.engName;
    }

    private static int indexOf(Object[] sa, Object s2) {
        for (int i2 = 0; i2 < sa.length; ++i2) {
            if (!sa[i2].equals(s2)) continue;
            return i2;
        }
        return -1;
    }
}

