/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.datasource;

import ilog.views.chart.data.IlvAbstractDataSet;
import ilog.views.chart.data.IlvAbstractDataSource;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDataSetList;
import java.util.Date;
import leaseLineQuote.candle.CandleNewFrame;
import leaseLineQuote.candle.datasource.histrecord.HistRecordReader;
import leaseLineQuote.candle.datasource.histrecord.StockData;
import leaseLineQuote.candle.graph.core.CandlePanel;

public class StockDataSource
extends IlvAbstractDataSource {
    public static final int DAY = 0;
    public static final int WEEK = 1;
    public static final int MONTH = 2;
    public static final int MINUTE = 3;
    private StockData stockData = null;
    private int period = 0;
    private static StockDataSource source = null;

    private StockDataSource() {
    }

    public void reset() {
        this.loadData("-2", -1, -1, -1, null);
    }

    public synchronized boolean loadData(String symbol, int monthPeriodIdx, int period, int amount, LoadHook afterLoad) {
        ReqInput reqInput = new ReqInput();
        reqInput.symbol = symbol;
        reqInput.period = period;
        this.period = period;
        reqInput.afterLoad = afterLoad;
        reqInput.amount = amount;
        reqInput.monthPeriodIdx = monthPeriodIdx;
        HistRecordReader reader = HistRecordReader.getInstance();
        this.stockData = reader.readData(reqInput.symbol, reqInput.monthPeriodIdx, reqInput.period, reqInput.amount);
        if (this.stockData == null) {
            IlvDataSetList dataSetList = this.getDataSetList();
            dataSetList.setDataSets(null);
            reqInput.afterLoad = null;
            return false;
        }
        IlvDataSet[] dataSets = new DataSet[this.stockData.dataDesc.length];
        for (int i2 = 0; i2 < dataSets.length; ++i2) {
            dataSets[i2] = new DataSet(this.stockData.dataDesc[i2], this.stockData.data[i2]);
        }
        this.getDataSetList().setDataSets(dataSets);
        reqInput.afterLoad.dataLoaded();
        ((CandlePanel)CandleNewFrame.getControlInterface()).setUnhighlight();
        reqInput.afterLoad = null;
        return true;
    }

    public static StockDataSource getInstance() {
        if (source == null) {
            source = new StockDataSource();
        }
        return source;
    }

    public String getSymbol() {
        return this.stockData != null ? this.stockData.symbol : null;
    }

    public Date[] getDates() {
        if (this.stockData == null) {
            return null;
        }
        return (Date[])this.stockData.dates.clone();
    }

    public Date getDate(int idx) {
        if (this.stockData != null && idx < this.stockData.dates.length) {
            return this.stockData.dates[idx];
        }
        return null;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getIntervalUnit() {
        return this.stockData.intervalUnit;
    }

    public IlvDataSet getOpenDataSet() {
        return this.isLoaded() ? this.getDataSet(0) : null;
    }

    public IlvDataSet getHighDataSet() {
        return this.isLoaded() ? this.getDataSet(1) : null;
    }

    public IlvDataSet getLowDataSet() {
        return this.isLoaded() ? this.getDataSet(2) : null;
    }

    public IlvDataSet getCloseDataSet() {
        return this.isLoaded() ? this.getDataSet(3) : null;
    }

    public IlvDataSet getVolumeDataSet() {
        return this.isLoaded() ? this.getDataSet(4) : null;
    }

    private boolean isLoaded() {
        return this.getDataSetCount() == 5;
    }

    public class DataSet
    extends IlvAbstractDataSet {
        private double[] data;

        public DataSet(String name, double[] data) {
            this.data = data;
            this.setName(name);
        }

        @Override
        public int getDataCount() {
            return this.data.length;
        }

        @Override
        public boolean isXValuesSorted() {
            return true;
        }

        @Override
        public double getXData(int idx) {
            return idx;
        }

        @Override
        public double getYData(int idx) {
            return this.data[idx];
        }

        public final double[] getAllData() {
            return (double[])this.data.clone();
        }
    }

    public static interface LoadHook {
        public void dataLoaded();
    }

    class ReqInput {
        public String symbol;
        public int monthPeriodIdx;
        public int period;
        public LoadHook afterLoad;
        public int amount;

        ReqInput() {
        }

        public String toString() {
            return "symbol=" + this.symbol + ", monthPeriodIdx=" + this.monthPeriodIdx + ", period=" + this.period + ", amount=" + this.amount;
        }
    }
}

