/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.core;

import ilog.views.chart.IlvAffineAxisTransformer;
import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvAxisTransformerException;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvGrid;
import ilog.views.chart.IlvScale;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.event.AxisChangeEvent;
import ilog.views.chart.event.AxisListener;
import ilog.views.chart.event.AxisRangeEvent;
import ilog.views.chart.event.DataSourceEvent;
import ilog.views.chart.event.DataSourceListener;
import ilog.views.chart.util.IlvDoubleArray;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.SwingUtilities;
import leaseLineQuote.candle.graph.core.CandlePanel;

public class PercentDisplayer
implements AxisListener,
DataSourceListener {
    IlvAffineAxisTransformer transform = new IlvAffineAxisTransformer(1.0, 0.0);
    boolean active = false;
    boolean visible = false;
    IlvScale percentScale;
    IlvGrid percentGrid;
    CandlePanel stockDemo = CandlePanel.getInstance();
    IlvChart mainChart = this.stockDemo.getMainChart();

    public PercentDisplayer() {
        IlvAxis yAxis = this.mainChart.addYAxis(false, false);
        yAxis.setTransformer(this.transform);
        yAxis.synchronizeWith(this.mainChart.getYAxis(0), true);
        this.percentScale = new IlvScale(){

            @Override
            public String computeLabel(double v) {
                String res = super.computeLabel(v);
                return PercentDisplayer.this.getPercentVariation(v) > 0.0 ? '+' + res + '%' : res + '%';
            }
        };
        this.percentScale.setMajorTickVisible(false);
        this.percentScale.setStepUnit(null, new Double(0.0));
        this.percentGrid = new IlvGrid(){

            @Override
            public void draw(Graphics g2) {
                if (this.getChart() == null) {
                    return;
                }
                IlvAxis axis = this.getAxis();
                if (axis.getTVisibleRange().isInside(0.0)) {
                    try {
                        IlvDoubleArray values = new IlvDoubleArray();
                        values.add(PercentDisplayer.this.transform.inverse(0.0));
                        this.draw(g2, values, true);
                    }
                    catch (IlvAxisTransformerException ilvAxisTransformerException) {
                        // empty catch block
                    }
                }
            }
        };
        BasicStroke stroke = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{10.0f, 6.0f}, 0.0f);
        this.percentGrid.setMajorStroke(stroke);
        this.percentGrid.setMajorPaint(Color.white);
        this.setActive(true);
    }

    public double getPercentVariation(double price) {
        try {
            return this.transform.apply(price);
        }
        catch (IlvAxisTransformerException x) {
            return 0.0;
        }
    }

    @Override
    public void axisRangeChanged(AxisRangeEvent evt) {
        if (evt.isChangedEvent() && evt.isVisibleRangeEvent()) {
            this.update();
        }
    }

    @Override
    public void axisChanged(AxisChangeEvent evt) {
    }

    @Override
    public void dataSourceChanged(DataSourceEvent evt) {
        this.update();
    }

    private void update() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int firstIdx;
                IlvDataSet closeDS = PercentDisplayer.this.stockDemo.getStockDataSource().getCloseDataSet();
                if (closeDS != null && (firstIdx = (int)Math.ceil(PercentDisplayer.this.mainChart.getXAxis().getVisibleMin())) < closeDS.getDataCount()) {
                    double v = closeDS.getYData(firstIdx);
                    PercentDisplayer.this.transform.setDefinition(100.0 / v, -100.0);
                    PercentDisplayer.this.setVisible(true);
                    return;
                }
                PercentDisplayer.this.transform.setDefinition(1.0, 0.0);
                PercentDisplayer.this.setVisible(false);
            }
        });
    }

    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        if (visible) {
            this.mainChart.getChartArea().setMargins(null);
            this.mainChart.setYScale(1, this.percentScale);
            this.mainChart.setYGrid(1, this.percentGrid);
        } else {
            this.mainChart.getChartArea().setRightMargin(6);
            this.mainChart.setYScale(1, null);
            this.mainChart.setYGrid(1, null);
        }
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (active) {
            this.update();
            this.mainChart.getXAxis().addAxisListener(this);
            this.stockDemo.getStockDataSource().addDataSourceListener(this);
            this.setVisible(true);
        } else {
            this.setVisible(false);
            this.mainChart.getXAxis().removeAxisListener(this);
            this.stockDemo.getStockDataSource().removeDataSourceListener(this);
        }
    }
}

