/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.core;

import ilog.views.chart.IlvDisplayPoint;
import java.awt.Dimension;
import java.awt.Font;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import leaseLineQuote.candle.graph.ChartColors;
import leaseLineQuote.candle.graph.core.CandlePanel;

public class UpperDataStatusControl
implements ChartColors {
    private static final Font DEFAULT_FONT = new Font("Dialog", 0, 10);
    private static UpperDataStatusControl usc;
    private JPanel header;

    private UpperDataStatusControl() {
    }

    public static UpperDataStatusControl getInstance() {
        if (usc == null) {
            usc = new UpperDataStatusControl();
        }
        return usc;
    }

    private void clearLabel(JPanel header) {
        JLabel[] dataLbls = (JLabel[])header.getClientProperty("STATUS");
        if (dataLbls != null && dataLbls.length > 0) {
            for (int i2 = 0; i2 < dataLbls.length; ++i2) {
                header.remove(dataLbls[i2]);
            }
        }
        header.putClientProperty("STATUS", new JLabel[0]);
        JLabel[] nameLbls = (JLabel[])header.getClientProperty("NAME");
        if (nameLbls != null && nameLbls.length > 0) {
            for (int i3 = 0; i3 < nameLbls.length; ++i3) {
                header.remove(nameLbls[i3]);
            }
        }
        header.putClientProperty("NAME", new JLabel[0]);
    }

    public void registerHeader(JPanel header) {
        this.header = header;
    }

    public void setDatasToLabels(LinkedHashMap dataMap) {
        int i2;
        if (this.header == null) {
            System.out.println("[ERR]repected header not found.");
            return;
        }
        dataMap.remove("High");
        dataMap.remove("Date");
        dataMap.remove("Low");
        dataMap.remove("Open");
        dataMap.remove("Close");
        JLabel[] dataLbls = (JLabel[])this.header.getClientProperty("STATUS");
        JLabel[] nameLbls = (JLabel[])this.header.getClientProperty("NAME");
        if (dataLbls != null && dataLbls.length != dataMap.size()) {
            this.clearLabel(this.header);
            dataLbls = (JLabel[])this.header.getClientProperty("STATUS");
            nameLbls = (JLabel[])this.header.getClientProperty("NAME");
        } else if (dataLbls == null) {
            this.header.putClientProperty("STATUS", new JLabel[0]);
            this.header.putClientProperty("NAME", new JLabel[0]);
            dataLbls = (JLabel[])this.header.getClientProperty("STATUS");
            nameLbls = (JLabel[])this.header.getClientProperty("NAME");
        }
        String[] names = dataMap.keySet().toArray(new String[0]);
        IlvDisplayPoint[] datas = dataMap.values().toArray(new IlvDisplayPoint[0]);
        if (dataLbls.length == 0) {
            dataLbls = new JLabel[names.length];
            nameLbls = new JLabel[names.length];
            for (i2 = 0; i2 < names.length; ++i2) {
                nameLbls[i2] = this.createNameLabel(names[i2]);
                dataLbls[i2] = this.createLabel(60);
                this.header.add(nameLbls[i2]);
                this.header.add(dataLbls[i2]);
            }
            this.header.putClientProperty("STATUS", dataLbls);
            this.header.putClientProperty("NAME", nameLbls);
        } else {
            for (i2 = 0; i2 < names.length; ++i2) {
                nameLbls[i2].setText(names[i2]);
            }
        }
        for (i2 = 0; i2 < names.length; ++i2) {
            String val = CandlePanel.numFmt.format(datas[i2].getYData());
            dataLbls[i2].setText(val);
        }
        this.header.updateUI();
    }

    private JLabel createLabel_bak() {
        JLabel status = new JLabel(" ", 4);
        status.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        status.setFont(DEFAULT_FONT);
        Dimension size = status.getPreferredSize();
        size.width = 85;
        status.setPreferredSize(size);
        status.setMinimumSize(size);
        status.setMaximumSize(size);
        status.setForeground(FIXEDLABEL_FOREGROUND);
        status.setBackground(FIXEDLABEL_BACKGROUND);
        status.setOpaque(true);
        return status;
    }

    private JLabel createLabel(int width) {
        JLabel status = new JLabel(" ", 4);
        status.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        status.setFont(DEFAULT_FONT);
        Dimension size = status.getPreferredSize();
        size.width = width;
        status.setPreferredSize(size);
        status.setMinimumSize(size);
        status.setMaximumSize(size);
        status.setForeground(FIXEDLABEL_FOREGROUND);
        status.setBackground(FIXEDLABEL_BACKGROUND);
        status.setOpaque(true);
        return status;
    }

    private JLabel createNameLabel(String name) {
        JLabel nameLbl = new JLabel(name, 4);
        nameLbl.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 4));
        nameLbl.setFont(DEFAULT_FONT);
        nameLbl.setForeground(FIXEDLABEL_FOREGROUND);
        nameLbl.setOpaque(false);
        return nameLbl;
    }
}

