/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.custdecoration;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartDecoration;
import ilog.views.chart.IlvChartProjector;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvScale;
import ilog.views.chart.IlvStepsDefinition;
import ilog.views.chart.IlvStyle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Rectangle;

public class Stripes
extends IlvChartDecoration {
    private IlvStyle fillStyle;
    IlvScale scale;

    public Stripes(IlvScale scale, Paint fillPaint) {
        this.scale = scale;
        this.setFillPaint(fillPaint);
    }

    public void setFillPaint(Paint paint) {
        this.fillStyle = this.getFillStyle().setFillPaint(paint);
    }

    public final Paint getFillPaint() {
        return this.getFillStyle().getFillPaint();
    }

    private IlvStyle getFillStyle() {
        if (this.fillStyle == null) {
            this.fillStyle = new IlvStyle(Color.lightGray);
        }
        return this.fillStyle;
    }

    protected IlvDataInterval nextStripe(IlvDataInterval itv) {
        IlvStepsDefinition def = this.scale.getStepsDefinition();
        if (itv == null) {
            itv = this.getAxis().getVisibleRange();
            double v = def.previousStep(itv.getMin());
            itv.setMin(def.incrementStep(v));
            itv.setMax(def.incrementStep(itv.getMin()));
        } else {
            itv.setMax(def.incrementStep(def.incrementStep(itv.getMax())));
            itv.setMin(def.incrementStep(def.incrementStep(itv.getMin())));
        }
        return itv;
    }

    private final IlvAxis getAxis() {
        return this.scale.getAxis();
    }

    @Override
    public void draw(Graphics g2) {
        IlvChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        IlvDataInterval itv = this.nextStripe(null);
        IlvDataWindow w = null;
        w = this.getAxis().getType() == 1 ? new IlvDataWindow(itv, chart.getYAxis(0).getVisibleRange()) : new IlvDataWindow(chart.getXAxis().getVisibleRange(), itv);
        IlvChartProjector prj = this.getChart().getProjector();
        IlvCoordinateSystem coordSys = this.getChart().getCoordinateSystem(0);
        Rectangle plotRect = this.getChart().getChartArea().getPlotRect();
        IlvStyle style = this.getFillStyle();
        while (itv.getMin() < this.getAxis().getVisibleMax()) {
            style.fill(g2, prj.getShape(w, plotRect, coordSys));
            if (this.getAxis().getType() == 1) {
                w.xRange = this.nextStripe(itv);
                continue;
            }
            w.yRange = this.nextStripe(itv);
        }
    }
}

