/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.custdecoration;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvColor;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvLabelRenderer;
import ilog.views.chart.IlvScale;
import ilog.views.chart.IlvScaleAnnotation;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.event.AxisChangeEvent;
import ilog.views.chart.event.AxisListener;
import ilog.views.chart.event.AxisRangeEvent;
import ilog.views.chart.graphic.IlvDataIndicator;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import ilog.views.chart.java2d.IlvValueGradientPaint;
import ilog.views.chart.swing.IlvDoubleSlider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import javax.swing.BorderFactory;

public class ThresholdLines
implements AxisListener,
IlvDataRenderingHint {
    static final float MERGE_FACTOR = 0.8f;
    static final boolean USE_PATTERN = true;
    protected int axisIdx;
    protected IlvDataInterval thresholds = new IlvDataInterval();
    protected Color foreground;
    protected Color background;
    protected Color lowerColor;
    protected Color midColor;
    protected Color upperColor;
    private HashMap upStyles = new HashMap();
    private HashMap lowStyles = new HashMap();
    private HashMap midStyles = new HashMap();
    private IlvChart chart;
    private IlvDataIndicator[] indicators;
    private IlvScaleAnnotation[] annotations;
    private IlvDoubleSlider rangeSlider;
    private boolean isEnable = false;

    public ThresholdLines(Color foreground, Color background, Color lowerColor, Color midColor, Color upperColor) {
        this.foreground = foreground;
        this.background = background;
        this.lowerColor = lowerColor;
        this.midColor = midColor;
        this.upperColor = upperColor;
    }

    public void setEnable(boolean isEnable) {
        this.isEnable = isEnable;
        if (isEnable) {
            this.adjustRange();
        }
    }

    public IlvAxis getAxis() {
        return this.axisIdx == -1 ? this.chart.getXAxis() : this.chart.getYAxis(this.axisIdx);
    }

    protected synchronized void setChart(IlvChart chart, int axisIdx) {
        if (this.chart == chart) {
            return;
        }
        if (this.chart != null && chart != null) {
            throw new IllegalArgumentException("ThresholdLines already connected to a chart.");
        }
        if (chart != null) {
            this.chart = chart;
            this.axisIdx = axisIdx;
            IlvScale scale = this.getChart().getScale(this.getAxis());
            this.getAxis().addAxisListener(this);
            this.indicators = this.createIndicators();
            this.annotations = this.createAnnotations();
            if (this.getLowerIndicator() != null) {
                this.getChart().addDecoration(this.getLowerIndicator());
            }
            if (this.getUpperIndicator() != null) {
                this.getChart().addDecoration(this.getUpperIndicator());
            }
            if (this.getLowerAnnotation() != null) {
                scale.addAnnotation(this.getLowerAnnotation());
            }
            if (this.getUpperAnnotation() != null) {
                scale.addAnnotation(this.getUpperAnnotation());
            }
            chart.putClientProperty(new Key(this.getAxis()), this);
            this.setEnable(true);
            this.update();
        } else {
            IlvScale scale = this.getChart().getScale(this.getAxis());
            if (this.getLowerIndicator() != null) {
                this.getChart().removeDecoration(this.getLowerIndicator());
            }
            if (this.getUpperIndicator() != null) {
                this.getChart().removeDecoration(this.getUpperIndicator());
            }
            if (this.getLowerAnnotation() != null) {
                scale.removeAnnotation(this.getLowerAnnotation());
            }
            if (this.getUpperAnnotation() != null) {
                scale.removeAnnotation(this.getUpperAnnotation());
            }
            this.getAxis().removeAxisListener(this);
            this.getChart().putClientProperty(new Key(this.getAxis()), null);
            this.chart = chart;
            this.axisIdx = axisIdx;
            this.setEnable(false);
        }
    }

    public IlvDataInterval getThresholds() {
        return new IlvDataInterval(this.thresholds);
    }

    private void _setThresholds(IlvDataInterval itv) {
        this.thresholds = new IlvDataInterval(itv);
        this.update();
    }

    @Override
    public void axisRangeChanged(AxisRangeEvent evt) {
        if (evt.isChangedEvent() && !evt.isAdjusting() && !evt.isVisibleRangeEvent() && this.isEnable && (evt.getNewMin() != evt.getOldMin() || evt.getNewMax() != evt.getOldMax())) {
            this._setThresholds(new IlvDataInterval(Math.floor(evt.getNewMin()), Math.floor(evt.getNewMax())));
        }
    }

    @Override
    public void axisChanged(AxisChangeEvent evt) {
        if (evt.getType() == 1) {
            this.chart.setAntiAliasing(!evt.isAdjusting());
        }
    }

    public void adjustRange(double min, double max) {
        this.adjustRange(new IlvDataInterval(min, max));
    }

    public void adjustRange(IlvDataInterval itv) {
        this.getAxis().setAdjusting(true);
        this._setThresholds(itv);
        this.getAxis().setAdjusting(false);
    }

    public void adjustRange() {
        if (!this.isEnable) {
            return;
        }
        IlvDataInterval range = null;
        IlvAxis axis = this.getAxis();
        range = axis.isBounded() ? axis.getDataRange() : axis.getVisibleRange();
        int min = (int)Math.floor(range.getMin());
        int max = (int)Math.ceil(range.getMax());
        this.adjustRange(min, max);
    }

    public IlvChart getChart() {
        return this.chart;
    }

    public IlvDataIndicator getLowerIndicator() {
        return this.indicators == null ? null : this.indicators[0];
    }

    public IlvDataIndicator getUpperIndicator() {
        return this.indicators == null ? null : this.indicators[1];
    }

    public IlvScaleAnnotation getLowerAnnotation() {
        return this.annotations == null ? null : this.annotations[0];
    }

    public IlvScaleAnnotation getUpperAnnotation() {
        return this.annotations == null ? null : this.annotations[1];
    }

    protected IlvDataIndicator[] createIndicators() {
        IlvDataIndicator[] indicators = new IlvDataIndicator[2];
        BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f}, 0.0f);
        IlvStyle style = new IlvStyle(IlvStyle.DEFAULT_STROKE, this.foreground, IlvColor.setAlpha(this.lowerColor, 0.2f));
        indicators[0] = new IlvDataIndicator(this.axisIdx, 0.0, null);
        indicators[0].setStyle(style);
        indicators[0].setDrawOrder(-1);
        style = new IlvStyle(IlvStyle.DEFAULT_STROKE, this.foreground, IlvColor.setAlpha(this.upperColor, 0.2f));
        indicators[1] = new IlvDataIndicator(this.axisIdx, 0.0, null);
        indicators[1].setStyle(style);
        indicators[1].setDrawOrder(-1);
        return indicators;
    }

    protected IlvScaleAnnotation[] createAnnotations() {
        if (this.getChart().getScale(this.getAxis()) == null) {
            return null;
        }
        IlvScaleAnnotation[] annotations = new IlvScaleAnnotation[2];
        annotations[0] = new IlvScaleAnnotation(0.0, null);
        this.configureRenderer(annotations[0].getLabelRenderer(), this.lowerColor);
        annotations[1] = new IlvScaleAnnotation(0.0, null);
        this.configureRenderer(annotations[1].getLabelRenderer(), this.upperColor);
        return annotations;
    }

    private void configureRenderer(IlvLabelRenderer labelRenderer, Color bg) {
        labelRenderer.setColor(this.foreground);
        labelRenderer.setBackground(bg);
        labelRenderer.setOpaque(true);
        labelRenderer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.foreground), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
    }

    @Override
    public IlvStyle getStyle(IlvDisplayPoint dp, IlvStyle style) {
        if (dp.getYData() >= this.thresholds.getMax()) {
            IlvStyle s2 = (IlvStyle)this.upStyles.get(style);
            if (s2 != null) {
                return s2;
            }
            if (style.isFillOn()) {
                Color c2 = style.getFillColor();
                if (c2 == null) {
                    return style;
                }
                c2 = IlvColor.setAlpha(this.upperColor, (float)c2.getAlpha() / 255.0f);
                s2 = style.isStrokeOn() ? new IlvStyle(this.upperColor, (Paint)c2) : style.setFillPaint(c2);
            } else {
                s2 = style.setStrokePaint(this.upperColor);
            }
            this.upStyles.put(style, s2);
            return s2;
        }
        if (dp.getYData() <= this.thresholds.getMin()) {
            IlvStyle s3 = (IlvStyle)this.lowStyles.get(style);
            if (s3 != null) {
                return s3;
            }
            if (style.isFillOn()) {
                Color c3 = style.getFillColor();
                if (c3 == null) {
                    return style;
                }
                c3 = IlvColor.setAlpha(this.lowerColor, (float)c3.getAlpha() / 255.0f);
                s3 = style.isStrokeOn() ? new IlvStyle(this.lowerColor, (Paint)c3) : style.setFillPaint(c3);
            } else {
                s3 = style.setStrokePaint(this.lowerColor);
            }
            this.lowStyles.put(style, s3);
            return s3;
        }
        IlvStyle s4 = (IlvStyle)this.midStyles.get(style);
        if (s4 != null) {
            return s4;
        }
        if (style.isFillOn()) {
            Color c4 = style.getFillColor();
            if (c4 == null) {
                return style;
            }
            c4 = IlvColor.setAlpha(this.midColor, (float)c4.getAlpha() / 255.0f);
            s4 = style.isStrokeOn() ? new IlvStyle(this.midColor, (Paint)c4) : style.setFillPaint(c4);
        } else {
            s4 = style.setStrokePaint(this.midColor);
        }
        this.midStyles.put(style, s4);
        return s4;
    }

    private void update() {
        IlvScale scale = this.getChart().getScale(this.getAxis());
        if (this.thresholds.isEmpty()) {
            if (this.getLowerIndicator() != null) {
                this.getLowerIndicator().setVisible(false);
            }
            if (this.getUpperIndicator() != null) {
                this.getUpperIndicator().setVisible(false);
            }
            if (this.getLowerAnnotation() != null) {
                scale.removeAnnotation(this.getLowerAnnotation());
            }
            if (this.getUpperAnnotation() != null) {
                scale.removeAnnotation(this.getUpperAnnotation());
            }
        } else {
            IlvScaleAnnotation anno;
            IlvDataIndicator indic = this.getLowerIndicator();
            if (indic != null) {
                if (indic.getType() == 0 || indic.getType() == 1) {
                    indic.setValue(this.thresholds.getMin());
                } else {
                    indic.setRange(new IlvDataInterval(-1.7976931348623157E308, this.thresholds.getMin()));
                }
                if (!indic.isVisible()) {
                    indic.setVisible(true);
                }
            }
            if ((indic = this.getUpperIndicator()) != null) {
                if (indic.getType() == 0 || indic.getType() == 1) {
                    indic.setValue(this.thresholds.getMax());
                } else {
                    indic.setRange(new IlvDataInterval(this.thresholds.getMax(), Double.MAX_VALUE));
                }
                if (!indic.isVisible()) {
                    indic.setVisible(true);
                }
            }
            if ((anno = this.getLowerAnnotation()) != null) {
                anno.setValue(this.thresholds.getMin());
                if (anno.getScale() == null) {
                    scale.addAnnotation(anno);
                }
            }
            if ((anno = this.getUpperAnnotation()) != null) {
                anno.setValue(this.thresholds.getMax());
                if (anno.getScale() == null) {
                    scale.addAnnotation(anno);
                }
            }
        }
        this.getChart().getChartArea().repaint();
    }

    Paint getGradientPaint(float alpha) {
        double[] vals = new double[]{this.getAxis().getDataMin(), this.thresholds.getMin(), this.thresholds.getMin(), this.thresholds.getMax(), this.thresholds.getMax(), this.getAxis().getDataMax()};
        Color[] colors = new Color[]{IlvColor.setAlpha(this.lowerColor, alpha), IlvColor.setAlpha(this.lowerColor, alpha), IlvColor.setAlpha(this.midColor, alpha), IlvColor.setAlpha(this.midColor, alpha), IlvColor.setAlpha(this.upperColor, alpha), IlvColor.setAlpha(this.upperColor, alpha)};
        return new IlvValueGradientPaint(this.chart, 0, vals, colors);
    }

    public static void set(ThresholdLines t2, IlvChart chart, int axisIdx) {
        t2.setChart(chart, axisIdx);
    }

    public static ThresholdLines remove(IlvChart chart, int axisIdx) {
        ThresholdLines t2 = ThresholdLines.get(chart, axisIdx);
        if (t2 != null) {
            t2.setChart(null, -1);
        }
        return t2;
    }

    public static ThresholdLines get(IlvChart chart, int axisIdx) {
        IlvAxis axis = axisIdx == -1 ? chart.getXAxis() : chart.getYAxis(axisIdx);
        return (ThresholdLines)chart.getClientProperty(new Key(axis));
    }

    private static class Key {
        private IlvAxis axis;

        public Key(IlvAxis axis) {
            this.axis = axis;
        }

        public int hashCode() {
            return this.axis.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return key.axis == this.axis;
        }
    }
}

