/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.custindicator;

import ilog.views.chart.IlvChartDataPicker;
import ilog.views.chart.IlvChartInteractor;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDefaultChartDataPicker;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.interactor.IlvChartHighlightInteractor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class HighlightQuotesInteractor
extends IlvChartHighlightInteractor {
    private IlvChartRenderer[] targets;

    protected boolean isTarget(IlvChartRenderer r2) {
        return true;
    }

    @Override
    protected IlvChartDataPicker createDataPicker(MouseEvent evt) {
        return new IlvDefaultChartDataPicker(evt.getX(), evt.getY(), Integer.MAX_VALUE){

            @Override
            public double computeDistance(double x1, double y1, double x2, double y2) {
                return Math.abs(x2 - x1) + Math.log(Math.abs(y2 - y1) + 0.1);
            }

            @Override
            public boolean accept(IlvChartRenderer renderer) {
                return HighlightQuotesInteractor.this.isTarget(renderer);
            }
        };
    }

    @Override
    protected IlvDisplayPoint pickData(IlvChartDataPicker picker) {
        Rectangle plotRect = this.getChart().getChartArea().getPlotRect();
        if (plotRect.contains(picker.getPickX(), picker.getPickY())) {
            return super.pickData(picker);
        }
        return null;
    }

    @Override
    public void interactionStarted(IlvChartInteractor inter, MouseEvent evt) {
        IlvDisplayPoint dp = this.getHighlightedPoint();
        if (dp != null) {
            this.doIt(dp, false, evt);
        }
    }
}

