/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.custindicator.horizontal;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvColor;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvLabelRenderer;
import ilog.views.chart.IlvScale;
import ilog.views.chart.IlvScaleAnnotation;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.event.AxisChangeEvent;
import ilog.views.chart.event.AxisListener;
import ilog.views.chart.event.AxisRangeEvent;
import ilog.views.chart.graphic.IlvDataIndicator;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import ilog.views.chart.java2d.IlvValueGradientPaint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import javax.swing.BorderFactory;

public class HorizLine
implements AxisListener,
IlvDataRenderingHint {
    static final float MERGE_FACTOR = 0.8f;
    static final boolean USE_PATTERN = true;
    protected int axisIdx;
    protected IlvDataInterval thresholds = new IlvDataInterval();
    protected Color foreground;
    protected Color background;
    protected Color lowerColor;
    private IlvChart chart;
    private IlvDataIndicator indicator;
    private IlvScaleAnnotation annotation;
    private boolean isEnable = false;

    public HorizLine(Color foreground, Color background, Color lowerColor) {
        this.foreground = foreground;
        this.background = background;
        this.lowerColor = lowerColor;
    }

    public void setEnable(boolean isEnable) {
        this.isEnable = isEnable;
        if (isEnable) {
            this.adjustRange();
        }
    }

    public IlvAxis getAxis() {
        return this.axisIdx == -1 ? this.chart.getXAxis() : this.chart.getYAxis(this.axisIdx);
    }

    protected synchronized void setChart(IlvChart chart, int axisIdx) {
        if (this.chart == chart) {
            return;
        }
        if (this.chart != null && chart != null) {
            throw new IllegalArgumentException("ThresholdLines already connected to a chart.");
        }
        if (chart != null) {
            this.chart = chart;
            this.axisIdx = axisIdx;
            IlvScale scale = this.getChart().getScale(this.getAxis());
            this.getAxis().addAxisListener(this);
            this.indicator = this.createIndicators();
            this.annotation = this.createAnnotations();
            if (this.getLowerIndicator() != null) {
                this.getChart().addDecoration(this.getLowerIndicator());
            }
            if (this.getLowerAnnotation() != null) {
                scale.addAnnotation(this.getLowerAnnotation());
            }
            chart.putClientProperty(new Key(this.getAxis()), this);
            this.setEnable(true);
            this.update();
        } else {
            IlvScale scale = this.getChart().getScale(this.getAxis());
            if (this.getLowerIndicator() != null) {
                this.getChart().removeDecoration(this.getLowerIndicator());
            }
            if (this.getLowerAnnotation() != null) {
                scale.removeAnnotation(this.getLowerAnnotation());
            }
            this.getAxis().removeAxisListener(this);
            this.getChart().putClientProperty(new Key(this.getAxis()), null);
            this.chart = chart;
            this.axisIdx = axisIdx;
            this.setEnable(false);
        }
    }

    public IlvDataInterval getThresholds() {
        return new IlvDataInterval(this.thresholds);
    }

    private void _setThresholds(IlvDataInterval itv) {
        this.thresholds = new IlvDataInterval(itv);
        this.update();
    }

    @Override
    public void axisRangeChanged(AxisRangeEvent evt) {
        if (evt.isChangedEvent() && !evt.isAdjusting() && !evt.isVisibleRangeEvent() && this.isEnable && (evt.getNewMin() != evt.getOldMin() || evt.getNewMax() != evt.getOldMax())) {
            this._setThresholds(new IlvDataInterval(Math.floor(evt.getNewMin()), Math.floor(evt.getNewMax())));
        }
    }

    @Override
    public void axisChanged(AxisChangeEvent evt) {
        if (evt.getType() == 1) {
            this.chart.setAntiAliasing(!evt.isAdjusting());
        }
    }

    public void adjustRange(double min) {
        this.adjustRange(new IlvDataInterval(min, min));
    }

    public void adjustRange(IlvDataInterval itv) {
        this.getAxis().setAdjusting(true);
        this._setThresholds(itv);
        this.getAxis().setAdjusting(false);
    }

    public void adjustRange() {
        if (!this.isEnable) {
            return;
        }
        IlvDataInterval range = null;
        IlvAxis axis = this.getAxis();
        range = axis.isBounded() ? axis.getDataRange() : axis.getVisibleRange();
        int min = (int)Math.floor(range.getMin());
        this.adjustRange(min);
    }

    public IlvChart getChart() {
        return this.chart;
    }

    public IlvDataIndicator getLowerIndicator() {
        return this.indicator == null ? null : this.indicator;
    }

    public IlvScaleAnnotation getLowerAnnotation() {
        return this.annotation == null ? null : this.annotation;
    }

    protected IlvDataIndicator createIndicators() {
        BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f}, 0.0f);
        IlvStyle style = new IlvStyle(IlvStyle.DEFAULT_STROKE, this.foreground, IlvColor.setAlpha(this.lowerColor, 0.2f));
        IlvDataIndicator indicator = new IlvDataIndicator(this.axisIdx, 0.0, null);
        indicator.setStyle(style);
        indicator.setDrawOrder(1);
        return indicator;
    }

    protected IlvScaleAnnotation createAnnotations() {
        if (this.getChart().getScale(this.getAxis()) == null) {
            return null;
        }
        IlvScaleAnnotation annotation = new IlvScaleAnnotation(0.0, null);
        this.configureRenderer(annotation.getLabelRenderer(), this.lowerColor);
        return annotation;
    }

    private void configureRenderer(IlvLabelRenderer labelRenderer, Color bg) {
        labelRenderer.setColor(Color.black);
        labelRenderer.setBackground(bg);
        labelRenderer.setOpaque(true);
        labelRenderer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(IlvColor.setAlpha(this.foreground, 1.0f)), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
    }

    @Override
    public IlvStyle getStyle(IlvDisplayPoint dp, IlvStyle style) {
        return style;
    }

    private void update() {
        IlvScale scale = this.getChart().getScale(this.getAxis());
        if (this.thresholds.isEmpty()) {
            if (this.getLowerIndicator() != null) {
                this.getLowerIndicator().setVisible(false);
            }
            if (this.getLowerAnnotation() != null) {
                scale.removeAnnotation(this.getLowerAnnotation());
            }
        } else {
            IlvScaleAnnotation anno;
            IlvDataIndicator indic = this.getLowerIndicator();
            if (indic != null) {
                if (indic.getType() == 0 || indic.getType() == 1) {
                    indic.setValue(this.thresholds.getMin());
                } else {
                    indic.setRange(new IlvDataInterval(-1.7976931348623157E308, this.thresholds.getMin()));
                }
                if (!indic.isVisible()) {
                    indic.setVisible(true);
                }
            }
            if ((anno = this.getLowerAnnotation()) != null) {
                anno.setValue(this.thresholds.getMin());
                if (anno.getScale() == null) {
                    scale.addAnnotation(anno);
                }
            }
        }
        this.getChart().getChartArea().repaint();
    }

    Paint getGradientPaint(float alpha) {
        double[] vals = new double[]{this.getAxis().getDataMin(), this.thresholds.getMin(), this.thresholds.getMin(), this.getAxis().getDataMax()};
        Color[] colors = new Color[]{IlvColor.setAlpha(this.lowerColor, alpha), IlvColor.setAlpha(this.lowerColor, alpha)};
        return new IlvValueGradientPaint(this.chart, 0, vals, colors);
    }

    public static void set(HorizLine t2, IlvChart chart, int axisIdx) {
        t2.setChart(chart, axisIdx);
    }

    public static HorizLine remove(IlvChart chart, int axisIdx) {
        HorizLine t2 = HorizLine.get(chart, axisIdx);
        if (t2 != null) {
            t2.setChart(null, -1);
        }
        return t2;
    }

    public static HorizLine get(IlvChart chart, int axisIdx) {
        IlvAxis axis = axisIdx == -1 ? chart.getXAxis() : chart.getYAxis(axisIdx);
        return (HorizLine)chart.getClientProperty(new Key(axis));
    }

    private static class Key {
        private IlvAxis axis;

        public Key(IlvAxis axis) {
            this.axis = axis;
        }

        public int hashCode() {
            return this.axis.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return key.axis == this.axis;
        }
    }
}

