/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.custindicator.horizontal;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartInteractor;
import ilog.views.chart.IlvColor;
import java.awt.Color;
import java.awt.event.MouseEvent;
import leaseLineQuote.candle.graph.ChartColors;
import leaseLineQuote.candle.graph.custindicator.horizontal.HorizLine;

public class HorizLineInteractor
extends IlvChartInteractor {
    private HorizLine horizLine;

    public HorizLineInteractor() {
        super(-1, 0);
        this.enableEvents(32L);
    }

    public synchronized void setThreshold(boolean isVisible) {
        IlvChart chart = this.getChart();
        if (isVisible) {
            if (this.horizLine == null) {
                Color lowerColor = IlvColor.setBrightness(IlvColor.yellow, 0.95f);
                this.horizLine = new HorizLine(ChartColors.CROSS_FOREGROUND, ChartColors.BACKGROUND, lowerColor);
            }
            HorizLine.set(this.horizLine, chart, 0);
            chart.getRenderer(0).setRenderingHint(this.horizLine);
        } else {
            HorizLine threshold = HorizLine.remove(chart, 0);
            chart.getRenderer(0).setRenderingHint(null);
        }
    }

    @Override
    public void chartConnected(IlvChart oldChart, IlvChart newChart) {
        this.setThreshold(true);
    }

    @Override
    public void processMouseMotionEvent(MouseEvent evt) {
        try {
            IlvChart chart = this.getChart();
            double dataY = chart.getYScale(0).toValue(evt.getX(), evt.getY());
            this.horizLine.adjustRange(dataY);
            evt.consume();
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
    }
}

