/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.custscales;

import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvStepsDefinition;
import ilog.views.chart.IlvTimeUnit;
import ilog.views.chart.util.IlvDoubleArray;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class CategoryTimeSteps
extends IlvStepsDefinition {
    private Date[] dates;
    private IlvDoubleArray steps;
    private IlvTimeUnit stepUnit;
    private IlvTimeUnit baseUnit;
    private DateFormat dateFormat;
    private Calendar calendar;
    private int categoryUnit;
    private int firstDate;
    private int intervalUnit;

    public CategoryTimeSteps(Date[] dates, IlvTimeUnit unit, int intervalUnit) {
        this.dates = dates;
        this.steps = new IlvDoubleArray();
        this.baseUnit = unit;
        this.stepUnit = unit;
        this.calendar = Calendar.getInstance();
        this.dateFormat = this.computeDateFormat();
        this.intervalUnit = intervalUnit;
    }

    private Calendar getCalendar(Date time) {
        this.calendar.setTime(time);
        return this.calendar;
    }

    public final IlvTimeUnit getBaseUnit() {
        return this.baseUnit;
    }

    @Override
    public void update() {
        this.steps.clear();
        IlvDataInterval range = this.getScale().getAxis().getVisibleRange();
        this.stepUnit = this.computeStepUnit(range);
        this.categoryUnit = (int)Math.ceil(this.stepUnit.getMillis() / this.baseUnit.getMillis());
        this.dateFormat = this.computeDateFormat();
        this.firstDate = this.getFirstDate(range);
        if (this.firstDate != -1) {
            int idx = this.firstDate;
            while ((double)idx < range.getMax() && idx < this.dates.length) {
                this.steps.add(idx);
                Date d2 = this.dates[idx];
                Calendar cal = this.getCalendar(d2);
                idx = Arrays.binarySearch(this.dates, (cal = this.stepUnit.incrementTime(cal)).getTime());
                if (idx >= 0) continue;
                idx = -idx - 1;
            }
        }
        this.steps.trim();
    }

    protected IlvTimeUnit computeStepUnit(IlvDataInterval range) {
        if (this.intervalUnit == 0) {
            double multDay = Math.round(this.baseUnit.getMillis() / IlvTimeUnit.DAY.getMillis());
            int days = (int)(multDay * range.getLength());
            if (days > 1460) {
                return IlvTimeUnit.YEAR;
            }
            if (days > 730) {
                return new TimeUnit(IlvTimeUnit.MONTH){

                    @Override
                    public String getFormatString() {
                        return "MM/yyyy";
                    }
                };
            }
            if (days > 120) {
                return new TimeUnit(IlvTimeUnit.MONTH){

                    @Override
                    public String getFormatString() {
                        return "MM/yyyy";
                    }
                };
            }
            return new TimeUnit(IlvTimeUnit.WEEK){

                @Override
                public String getFormatString() {
                    return "dd/MM";
                }
            };
        }
        int minutes = (int)range.getLength();
        if (minutes > 110) {
            return new TimeUnit(IlvTimeUnit.HOUR){

                @Override
                public String getFormatString() {
                    return "[dd/MM ^ HH:mm]";
                }
            };
        }
        return new TimeUnit(IlvTimeUnit.MINUTE){

            @Override
            public String getFormatString() {
                return "[dd/MM ^ HH:mm]";
            }
        };
    }

    private int getFirstDate(IlvDataInterval range) {
        if (range.getMax() < 0.0 || range.getMin() > (double)(this.dates.length - 1)) {
            return -1;
        }
        int min = (int)Math.ceil(range.getMin());
        if (this.categoryUnit == 1) {
            return min;
        }
        int idx = min < 0 ? 0 : min;
        Date d2 = this.dates[idx];
        Calendar cal = this.getCalendar(d2);
        if (!(cal = this.stepUnit.previousUnitTime(cal)).getTime().equals(d2)) {
            cal = this.stepUnit.incrementTime(cal);
        }
        return (idx = Arrays.binarySearch(this.dates, cal.getTime())) < 0 ? -idx - 1 : idx;
    }

    @Override
    public double previousStep(double v) {
        int idx = Arrays.binarySearch(this.steps.data(), v);
        if (idx < 0) {
            if ((idx = -idx - 2) == -1) {
                return this.firstDate - this.categoryUnit;
            }
            int count = this.steps.size();
            if (idx >= count) {
                return this.steps.get(count - 1) + (double)(this.categoryUnit * (idx - count + 1));
            }
        }
        return this.steps.get(idx);
    }

    @Override
    public double incrementStep(double v) {
        int idx = Arrays.binarySearch(this.steps.data(), v);
        if (idx < 0) {
            return v + (double)this.categoryUnit;
        }
        if (idx == this.steps.size() - 1) {
            return this.steps.get(idx) + (double)this.categoryUnit;
        }
        return this.steps.get(idx + 1);
    }

    protected DateFormat computeDateFormat() {
        String str = this.stepUnit.getFormatString();
        return new SimpleDateFormat(str);
    }

    @Override
    public String computeLabel(double value) {
        if (this.dates.length == 0) {
            return "0";
        }
        int i2 = (int)Math.round(value);
        Calendar cal = null;
        if (i2 < 0) {
            long m2 = this.dates[0].getTime() + (long)this.stepUnit.getMillis() * (long)i2;
            cal = this.getCalendar(new Date(m2));
        } else if (i2 >= this.dates.length) {
            long m3 = this.dates[this.dates.length - 1].getTime() + (long)this.stepUnit.getMillis() * (long)(this.dates.length - i2 + 1);
            cal = this.getCalendar(new Date(m3));
        } else {
            cal = this.getCalendar(this.dates[i2]);
        }
        return this.stepUnit.format(this.dateFormat, cal);
    }

    private static class TimeUnit
    extends IlvTimeUnit {
        protected IlvTimeUnit delegate;

        TimeUnit(IlvTimeUnit delegate) {
            this.delegate = delegate;
        }

        @Override
        public Calendar previousUnitTime(Calendar cal) {
            return this.delegate.previousUnitTime(cal);
        }

        @Override
        public Calendar incrementTime(Calendar cal) {
            return this.delegate.incrementTime(cal);
        }

        @Override
        public double getMillis() {
            return this.delegate.getMillis();
        }

        @Override
        public String getFormatString() {
            return this.delegate.getFormatString();
        }
    }
}

