/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.data.IlvDataSet;
import leaseLineQuote.candle.graph.indicator.IndicatorData;
import leaseLineQuote.candle.graph.indicator.IndicatorDataSet;
import leaseLineQuote.candle.graph.indicator.IndicatorUtil;
import leaseLineQuote.candle.graph.indicator.MovingAverageDataSet;

class BollingerBandsDataSet
extends IndicatorDataSet {
    private double coeff;
    private int idx = 0;

    public BollingerBandsDataSet(MovingAverageDataSet avg, double coeff) {
        super(new IlvDataSet[]{avg}, false);
        this.setMaxDataSetCount(1);
        this.coeff = coeff;
        this.updateIndicatorData();
    }

    @Override
    protected String getIndicatorName() {
        if (this.getDataSetCount() == 0) {
            return null;
        }
        MovingAverageDataSet avgDataSet = (MovingAverageDataSet)this.getDataSet(0);
        this.idx = this.coeff < 0.0 ? 1 : 2;
        return "Bollinger Bd" + this.idx + "(" + avgDataSet.getPeriod() + "," + this.coeff + ")";
    }

    @Override
    protected double[] computeIndicatorData() {
        if (this.getDataSetCount() == 0) {
            return null;
        }
        MovingAverageDataSet avgDataSet = (MovingAverageDataSet)this.getDataSet(0);
        double[] avgda = avgDataSet.computeIndicatorData();
        IlvDataSet dataSet = avgDataSet.getDataSet(0);
        if (dataSet == null) {
            return null;
        }
        IndicatorData data = IndicatorData.get(dataSet);
        if (data == null) {
            return null;
        }
        double[] stdDev = IndicatorUtil.computeStdDev(data, avgDataSet.getPeriod());
        int count = stdDev.length;
        double[] res = new double[count];
        double uv = this.getUndefValue();
        for (int i2 = 0; i2 < count; ++i2) {
            double v = avgda[i2];
            res[i2] = v == uv || stdDev[i2] == uv ? uv : v + this.coeff * stdDev[i2];
        }
        return res;
    }
}

