/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.data.IlvDataPoints;
import ilog.views.chart.data.IlvDataSet;
import leaseLineQuote.candle.datasource.StockDataSource;

public class IndicatorData {
    private static final String HEADER_DATA_KEY = "_HEADER_DATA_";
    public double[] data;
    public int headerLength;
    public int dataCount;

    private IndicatorData(double[] data, int headerLength, int dataCount) {
        this.data = data;
        this.headerLength = headerLength;
        this.dataCount = dataCount;
    }

    public static IndicatorData get(IlvDataSet dataSet) {
        if (dataSet instanceof StockDataSource.DataSet) {
            double[] vals = ((StockDataSource.DataSet)dataSet).getAllData();
            return new IndicatorData(vals, 0, vals.length);
        }
        IlvDataPoints pts = dataSet.getData();
        if (pts == null) {
            return null;
        }
        double[] vals = pts.getYValuesClone();
        return new IndicatorData(vals, 0, vals.length);
    }

    public static void setHeaderData(IlvDataSet dataSet, double[] data) {
        dataSet.putProperty(HEADER_DATA_KEY, data, false);
    }
}

