/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.data.IlvAbstractDataSource;
import ilog.views.chart.data.IlvDataSet;
import leaseLineQuote.candle.graph.indicator.DiffDataSet;
import leaseLineQuote.candle.graph.indicator.MovingAverageDataSet;
import leaseLineQuote.candle.graph.indicator.OSCDataSet;

class MACDDataSource
extends IlvAbstractDataSource {
    int fastPeriod;
    int slowPeriod;
    int signalPeriod;
    boolean divergence;

    public MACDDataSource(int fastPeriod, int slowPeriod, int signalPeriod, boolean divergence) {
        this.fastPeriod = fastPeriod;
        this.slowPeriod = slowPeriod;
        this.signalPeriod = signalPeriod;
        this.divergence = divergence;
    }

    public void setPriceDataSet(IlvDataSet priceDataSet) {
        IlvDataSet[] dataSets = null;
        if (priceDataSet != null) {
            int count = this.divergence ? 3 : 2;
            dataSets = new IlvDataSet[count];
            OSCDataSet macd = new OSCDataSet(priceDataSet, this.fastPeriod, this.slowPeriod);
            macd.setName("MACD(" + this.fastPeriod + "," + this.slowPeriod + ")");
            MovingAverageDataSet signal = new MovingAverageDataSet(macd, 2, this.signalPeriod);
            signal.setName("MACD EMA(" + this.signalPeriod + ")");
            dataSets[--count] = signal;
            dataSets[--count] = macd;
            if (this.divergence) {
                DiffDataSet div = new DiffDataSet(macd, signal);
                div.setName("Divergence");
                dataSets[--count] = div;
            }
        }
        this.getDataSetList().setDataSets(dataSets);
    }
}

