/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.data.IlvDataSet;
import leaseLineQuote.candle.graph.indicator.IndicatorData;
import leaseLineQuote.candle.graph.indicator.IndicatorUtil;
import leaseLineQuote.candle.graph.indicator.PeriodDataSet;

class StochasticDataSet
extends PeriodDataSet {
    public StochasticDataSet(IlvDataSet[] dataSets, int period) {
        super(dataSets, period);
        this.setMaxDataSetCount(3);
    }

    @Override
    protected String getIndicatorName() {
        return "%K(" + this.getPeriod() + ")";
    }

    @Override
    protected double[] computeIndicatorData() {
        if (this.getPeriod() == 0 || this.getDataSetCount() != 3) {
            return null;
        }
        IndicatorData hiData = IndicatorData.get(this.getDataSet(0));
        IndicatorData loData = IndicatorData.get(this.getDataSet(1));
        IndicatorData closeData = IndicatorData.get(this.getDataSet(2));
        return IndicatorUtil.computeStochastic(hiData, loData, closeData, this.getPeriod());
    }
}

