/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.data.IlvDataSet;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedHashMap;
import leaseLineQuote.candle.datasource.StockDataSource;
import leaseLineQuote.candle.graph.ChartColors;

public abstract class TechnicalIndicator
implements ChartColors {
    protected StockDataSource stockDS;
    protected IlvChart chart;

    public TechnicalIndicator(StockDataSource stockDS) {
        this.stockDS = stockDS;
    }

    public void attach(IlvChart chart) {
        if (this.chart != null) {
            throw new UnsupportedOperationException("Indicator already attached to a chart");
        }
        this.chart = chart;
    }

    public void detach() {
        this.chart = null;
    }

    public void refresh() {
    }

    public IlvDisplayPoint getHighlightedPoint(int dataIdx) {
        return null;
    }

    public abstract String getName();

    public IlvDataSet getMainDataSet() {
        return null;
    }

    public LinkedHashMap getDisplayPointMap(int dataIdx) {
        LinkedHashMap<String, IlvDisplayPoint> dataMap = new LinkedHashMap<String, IlvDisplayPoint>();
        try {
            Iterator rendererIterator = this.chart.getAllRendererIterator();
            while (rendererIterator.hasNext()) {
                IlvChartRenderer renderer = (IlvChartRenderer)rendererIterator.next();
                IlvDataSet[] dataSets = renderer.getDataSource().getDataSets();
                for (int i2 = 0; i2 < dataSets.length; ++i2) {
                    if (dataSets[i2].getDataCount() <= 0 || dataIdx >= dataSets[i2].getDataCount()) continue;
                    IlvDisplayPoint idp = renderer.getDisplayPoint(dataSets[i2], dataIdx);
                    if (dataSets[i2].getName().equalsIgnoreCase("FreeHand")) continue;
                    dataMap.put(dataSets[i2].getName(), idp);
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
        return dataMap;
    }

    public abstract void setColor(Color[] var1);

    public abstract void setCfg(Object var1);
}

